/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.x509;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Null;
import com.idoox.security.asn1.Oid;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.util.OID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;

public class AlgorithmId
extends Sequence {
    private String oid;
    protected AlgorithmParameters params;

    public AlgorithmId(String oid) throws Asn1Exception {
        this.oid = oid;
        this.addComponent(new Oid(this.oid));
        this.params = null;
        this.addComponent(new Null());
    }

    public AlgorithmId(String oid, AlgorithmParameters params) throws Asn1Exception {
        this.oid = oid;
        this.addComponent(new Oid(this.oid));
        this.params = params;
        try {
            if (params == null) {
                this.addComponent(new Null());
            } else {
                this.addComponent(Asn1.decode(params.getEncoded()));
            }
        }
        catch (IOException e) {
            throw new Asn1Exception(e.getMessage());
        }
    }

    public AlgorithmId(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.doDecode(bin);
        this.init();
    }

    public AlgorithmId(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.init();
    }

    public AlgorithmId(Sequence seq) throws Asn1Exception {
        super(seq.getComponents());
        this.init();
    }

    private void init() throws Asn1Exception {
        this.oid = ((Oid)this.components.get(0)).getOid();
        if (this.components.size() == 1) {
            return;
        }
        try {
            Null n = (Null)this.components.get(1);
            this.params = null;
            return;
        }
        catch (ClassCastException classCastException) {
            this.initAlgorithmParams((Asn1)this.components.get(1));
            return;
        }
    }

    protected void initAlgorithmParams(Asn1 params) throws Asn1Exception {
        try {
            String algName = OID.getAlgName(this.oid);
            this.params = AlgorithmParameters.getInstance(algName);
            this.params.init(params.encode());
        }
        catch (Exception e) {
            throw new Asn1Exception(e.getMessage());
        }
    }

    public String getOid() {
        return this.oid;
    }

    public AlgorithmParameters getParams() {
        return this.params;
    }
}

