/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.util;

import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Integer;
import com.idoox.security.asn1.Sequence;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;

public class DssSig
extends Sequence {
    private BigInteger r;
    private BigInteger s;

    public DssSig(BigInteger r, BigInteger s) {
        this.r = r;
        this.addComponent(new Integer(this.r));
        this.s = s;
        this.addComponent(new Integer(this.s));
    }

    public DssSig(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public DssSig(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.r = ((Integer)this.components.get(0)).getBigInt();
        this.s = ((Integer)this.components.get(1)).getBigInt();
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }
}

