/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.util;

import com.idoox.debug.Category;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.idoox.security.pstore.KeyStore;
import org.idoox.security.pstore.KeyStoreException;

public class CertUtilBase {
    private static final Category log = Category.getCategory("com.idoox.security.util.CertUtilBase");

    public static boolean isCertChainTrusted(Certificate[] certs, KeyStore kstore) {
        try {
            int i = 0;
            while (i < certs.length) {
                X509Certificate cert = (X509Certificate)certs[i];
                boolean retval = CertUtilBase.isCertTrusted(cert, kstore);
                if (retval) {
                    return retval;
                }
                int next = i + 1;
                if (next < certs.length && certs[next] instanceof X509Certificate) {
                    X509Certificate issuer_x509 = (X509Certificate)certs[next];
                    issuer_x509.checkValidity();
                    PublicKey issuer_public = issuer_x509.getPublicKey();
                    cert.verify(issuer_public);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (CertificateExpiredException e) {
        }
        catch (CertificateNotYetValidException e) {
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeyException e) {
        }
        catch (NoSuchProviderException e) {
        }
        catch (SignatureException e) {
        }
        catch (CertificateException e) {
            // empty catch block
        }
        return false;
    }

    public static boolean isCertTrusted(X509Certificate cert, KeyStore kstore) {
        try {
            cert.checkValidity();
            String Issuer = cert.getIssuerDN().toString();
            String Subject2 = cert.getSubjectDN().toString();
            Certificate[] Certs = null;
            try {
                Certs = kstore.getCertificateChain(Issuer);
            }
            catch (KeyStoreException e) {
                // empty catch block
            }
            if (Certs == null) {
                try {
                    Certs = kstore.getCertificateChain(Subject2);
                }
                catch (KeyStoreException e) {
                    // empty catch block
                }
                if (Certs == null) {
                    return false;
                }
                try {
                    return CertUtilBase.compareCert(cert, Certs[0]);
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (Issuer.equals(Subject2)) {
                return true;
            }
            int i = 0;
            while (i < Certs.length) {
                if (Certs[i] instanceof X509Certificate) {
                    X509Certificate issuer_x509 = (X509Certificate)Certs[i];
                    issuer_x509.checkValidity();
                    PublicKey issuer_public = issuer_x509.getPublicKey();
                    cert.verify(issuer_public);
                    boolean retval = CertUtilBase.isCertTrusted(issuer_x509, kstore);
                    if (retval) {
                        return retval;
                    }
                } else {
                    log.error("Certificate has not X.509 format.");
                }
                ++i;
            }
        }
        catch (CertificateExpiredException e) {
        }
        catch (CertificateNotYetValidException e) {
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeyException e) {
        }
        catch (NoSuchProviderException e) {
        }
        catch (SignatureException e) {
        }
        catch (CertificateException e) {
            // empty catch block
        }
        return false;
    }

    public static boolean compareCert(Certificate cert1, Certificate cert2) {
        if (cert1 == null) {
            return cert2 == null;
        }
        if (cert2 == null) {
            return false;
        }
        try {
            byte[] encoded = cert1.getEncoded();
            byte[] encodedOther = cert2.getEncoded();
            if (encoded.length != encodedOther.length) {
                return false;
            }
            int j = 1;
            while (j < encoded.length) {
                if (encoded[j] != encodedOther[j]) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        catch (CertificateEncodingException e) {
            return false;
        }
    }
}

