/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.util;

import com.idoox.debug.Category;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.pkcs.CertificationRequest;
import com.idoox.security.pkcs.CertificationRequestInfo;
import com.idoox.security.util.Random;
import com.idoox.security.x509.SubjectPublicKeyInfo;
import com.idoox.security.x509.X500Name;
import java.io.IOException;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;

public class CertReqGenerator {
    private Category dbg = Category.getCategory((class$com$idoox$security$util$CertReqGenerator == null ? (class$com$idoox$security$util$CertReqGenerator = CertReqGenerator.class$("com.idoox.security.util.CertReqGenerator")) : class$com$idoox$security$util$CertReqGenerator).getName());
    private static final String KEY_ALG_NAME = "RSA";
    private static final String SIG_ALG_NAME = "MD5WithRSA";
    private static final int KEY_SIZE = 1024;
    private X500Name subject = null;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private CertificationRequest request = null;
    static /* synthetic */ Class class$com$idoox$security$util$CertReqGenerator;

    public CertReqGenerator(X500Name name) {
        this.subject = name;
    }

    public CertReqGenerator(String commonName, String organizationUnit, String organizationName, String localityName, String stateName, String country, String emailAddress) throws CertificateException {
        StringBuffer sb = new StringBuffer();
        if (commonName == null) {
            throw new CertificateException("Common Name must be specified");
        }
        sb.append("CN=");
        sb.append(commonName);
        if (emailAddress != null) {
            sb.append(", EmailAddress=");
            sb.append(emailAddress);
        }
        if (organizationUnit != null) {
            sb.append(", OU=");
            sb.append(organizationUnit);
        }
        if (organizationName != null) {
            sb.append(", O=");
            sb.append(organizationName);
        }
        if (localityName != null) {
            sb.append(", L=");
            sb.append(localityName);
        }
        if (stateName != null) {
            sb.append(", ST=");
            sb.append(stateName);
        }
        if (country != null) {
            sb.append(", C=");
            sb.append(country);
        }
        String name = sb.toString();
        try {
            this.dbg.debug("Creating X500Name with dn: " + name);
            this.subject = new X500Name(name);
        }
        catch (Asn1Exception e) {
            this.dbg.debug("Exception during X500Name creation: " + e.getMessage());
        }
    }

    public void setKeyPair(KeyPair pair) {
        this.privateKey = pair.getPrivate();
        this.publicKey = pair.getPublic();
    }

    public void generate() throws SignatureException {
        Signature signature;
        this.dbg.debug("Generating Certification Request");
        if (this.request != null) {
            throw new SignatureException("Request is already generated");
        }
        if (this.privateKey == null) {
            KeyPairGenerator gen;
            this.dbg.warn("Certificate Request Generator is invoked with unset KeyPair!");
            try {
                gen = KeyPairGenerator.getInstance(KEY_ALG_NAME);
            }
            catch (NoSuchAlgorithmException e) {
                this.dbg.debug("Caught exception: " + e.getMessage());
                throw new SignatureException(e.getMessage());
            }
            gen.initialize(1024, Random.getRandom());
            KeyPair keyPair = gen.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            this.publicKey = keyPair.getPublic();
        }
        SubjectPublicKeyInfo pki = new SubjectPublicKeyInfo(this.publicKey);
        CertificationRequestInfo cri = new CertificationRequestInfo(this.subject, pki, null);
        try {
            signature = Signature.getInstance(SIG_ALG_NAME);
            signature.initSign(this.privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            this.dbg.debug("Caught exception: " + e.getMessage());
            throw new SignatureException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            this.dbg.debug("Caught exception: " + e.getMessage());
            throw new SignatureException(e.getMessage());
        }
        this.request = new CertificationRequest(cri, signature);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void writeRequest(PrintStream out) throws IOException {
        this.request.print(out);
    }

    public byte[] getRequest() {
        return this.request.encode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

