/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.util;

import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.util.Algorithms;
import com.idoox.security.util.OID;
import com.idoox.security.x509.AlgorithmId;

public class AlgorithmsTest {
    static void printAlgs(AlgorithmId[] algs) {
        int i = 0;
        while (i < algs.length) {
            System.out.println(algs[i].getOid() + "\t\t" + OID.getAlgName(algs[i].getOid()));
            ++i;
        }
        System.out.println();
    }

    public static void main(String[] args) {
        try {
            AlgorithmId[] algIds = Algorithms.getConfAlgs();
            System.out.println("Confidential algorithms:");
            AlgorithmsTest.printAlgs(algIds);
            algIds = Algorithms.getIntgAlgs();
            System.out.println("Integrity algorithms:");
            AlgorithmsTest.printAlgs(algIds);
            algIds = Algorithms.getOWFAlgs();
            System.out.println("OWF algorithms:");
            AlgorithmsTest.printAlgs(algIds);
            System.out.println("Intersection test");
            algIds = new AlgorithmId[]{new AlgorithmId("1.3.4.5.6.4"), new AlgorithmId("1.2.840.113549.1.1.4")};
            System.out.println("Wanted algorithms");
            AlgorithmsTest.printAlgs(algIds);
            algIds = Algorithms.getIntersection(algIds, 2);
            System.out.println("After test");
            AlgorithmsTest.printAlgs(algIds);
        }
        catch (Asn1Exception e) {
            e.printStackTrace();
        }
    }
}

