/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.util;

import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.util.OID;
import com.idoox.security.x509.AlgorithmId;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.idoox.security.SecurityConfigs;

public class Algorithms {
    private static AlgorithmId[] confAlgs = Algorithms.getAlgs("Cipher");
    private static AlgorithmId[] integAlgs = Algorithms.getAlgs("Signature");
    private static AlgorithmId[] owfAlgs = Algorithms.getAlgs("MessageDigest");
    public static final int KIND_CONF = 1;
    public static final int KIND_INTG = 2;
    public static final int KIND_OWF = 3;

    private static AlgorithmId[] getAlgs(String prefix) {
        int i = 1;
        ArrayList<String> algSet = new ArrayList<String>();
        String value = SecurityConfigs.getSecurityConfig().getProperty(prefix + "." + i);
        while (value != null) {
            algSet.add(value);
            value = SecurityConfigs.getSecurityConfig().getProperty(prefix + "." + ++i);
        }
        AlgorithmId[] algs = new AlgorithmId[algSet.size()];
        Iterator it = ((AbstractList)algSet).iterator();
        i = 0;
        while (it.hasNext()) {
            try {
                algs[i] = new AlgorithmId(OID.getAlgOid((String)it.next()));
                ++i;
            }
            catch (Asn1Exception e) {
                // empty catch block
            }
        }
        return algs;
    }

    public static AlgorithmId[] getConfAlgs() {
        return confAlgs;
    }

    public static AlgorithmId[] getIntgAlgs() {
        return integAlgs;
    }

    public static AlgorithmId[] getOWFAlgs() {
        return owfAlgs;
    }

    private static AlgorithmId[] getAlgs(int kind) {
        AlgorithmId[] retval;
        switch (kind) {
            case 1: {
                retval = Algorithms.getConfAlgs();
                break;
            }
            case 2: {
                retval = Algorithms.getIntgAlgs();
                break;
            }
            case 3: {
                retval = Algorithms.getOWFAlgs();
                break;
            }
            default: {
                return null;
            }
        }
        return retval;
    }

    public static AlgorithmId[] getIntersection(AlgorithmId[] algs, int kind) {
        ArrayList<AlgorithmId> list = new ArrayList<AlgorithmId>();
        int i = 0;
        while (i < algs.length) {
            if (Algorithms.isSupported(algs[i], kind)) {
                list.add(algs[i]);
            }
            ++i;
        }
        AlgorithmId[] retval = new AlgorithmId[list.size()];
        i = 0;
        while (i < list.size()) {
            retval[i] = (AlgorithmId)list.get(i);
            ++i;
        }
        return retval;
    }

    public static boolean isSupported(AlgorithmId alg, int kind) {
        AlgorithmId[] algs = Algorithms.getAlgs(kind);
        int i = 0;
        while (i < algs.length) {
            if (algs[i].getOid().equals(alg.getOid())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

