/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pkcs;

import com.idoox.debug.Category;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.pkcs.CertificationRequestInfo;
import com.idoox.security.util.Base64;
import com.idoox.security.util.OID;
import com.idoox.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.X509EncodedKeySpec;
import org.idoox.security.util.RuntimeWrappedException;

public class CertificationRequest
extends Sequence {
    private Category dbg = Category.getCategory((class$com$idoox$security$pkcs$CertificationRequest == null ? (class$com$idoox$security$pkcs$CertificationRequest = CertificationRequest.class$("com.idoox.security.pkcs.CertificationRequest")) : class$com$idoox$security$pkcs$CertificationRequest).getName());
    private CertificationRequestInfo reqInfo;
    private AlgorithmId sigAlgId;
    private byte[] signature;
    static /* synthetic */ Class class$com$idoox$security$pkcs$CertificationRequest;

    public CertificationRequest(CertificationRequestInfo reqInfo, Signature signature) throws SignatureException {
        this.reqInfo = reqInfo;
        this.addComponent(reqInfo);
        try {
            this.sigAlgId = new AlgorithmId(OID.getAlgOid(signature.getAlgorithm()));
        }
        catch (Asn1Exception asn1Exception) {
            // empty catch block
        }
        this.addComponent(this.sigAlgId);
        signature.update(reqInfo.encode());
        this.signature = signature.sign();
        this.addComponent(new BitString(this.signature));
    }

    public CertificationRequest(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public CertificationRequest(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    public void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.reqInfo = new CertificationRequestInfo(((Sequence)this.components.get(0)).encode());
        this.sigAlgId = new AlgorithmId(((Sequence)this.components.get(1)).encode());
        this.signature = ((BitString)this.components.get(2)).getBytes();
        if (!this.verifySignature()) {
            throw new Asn1Exception("Invalid signature found");
        }
    }

    public CertificationRequestInfo getRequestInfo() {
        return this.reqInfo;
    }

    public String getSigAlgName() {
        return OID.getAlgName(this.sigAlgId.getOid());
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public boolean verifySignature() {
        try {
            Signature sig = Signature.getInstance(this.getSigAlgName());
            KeyFactory kf = KeyFactory.getInstance(this.reqInfo.getSubjectPKInfo().getAlgorithmName());
            PublicKey pk = kf.generatePublic(new X509EncodedKeySpec(this.reqInfo.getSubjectPKInfo().encode()));
            sig.initVerify(pk);
            sig.update(this.reqInfo.encode());
            return sig.verify(this.signature);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void print(OutputStream out) throws IOException {
        try {
            out.write("-----BEGIN NEW CERTIFICATE REQUEST-----\n".getBytes("US-ASCII"));
            out.write(Base64.encode(this.encode()));
            out.write("-----END NEW CERTIFICATE REQUEST-----\n".getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

