/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pkcs;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Oid;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.asn1.SetOf;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

public class Attribute
extends Sequence {
    private String type;
    private List values;

    public Attribute(String type, List values) throws Asn1Exception {
        this.type = type;
        this.addComponent(new Oid(this.type));
        this.values = values;
        SetOf set = new SetOf();
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            set.addComponent((Asn1)it.next());
        }
        this.addComponent(set);
    }

    public Attribute(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public Attribute(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.type = ((Oid)this.components.get(0)).getOid();
        this.values = ((SetOf)this.components.get(1)).getComponents();
    }

    public String getType() {
        return this.type;
    }

    public List getValues() {
        return this.values;
    }
}

