/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.jaas;

import com.idoox.debug.Category;
import com.idoox.security.httpdigest.DigestCalculator;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.idoox.security.WASPPrincipal;
import org.idoox.security.httpdigest.AuthorizationStructure;
import org.idoox.security.jaas.HttpDigestAuthorizationCallback;
import org.idoox.security.jaas.UserStoreCallback;
import org.idoox.security.pstore.UserStore;

public class NameDigestLoginModule
implements LoginModule {
    private static Category log = Category.getCategory((class$com$idoox$security$jaas$NameDigestLoginModule == null ? (class$com$idoox$security$jaas$NameDigestLoginModule = NameDigestLoginModule.class$("com.idoox.security.jaas.NameDigestLoginModule")) : class$com$idoox$security$jaas$NameDigestLoginModule).getName());
    private CallbackHandler handler;
    private Subject subject;
    private boolean succeeded;
    private boolean commitSucceeded;
    private WASPPrincipal principal;
    static /* synthetic */ Class class$com$idoox$security$jaas$NameDigestLoginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.handler = callbackHandler;
        this.subject = subject;
    }

    public boolean login() throws LoginException {
        this.succeeded = false;
        AuthorizationStructure auth = null;
        try {
            Callback[] callbacks = new Callback[]{new HttpDigestAuthorizationCallback(), new UserStoreCallback()};
            this.handler.handle(callbacks);
            auth = ((HttpDigestAuthorizationCallback)callbacks[0]).getAuthorization();
            UserStore us = ((UserStoreCallback)callbacks[1]).getUserStore();
            String correctResponse = "";
            String password = (String)us.getUserProperty(auth.getUsername(), "password");
            correctResponse = DigestCalculator.digestCalcResponse(auth, auth.getUsername(), password, auth.getMethod());
            if (correctResponse == null || !correctResponse.equals(auth.getResponse())) {
                throw new FailedLoginException("User doesn't exist or bad password.");
            }
        }
        catch (IOException e) {
            throw new FailedLoginException("Cannot get information from the callback handler");
        }
        catch (UnsupportedCallbackException e) {
            throw new FailedLoginException("Configured callback handler does not handle required callback type");
        }
        catch (NoSuchAlgorithmException e) {
            throw new FailedLoginException("Configured callback handler does not handle required callback type");
        }
        this.principal = new WASPPrincipal(auth.getUsername());
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.principal)) {
            principals.add(this.principal);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            this.logout();
        } else {
            this.succeeded = false;
            this.principal = null;
        }
        return true;
    }

    public boolean logout() throws LoginException {
        Set<Principal> principals;
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded && (principals = this.subject.getPrincipals()).contains(this.principal)) {
            principals.remove(this.principal);
        }
        this.commitSucceeded = false;
        this.succeeded = false;
        this.principal = null;
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

