/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.jaas;

import com.idoox.debug.Category;
import com.idoox.security.jaas.HttpCredential;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.idoox.security.WASPPrincipal;

public class HttpLoginModule
implements LoginModule {
    private static Category dbg = Category.getCategory("com.idoox.security.jaas.HttpLoginModule");
    private CallbackHandler handler;
    private Subject subject;
    private boolean succeeded;
    private boolean commitSucceeded;
    private HttpCredential cred = null;
    private WASPPrincipal principal;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.handler = callbackHandler;
        this.subject = subject;
    }

    public boolean login() throws LoginException {
        this.succeeded = false;
        String name = null;
        char[] password = null;
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Enter name"), new PasswordCallback("Enter password", false)};
            this.handler.handle(callbacks);
            name = ((NameCallback)callbacks[0]).getName();
            password = ((PasswordCallback)callbacks[1]).getPassword();
        }
        catch (IOException e) {
            throw new FailedLoginException("Cannot get information from the callback handler");
        }
        catch (UnsupportedCallbackException e) {
            throw new FailedLoginException("Configured callback handler does not handle required callback type");
        }
        this.principal = new WASPPrincipal(name);
        this.cred = new HttpCredential(name, password);
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        Set<Object> creds;
        if (!this.succeeded) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.principal)) {
            principals.add(this.principal);
        }
        if (!(creds = this.subject.getPrivateCredentials()).contains(this.cred)) {
            creds.add(this.cred);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            this.logout();
        } else {
            this.succeeded = false;
            this.principal = null;
            this.cred = null;
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            Set<Object> creds;
            Set<Principal> principals = this.subject.getPrincipals();
            if (principals.contains(this.principal)) {
                principals.remove(this.principal);
            }
            if ((creds = this.subject.getPrivateCredentials()).contains(this.cred)) {
                creds.remove(this.cred);
            }
        }
        this.commitSucceeded = false;
        this.succeeded = false;
        this.principal = null;
        this.cred = null;
        return true;
    }
}

