/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.jaas;

import com.idoox.debug.Category;
import com.idoox.security.util.CertUtilBase;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.idoox.security.WASPPrincipal;
import org.idoox.security.jaas.CertificatesCallback;
import org.idoox.security.jaas.KeyStoreCallback;
import org.idoox.security.jaas.UserStoreCallback;
import org.idoox.security.pstore.KeyStore;
import org.idoox.security.pstore.UserEntry;
import org.idoox.security.pstore.UserIterator;
import org.idoox.security.pstore.UserStore;

public class CertsLoginModule
implements LoginModule {
    private static Category log = Category.getCategory((class$com$idoox$security$jaas$CertsLoginModule == null ? (class$com$idoox$security$jaas$CertsLoginModule = CertsLoginModule.class$("com.idoox.security.jaas.CertsLoginModule")) : class$com$idoox$security$jaas$CertsLoginModule).getName());
    private Subject subject;
    private CallbackHandler handler;
    private WASPPrincipal principal;
    private X509Certificate[] certificates;
    private boolean succeeded;
    private boolean commitSucceeded;
    static /* synthetic */ Class class$com$idoox$security$jaas$CertsLoginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
    }

    public boolean login() throws LoginException {
        this.succeeded = false;
        String name = null;
        Certificate[] certs = null;
        try {
            Callback[] callbacks = new Callback[]{new CertificatesCallback(), new UserStoreCallback(), new KeyStoreCallback()};
            this.handler.handle(callbacks);
            certs = ((CertificatesCallback)callbacks[0]).getCertificates();
            UserStore us = ((UserStoreCallback)callbacks[1]).getUserStore();
            KeyStore ks = ((KeyStoreCallback)callbacks[2]).getKeyStore();
            if (!CertUtilBase.isCertChainTrusted(certs, ks)) {
                throw new FailedLoginException("certificate is not trusted, " + certs[0]);
            }
            name = this.getUserId(us, (X509Certificate)certs[0]);
            if (name == null || name.length() == 0) {
                throw new FailedLoginException("cannot map certificate to name.");
            }
        }
        catch (IOException e) {
            throw new FailedLoginException("Cannot get information from the callback handler");
        }
        catch (UnsupportedCallbackException e) {
            throw new FailedLoginException("Configured callback handler does not handle required callback type");
        }
        this.principal = new WASPPrincipal(name);
        this.certificates = certs;
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        Set<Object> publicCreds;
        if (!this.succeeded) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.principal)) {
            principals.add(this.principal);
        }
        if (!(publicCreds = this.subject.getPublicCredentials()).contains(this.certificates)) {
            publicCreds.add(this.certificates);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            this.logout();
        } else {
            this.succeeded = false;
            this.principal = null;
            this.certificates = null;
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            Set<Object> publicCreds;
            Set<Principal> principals = this.subject.getPrincipals();
            if (principals.contains(this.principal)) {
                principals.remove(this.principal);
            }
            if ((publicCreds = this.subject.getPublicCredentials()).contains(this.certificates)) {
                publicCreds.remove(this.certificates);
            }
        }
        this.commitSucceeded = false;
        this.succeeded = false;
        this.principal = null;
        this.certificates = null;
        return true;
    }

    private String getUserId(UserStore userStore, X509Certificate cert) {
        HashMap<String, Object> filter = new HashMap<String, Object>(3);
        filter.put("X509Certificate", cert);
        UserIterator userIter = userStore.getUsers(filter);
        if (userIter.hasNext()) {
            UserEntry ue = userIter.next();
            return ue.getUserId();
        }
        filter.clear();
        filter.put("X509CertificateChain", new X509Certificate[]{cert});
        userIter = userStore.getUsers(filter);
        if (userIter.hasNext()) {
            UserEntry ue = userIter.next();
            return ue.getUserId();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

