/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.httpdigest;

import com.idoox.security.httpdigest.HttpDigestHelper;
import java.util.Map;
import org.idoox.security.httpdigest.AuthorizationStructure;

public class AuthorizationStructureImpl
implements AuthorizationStructure {
    String username = null;
    String realm = null;
    String nonce = null;
    String uri = null;
    String response = null;
    String algorithm = null;
    String cnonce = null;
    String opaque = null;
    String qop = null;
    String nc = null;
    String requestMethod = null;
    String created = null;
    String peer = null;

    public AuthorizationStructureImpl() {
    }

    public AuthorizationStructureImpl(String credentials, String peer) {
        if (credentials == null) {
            return;
        }
        this.peer = peer;
        Map credentialsMap = HttpDigestHelper.parseAuthorization(credentials);
        if (credentialsMap == null) {
            return;
        }
        this.username = (String)credentialsMap.get("username");
        this.realm = (String)credentialsMap.get("realm");
        this.nonce = (String)credentialsMap.get("nonce");
        this.uri = (String)credentialsMap.get("uri");
        this.response = (String)credentialsMap.get("response");
        this.algorithm = (String)credentialsMap.get("algorithm");
        this.cnonce = (String)credentialsMap.get("cnonce");
        this.opaque = (String)credentialsMap.get("opaque");
        this.qop = (String)credentialsMap.get("qop");
        this.nc = (String)credentialsMap.get("nc");
    }

    public Object clone() {
        AuthorizationStructureImpl ret = new AuthorizationStructureImpl();
        ret.username = this.username;
        ret.realm = this.realm;
        ret.nonce = this.nonce;
        ret.uri = this.uri;
        ret.response = this.response;
        ret.algorithm = this.algorithm;
        ret.cnonce = this.cnonce;
        ret.opaque = this.opaque;
        ret.qop = this.qop;
        ret.nc = this.nc;
        ret.peer = this.peer;
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String prefix = " ";
        sb.append("Digest");
        if (this.username != null) {
            sb.append(prefix).append("username=\"").append(this.username).append("\"");
            prefix = ", ";
        }
        if (this.realm != null) {
            sb.append(prefix).append("realm=\"").append(this.realm).append("\"");
            prefix = ", ";
        }
        if (this.nonce != null) {
            sb.append(prefix).append("nonce=\"").append(this.nonce).append("\"");
            prefix = ", ";
        }
        if (this.uri != null) {
            sb.append(prefix).append("uri=\"").append(this.uri).append("\"");
            prefix = ", ";
        }
        if (this.response != null) {
            sb.append(prefix).append("response=\"").append(this.response).append("\"");
            prefix = ", ";
        }
        if (this.algorithm != null) {
            sb.append(prefix).append("algorithm=\"").append(this.algorithm).append("\"");
            prefix = ", ";
        }
        if (this.opaque != null) {
            sb.append(prefix).append("opaque=\"").append(this.opaque).append("\"");
            prefix = ", ";
        }
        if (this.qop != null) {
            sb.append(prefix).append("qop=\"").append(this.qop).append("\"");
            prefix = ", ";
            if (this.cnonce != null) {
                sb.append(prefix).append("cnonce=\"").append(this.cnonce).append("\"");
                prefix = ", ";
            }
            if (this.nc != null) {
                sb.append(prefix).append("nc=").append(this.nc);
                prefix = ", ";
            }
        }
        return sb.toString();
    }

    public static String getNc(int nc) {
        String ncStr = Integer.toString(nc, 16);
        StringBuffer ncStr8 = new StringBuffer();
        char[] charBuff = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
        return ncStr8.append(charBuff, 0, 8 - ncStr.length()).append(ncStr).toString();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public void setCnonce(String cnonce) {
        this.cnonce = cnonce;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public String getQop() {
        return this.qop;
    }

    public void setQop(String qop) {
        this.qop = qop;
    }

    public String getNc() {
        return this.nc;
    }

    public void setNc(String nc) {
        this.nc = nc;
    }

    public String getMethod() {
        return this.requestMethod;
    }

    public void setMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getPeer() {
        return this.peer;
    }

    public void setPeer(String peer) {
        this.peer = peer;
    }
}

