/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.asn1;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Primitive;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.idoox.security.util.RuntimeWrappedException;

public class UTCTime
extends Primitive {
    public UTCTime() {
        this.tagNum = 23;
    }

    public UTCTime(int offset) {
        this.tagNum = 23;
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.add(11, offset);
        StringBuffer now = new StringBuffer();
        now.append(String.valueOf(cal.get(1)).substring(2, 4));
        UTCTime.append(now, cal.get(2) + 1);
        UTCTime.append(now, cal.get(5));
        UTCTime.append(now, cal.get(11));
        UTCTime.append(now, cal.get(12));
        now.append("Z");
        try {
            this.contents = now.toString().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public UTCTime(String value) {
        this.tagNum = 23;
        try {
            this.contents = value.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public static Asn1 decode(int tag, InputStream encoded, int[] length) throws Asn1Exception {
        UTCTime retval = new UTCTime();
        length[0] = length[0] + ((Asn1)retval).doDecode(tag, encoded);
        return retval;
    }

    public String getTime() {
        try {
            return new String(this.contents, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public Date getDate() {
        String utc;
        try {
            utc = new String(this.contents, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
        Date retval = null;
        int pos = 0;
        Calendar cal = null;
        pos = utc.indexOf(90);
        if (pos != -1) {
            cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        } else {
            pos = utc.indexOf(43);
            if (pos != -1 || (pos = utc.indexOf(45)) != -1) {
                TimeZone timeZone = TimeZone.getTimeZone("GMT" + utc.substring(pos));
                cal = Calendar.getInstance(timeZone);
            } else {
                return null;
            }
        }
        switch (pos) {
            case 10: {
                int year = Integer.parseInt(utc.substring(0, 2));
                year = year > 50 ? (year += 1900) : (year += 2000);
                int month = Integer.parseInt(utc.substring(2, 4)) - 1;
                int date = Integer.parseInt(utc.substring(4, 6));
                int hour = Integer.parseInt(utc.substring(6, 8));
                int minute = Integer.parseInt(utc.substring(8, 10));
                cal.set(year, month, date, hour, minute);
                break;
            }
            case 12: {
                int year = Integer.parseInt(utc.substring(0, 2));
                year = year > 50 ? (year += 1900) : (year += 2000);
                int month = Integer.parseInt(utc.substring(2, 4)) - 1;
                int date = Integer.parseInt(utc.substring(4, 6));
                int hour = Integer.parseInt(utc.substring(6, 8));
                int minute = Integer.parseInt(utc.substring(8, 10));
                int second = Integer.parseInt(utc.substring(10, 12));
                cal.set(year, month, date, hour, minute, second);
                break;
            }
        }
        retval = cal.getTime();
        return retval;
    }

    private static void append(StringBuffer sb, int number) {
        if (number < 10) {
            sb.append("0" + number);
        } else {
            sb.append(number);
        }
    }
}

