/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.asn1;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Asn1String;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Boolean;
import com.idoox.security.asn1.Enumerated;
import com.idoox.security.asn1.GeneralizedTime;
import com.idoox.security.asn1.Integer;
import com.idoox.security.asn1.Null;
import com.idoox.security.asn1.Oid;
import com.idoox.security.asn1.UTCTime;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Primitive
extends Asn1 {
    protected byte[] contents;

    public static Asn1 decode(int tag, InputStream encoded, int[] length) throws Asn1Exception {
        byte tagnum = (byte)(tag & 0x1F);
        byte cl = (byte)(tag & 0xFFFFFFC0);
        if (cl == 0) {
            switch (tagnum) {
                case 1: {
                    return Boolean.decode(tag, encoded, length);
                }
                case 2: {
                    return Integer.decode(tag, encoded, length);
                }
                case 3: {
                    return BitString.decode(tag, encoded, length);
                }
                case 5: {
                    return Null.decode(tag, encoded, length);
                }
                case 6: {
                    return Oid.decode(tag, encoded, length);
                }
                case 4: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 27: {
                    return Asn1String.decode(tag, encoded, length);
                }
                case 23: {
                    return UTCTime.decode(tag, encoded, length);
                }
                case 10: {
                    return Enumerated.decode(tag, encoded, length);
                }
                case 24: {
                    return GeneralizedTime.decode(tag, encoded, length);
                }
            }
            throw new Asn1Exception("Unknown universal tag " + tag);
        }
        if (cl == -128) {
            Primitive implicit = new Primitive();
            length[0] = length[0] + implicit.doDecode(tag, encoded);
            implicit.classType = (byte)-128;
            implicit.tagNum = tagnum;
            return implicit;
        }
        throw new Asn1Exception("unknown tag " + tag);
    }

    public int doDecode(int tag, InputStream encoded) throws Asn1Exception {
        int[] lengthInt = new int[]{0};
        int length = Asn1.decodeLengthOctets(encoded, lengthInt);
        if (length == -1) {
            throw new Asn1Exception("Indefinite encoding not yet supported");
        }
        if (length == 0) {
            this.contents = new byte[0];
            return lengthInt[0];
        }
        try {
            this.contents = new byte[length];
            DataInputStream in = new DataInputStream(encoded);
            in.readFully(this.contents);
            return length + lengthInt[0];
        }
        catch (IOException e) {
            throw new Asn1Exception(e.getMessage());
        }
    }

    public void doEncode(OutputStream encoded) throws IOException {
        if (this.contents != null) {
            encoded.write(this.contents);
        }
    }

    public void doTag(OutputStream encoded) throws IOException {
        if (this.tagNum < 31) {
            encoded.write((byte)(this.classType | this.tagNum));
        } else {
            encoded.write((byte)(this.classType | 0x1F));
            encoded.write(this.encodeHighTag(this.tagNum));
        }
    }

    protected int getContentsLen() {
        if (this.contents != null) {
            return this.contents.length;
        }
        return 0;
    }

    public byte[] getBytes() {
        return this.contents;
    }
}

