/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.asn1;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Primitive;
import java.io.InputStream;
import java.util.StringTokenizer;

public class Oid
extends Primitive {
    public Oid() {
        this.tagNum = 6;
    }

    public Oid(String value) throws Asn1Exception {
        this.tagNum = 6;
        this.contents = this.oidToBytes(value);
    }

    public static final Asn1 decode(int tag, InputStream encoded, int[] length) throws Asn1Exception {
        Oid retval = new Oid();
        length[0] = length[0] + ((Asn1)retval).doDecode(tag, encoded);
        return retval;
    }

    public String getOid() {
        StringBuffer retval = new StringBuffer();
        retval.append(this.contents[0] / 40);
        retval.append("." + this.contents[0] % 40);
        int next = 0;
        int i = 1;
        while (i < this.contents.length) {
            if ((this.contents[i] & 0x80) == 0) {
                next = next << 7 | this.contents[i];
                retval.append("." + next);
                next = 0;
            } else {
                next = next << 7 | this.contents[i] & 0x7F;
            }
            ++i;
        }
        return retval.toString();
    }

    private byte[] oidToBytes(String oid) throws Asn1Exception {
        StringTokenizer tknz = new StringTokenizer(oid, ".", false);
        int[] in = new int[tknz.countTokens()];
        int i = 0;
        while (i < in.length) {
            in[i] = Integer.parseInt(tknz.nextToken());
            ++i;
        }
        if (in.length < 2) {
            throw new Asn1Exception("Invalid oid format");
        }
        byte[] bytes = new byte[50];
        int index = 0;
        int i2 = in.length - 1;
        while (i2 > 1) {
            int next = in[i2];
            boolean isFirst = true;
            do {
                bytes[index] = (byte)(next & 0x7F | 0x80);
                if (isFirst) {
                    int n = index;
                    bytes[n] = (byte)(bytes[n] & 0x7F);
                    isFirst = false;
                }
                ++index;
            } while ((next >>>= 7) != 0);
            --i2;
        }
        byte[] retval = new byte[index + 1];
        int i3 = 1;
        while (i3 < index + 1) {
            retval[i3] = bytes[index - i3];
            ++i3;
        }
        retval[0] = (byte)(40 * in[0] + in[1]);
        return retval;
    }
}

