/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.debug;

import com.idoox.debug.ICategory;
import java.io.File;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggingEvent;

public class CategoryLog4J
implements ICategory {
    public static final String DEFAULT_CONFIG_LOCATION = "conf/log4j.config";
    private Category impl;
    private static final String defaultLayout = "%p: %c{2} - %m\n";

    public static void initialize(Map initParams) {
        String configFilePath = (String)initParams.get("log4j.configuration");
        if (configFilePath == null) {
            configFilePath = DEFAULT_CONFIG_LOCATION;
        }
        String location = (String)initParams.get("wasp.location");
        String txtLevel = (String)initParams.get("idoox.debug.level");
        Integer level = null;
        if (txtLevel != null) {
            try {
                level = Integer.valueOf(txtLevel);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        CategoryLog4J.init(location, configFilePath, level);
    }

    public static void init(String configLocation, String configFilePath, Integer level) {
        try {
            File configFile = null;
            if (configFilePath != null) {
                File config = new File(configFilePath);
                if (config.isAbsolute()) {
                    configFile = config;
                } else {
                    File confBase = null;
                    if (configLocation != null && configLocation.length() > 0) {
                        confBase = new File(configLocation);
                    }
                    if (confBase != null && confBase.exists()) {
                        configFile = new File(confBase, configFilePath);
                    }
                }
            }
            if (configFile != null && configFile.exists()) {
                PropertyConfigurator.configure((String)configFile.getCanonicalPath());
                if (level != null) {
                    Category root = Category.getRoot();
                    Priority priority = CategoryLog4J.level2priority(level);
                    root.setPriority(priority);
                }
            } else {
                PatternLayout l = new PatternLayout(defaultLayout);
                ConsoleAppender a = new ConsoleAppender((Layout)l, "System.err");
                BasicConfigurator.resetConfiguration();
                BasicConfigurator.configure((Appender)a);
                Category root = Category.getRoot();
                Priority priority = CategoryLog4J.level2priority(level);
                root.setPriority(priority);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static Priority level2priority(Integer level) {
        int l = 0;
        if (level != null) {
            l = level;
        }
        switch (l) {
            case 4: {
                return Priority.DEBUG;
            }
            case 3: {
                return Priority.INFO;
            }
            case 2: {
                return Priority.WARN;
            }
            case 1: {
                return Priority.ERROR;
            }
            case 0: {
                return Priority.FATAL;
            }
        }
        return Priority.DEBUG;
    }

    private CategoryLog4J(Category impl) {
        this.impl = impl;
    }

    public static ICategory getCategory(String name) {
        Category c = Category.getInstance((String)name);
        if (c != null) {
            return new CategoryLog4J(c);
        }
        return null;
    }

    public synchronized void addAppender(Appender newAppender) {
        this.impl.addAppender(newAppender);
    }

    public void assertLog(boolean assertion, String msg) {
        if (!assertion) {
            this.impl.error((Object)msg);
        }
    }

    public void callAppenders(LoggingEvent event) {
        this.impl.callAppenders(event);
    }

    public void debug(Object message) {
        this.impl.debug(message);
    }

    public void debug(String message) {
        this.impl.debug((Object)message);
    }

    public void debug(String message, Throwable t) {
        this.impl.debug((Object)message, t);
    }

    public void error(Object message) {
        this.impl.error(message);
    }

    public void error(String message) {
        this.impl.error((Object)message);
    }

    public void error(String message, Throwable t) {
        this.impl.error((Object)message, t);
    }

    public Enumeration getAllAppenders() {
        return this.impl.getAllAppenders();
    }

    public Appender getAppender(String name) {
        return this.impl.getAppender(name);
    }

    public Priority getChainedPriority() {
        return this.impl.getChainedPriority();
    }

    public static Enumeration getCurrentCategories() {
        return Category.getCurrentCategories();
    }

    public final String getName() {
        return this.impl.getName();
    }

    public final Priority getPriority() {
        return this.impl.getPriority();
    }

    public void info(Object message) {
        this.impl.info(message);
    }

    public void info(String message) {
        this.impl.info((Object)message);
    }

    public void info(String message, Throwable t) {
        this.impl.info((Object)message, t);
    }

    public boolean isDebugEnabled() {
        return this.impl.isDebugEnabled();
    }

    public boolean isEnabledFor(Priority priority) {
        return this.impl.isEnabledFor(priority);
    }

    public boolean isInfoEnabled() {
        return this.impl.isInfoEnabled();
    }

    public void l7dlog(Priority priority, String key, Throwable t) {
        this.impl.l7dlog(priority, key, t);
    }

    public void l7dlog(Priority priority, String key, Object[] params, Throwable t) {
        this.impl.l7dlog(priority, key, params, t);
    }

    public void log(Priority priority, String message, Throwable t) {
        this.impl.log(priority, (Object)message, t);
    }

    public void log(Priority priority, String message) {
        this.impl.log(priority, (Object)message);
    }

    public void log(String callerFQCN, Priority priority, String message, Throwable t) {
        this.impl.log(callerFQCN, priority, (Object)message, t);
    }

    public synchronized void removeAppender(Appender appender) {
        this.impl.removeAppender(appender);
    }

    public synchronized void removeAppender(String name) {
        this.impl.removeAppender(name);
    }

    public synchronized void removeAllAppenders() {
        this.impl.removeAllAppenders();
    }

    public void setAdditivity(boolean additive) {
        this.impl.setAdditivity(additive);
    }

    public void setPriority(Priority priority) {
        this.impl.setPriority(priority);
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.impl.setResourceBundle(bundle);
    }

    public void warn(Object message) {
        this.impl.warn(message);
    }

    public void warn(String message) {
        this.impl.warn((Object)message);
    }

    public void warn(String message, Throwable t) {
        this.impl.warn((Object)message, t);
    }

    public int getDebugLevel() {
        return this.getPriority().toInt();
    }

    public void setDebugLevel(int level) {
        this.setPriority(CategoryLog4J.level2priority(new Integer(level)));
    }

    static {
        CategoryLog4J.initialize(System.getProperties());
    }
}

