/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap12;

import com.idoox.soap.UnsupportedMediaTypeException;
import com.systinet.saaj.soap.SOAPElementImpl;
import com.systinet.saaj.soap12.common.SOAP12Constants;
import com.systinet.saaj.soap12.pools.SAAJNodePool;
import com.systinet.transport.util.ContentTypeParametersTokenizer;
import java.io.IOException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.idoox.transport.OutputMessage;

public class SOAPPartImpl
extends com.systinet.saaj.soap.SOAPPartImpl {
    public static final String ACTION_PARAMETER = "action";
    public static final String CONTENT_TYPE = "Content-Type";

    protected Name getEnvelopeName() {
        return SOAP12Constants.ENVELOPE;
    }

    protected SOAPElementImpl newEnvelope() {
        return (SOAPElementImpl)SAAJNodePool.getNode(1202);
    }

    protected String getSOAPContentType(String attachmentType) {
        if (attachmentType == null) {
            return "application/soap+xml";
        }
        if ("application/dime".equals(attachmentType)) {
            return "application/soap+xml";
        }
        return "application/soap+xml";
    }

    public void checkContentType(String attachmentType) throws SOAPException, IOException {
        String contentType = this.getContentType();
        if (contentType == null || !contentType.startsWith(this.getSOAPContentType(attachmentType)) && !contentType.startsWith("text/xml")) {
            throw new UnsupportedMediaTypeException(contentType);
        }
    }

    protected String getOutputContentType(String attachmentType) {
        return this.getSOAPContentType(attachmentType) + ";charset=UTF-8";
    }

    public Name getBodyName() {
        return SOAP12Constants.BODY;
    }

    public String getSOAPAction() throws IOException {
        String contentType = this.getContentType();
        String soapAction = null;
        if (contentType != null) {
            if (contentType.startsWith("text/xml")) {
                throw new UnsupportedMediaTypeException("text/xml");
            }
            if (contentType.startsWith("application/soap+xml")) {
                ContentTypeParametersTokenizer paramTokenizer = new ContentTypeParametersTokenizer(contentType);
                soapAction = paramTokenizer.getValueFor(ACTION_PARAMETER);
            } else {
                throw new RuntimeException("Bad content type " + contentType);
            }
        }
        return soapAction;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSOAPAction(String soapAction, String attachmentType) throws IOException {
        if (soapAction == null || soapAction.equals("")) {
            return;
        }
        String contentType = null;
        contentType = this.getContentType();
        String mediaType = null;
        if (contentType != null) {
            if (contentType.indexOf(ACTION_PARAMETER) >= 0) {
                ContentTypeParametersTokenizer paramTokenizer = new ContentTypeParametersTokenizer(contentType);
                this.setContentType(paramTokenizer.setValueFor(ACTION_PARAMETER, soapAction));
                return;
            }
            mediaType = contentType;
        } else {
            mediaType = this.getOutputContentType(attachmentType);
        }
        String actionParamenter = "action=\"" + soapAction + "\"";
        mediaType = this.appendContentParameter(mediaType, actionParamenter);
        this.setContentType(mediaType);
    }

    protected String appendContentParameter(String contentType, String parameter) {
        String trim;
        contentType = contentType.charAt(contentType.length() - 1) == ';' ? contentType + ' ' + parameter : ((trim = contentType.trim()).charAt(trim.length() - 1) == ';' ? contentType + ' ' + parameter : contentType + ';' + parameter);
        return contentType;
    }

    protected void writeContentType(OutputMessage out, String attachmentType) throws IOException {
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = this.getOutputContentType(attachmentType);
        }
        out.setContentType(contentType);
    }
}

