/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap.bc;

import com.systinet.saaj.soap.InitializableWaspSoapMessageImpl;
import com.systinet.saaj.soap.SOAPPartImpl;
import com.systinet.saaj.soap.bc.AbstractMessageImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xmlrpc.MessagePart;
import org.idoox.xmlrpc.MessageProcessingException;
import org.systinet.wasp.soap.WaspMessageFactory;
import org.systinet.wasp.soap.WaspSOAPMessage;

public class MessageImpl
extends AbstractMessageImpl {
    private Connection connection;
    private InitializableWaspSoapMessageImpl message;
    private WaspMessageFactory messageFactory;
    public static final QName ENCODING_STYLE_ATTR_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
    public static final QName MUST_UNDERSTAND_ATTR_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
    public static final QName ACTOR_ATTR_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "actor");

    public MessageImpl(WaspMessageFactory messageFactory, Connection connection) {
        this.init(messageFactory);
        this.connection = connection;
    }

    public MessageImpl(WaspMessageFactory messageFactory, InitializableWaspSoapMessageImpl message) {
        this.init(messageFactory);
        this.setMessage(message);
    }

    private void init(WaspMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    protected InitializableWaspSoapMessageImpl getMessage() {
        return this.message;
    }

    protected void setMessage(InitializableWaspSoapMessageImpl message) {
        this.message = message;
        if (message == null) {
            return;
        }
        message.setXmlRpcMessage(this);
        this.setPart((SOAPPartImpl)message.getSOAPPart());
    }

    public void initInput() throws IOException, MessageProcessingException {
        this.setInput(true);
        try {
            InitializableWaspSoapMessageImpl message = this.getMessage();
            String prefix = null;
            if (message != null) {
                prefix = message.getSOAPPart().getEnvelope().getElementName().getPrefix();
                message.release();
            }
            InputMessage inputMessage = this.connection.getInputMessage();
            InitializableWaspSoapMessageImpl newMessage = (InitializableWaspSoapMessageImpl)this.messageFactory.createMessage(null, (InputStream)inputMessage);
            if (prefix != null) {
                newMessage.setEnvelopePrefix(prefix);
            }
            this.setMessage(newMessage);
        }
        catch (SOAPException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public void initOutput() throws IOException {
        this.initOutput(false);
    }

    public void initOutput(boolean needsBody) throws IOException {
        this.setNeedsBody(needsBody);
        this.setInput(false);
        try {
            InitializableWaspSoapMessageImpl message = this.getMessage();
            String prefix = null;
            if (message != null) {
                prefix = message.getSOAPPart().getEnvelope().getElementName().getPrefix();
                message.release();
            }
            InitializableWaspSoapMessageImpl newMessage = (InitializableWaspSoapMessageImpl)this.messageFactory.createMessage();
            if (prefix != null) {
                newMessage.setEnvelopePrefix(prefix);
            }
            this.setMessage(newMessage);
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void initFault() throws IOException {
        this.initFault(false);
    }

    public void initFault(boolean needsBody) throws IOException {
        this.initOutput(needsBody);
    }

    public void send() throws IOException {
        this.finalizeBodyPart();
        if (this.isInput()) {
            return;
        }
        try {
            this.getMessage().writeTo((OutputStream)this.connection.getOutputMessage());
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void releaseMessagePart(MessagePart part) {
    }

    public WaspSOAPMessage getSOAPMessage() {
        return this.getMessage();
    }

    public MessageImpl(SOAPPartImpl part) {
        this.setPart(part);
    }
}

