/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap.bc;

import com.systinet.saaj.soap.InitializableWaspSoapMessageImpl;
import com.systinet.saaj.soap.bc.MessageImpl;
import com.systinet.saaj.soap12.bc.Message12Impl;
import org.idoox.transport.Connection;
import org.idoox.xmlrpc.Message;
import org.systinet.wasp.soap.WaspMessageFactory;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.soap.bc.IMessageConvertor;

public class MessageConvertorImpl
implements IMessageConvertor {
    public Message getMessage(WaspSOAPMessage soapMessage) {
        if (soapMessage == null) {
            return null;
        }
        InitializableWaspSoapMessageImpl waspSoapMessage = (InitializableWaspSoapMessageImpl)soapMessage;
        return waspSoapMessage.getXmlRpcMessage();
    }

    public Message convertSOAPMessage(WaspSOAPMessage soapMessage, boolean isInput, boolean needsBody) {
        Message xmlRpcMessage = this.getMessage(soapMessage);
        if (xmlRpcMessage != null) {
            return xmlRpcMessage;
        }
        MessageImpl message = BCMessageFactory.createNewMessage(soapMessage.getXMLProtocol(), (WaspMessageFactory)soapMessage.getMessageFactory(), (InitializableWaspSoapMessageImpl)soapMessage);
        message.setInput(isInput);
        message.setNeedsBody(needsBody);
        return message;
    }

    public WaspSOAPMessage convertMessage(Message soapMessage) {
        if (soapMessage == null) {
            return null;
        }
        if (!(soapMessage instanceof MessageImpl)) {
            return null;
        }
        return ((MessageImpl)soapMessage).getSOAPMessage();
    }

    public Message createMessage(String protocol, WaspMessageFactory messageFactory, Connection connection) {
        return BCMessageFactory.createNewMessage(protocol, messageFactory, connection);
    }

    private static class BCMessageFactory {
        private BCMessageFactory() {
        }

        public static MessageImpl createNewMessage(String protocol, WaspMessageFactory messageFactory, InitializableWaspSoapMessageImpl message) {
            if ("soap11".equals(protocol) || "httpget".equals(protocol)) {
                return new MessageImpl(messageFactory, message);
            }
            if ("soap12".equals(protocol)) {
                return new Message12Impl(messageFactory, message);
            }
            throw new RuntimeException("Unknown XML protocol '" + protocol + "'");
        }

        public static MessageImpl createNewMessage(String protocol, WaspMessageFactory messageFactory, Connection connection) {
            if ("soap11".equals(protocol) || "httpget".equals(protocol)) {
                return new MessageImpl(messageFactory, connection);
            }
            if ("soap12".equals(protocol)) {
                return new Message12Impl(messageFactory, connection);
            }
            throw new RuntimeException("Unknown XML protocol '" + protocol + "'");
        }
    }
}

