/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap.bc;

import com.idoox.xml.EscapingUTF8TokenWriter;
import com.systinet.saaj.soap.DetailImpl;
import com.systinet.saaj.soap.SOAPElementImpl;
import com.systinet.saaj.soap.SOAPFaultImpl;
import com.systinet.saaj.soap.bc.SOAPElementMessagePart;
import com.systinet.saaj.soap.bc.XmlRPCUtils;
import com.systinet.saaj.soap.util.ReleaseListener;
import com.systinet.wasp.soap.util.SAAJUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.ElementFinalizingTokenizerWrapper;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.XMLWriterReader;
import org.idoox.xmlrpc.Fault;

public class FaultImpl
extends SOAPElementMessagePart
implements Fault {
    private static final List EMPTY_LIST = new ArrayList(0);
    protected TokenWriter detailTokenWriter;
    boolean output;
    protected Tokenizer detailTokenizer;

    public FaultImpl(ReleaseListener listener, SOAPFaultImpl fault, boolean output) {
        super(listener);
        this.setSOAPElement(fault);
        this.output = output;
    }

    public QName getFaultCode() {
        SOAPFaultImpl faultElement = (SOAPFaultImpl)this.getSOAPElement();
        return SAAJUtils.stringToQName((SOAPElement)faultElement.getFaultCodeElement(), (String)faultElement.getFaultCode());
    }

    public void setFaultCode(QName faultCode) {
        if (this.detailTokenWriter != null) {
            throw new IllegalStateException("setFaultCode must be called before getDetailTokenWriter");
        }
        try {
            SOAPFaultImpl element = (SOAPFaultImpl)this.getSOAPElement();
            String ns = faultCode.getNamespaceURI();
            String prefix = null;
            if (ns == null) {
                ns = "";
            }
            if (ns.length() == 0) {
                String elDefaultNS = element.getNamespaceURI("");
                if (elDefaultNS == null || elDefaultNS.length() == 0) {
                    prefix = "";
                } else {
                    prefix = "";
                    element.addNamespaceDeclaration(prefix, ns);
                }
            } else {
                SOAPElementImpl elm = element;
                while (elm != null) {
                    Map prefixMap = elm.getPrefixMap();
                    prefix = this.getPrefixForNamespace(prefixMap, ns, prefix);
                    if (prefix != null) break;
                    elm = (SOAPElementImpl)elm.getParentElement();
                }
                if (prefix == null) {
                    prefix = this.getNewPrefix(element);
                    element.addNamespaceDeclaration(prefix, ns);
                    prefix = prefix + ":";
                } else {
                    prefix = prefix != null && prefix.length() > 0 ? prefix + ":" : "";
                }
            }
            element.setFaultCode(prefix + faultCode.getLocalPart());
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    private String getPrefixForNamespace(Map prefixMap, String ns, String prefix) {
        Iterator it = prefixMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!ns.equals(entry.getValue())) continue;
            prefix = (String)entry.getKey();
            break;
        }
        return prefix;
    }

    private String getNewPrefix(SOAPFault element) {
        int i = 0;
        while (element.getNamespaceURI("f" + i) != null) {
            ++i;
        }
        String prefix = "f" + i;
        return prefix;
    }

    public List getFaultSubcodes() {
        return EMPTY_LIST;
    }

    public void addFaultSubcode(QName subcode) {
    }

    public void clearFaultSubcodes() {
    }

    public String getFaultString() {
        return ((SOAPFault)this.getSOAPElement()).getFaultString();
    }

    public void setFaultString(String faultString) {
        if (this.detailTokenWriter != null) {
            throw new IllegalStateException("setFaultString must be called before getDetailTokenWriter");
        }
        try {
            ((SOAPFault)this.getSOAPElement()).setFaultString(faultString);
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public String getFaultReason() {
        return this.getFaultString();
    }

    public void setFaultReason(String faultReason) {
        this.setFaultString(faultReason);
    }

    public String getFaultActor() {
        return ((SOAPFault)this.getSOAPElement()).getFaultActor();
    }

    public void setFaultActor(String actor) {
        if (this.detailTokenWriter != null) {
            throw new IllegalStateException("setActor must be called before getDetailTokenWriter");
        }
        try {
            ((SOAPFault)this.getSOAPElement()).setFaultActor(actor);
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public String getFaultRole() {
        return this.getFaultActor();
    }

    public void setFaultRole(String role) {
        this.setFaultActor(role);
    }

    public String getFaultNode() {
        return null;
    }

    public void setFaultNode(String node) {
    }

    public Tokenizer getDetailTokenizer() throws IOException {
        if (this.output) {
            throw new IllegalStateException("Write-only fault");
        }
        if (this.detailTokenizer == null) {
            DetailImpl detail = (DetailImpl)((SOAPFault)this.getSOAPElement()).getDetail();
            if (detail == null) {
                return null;
            }
            this.detailTokenizer = detail.getTokenizer();
            try {
                byte n;
                while ((n = this.detailTokenizer.next()) != 2 && n != 3 && n != 1) {
                }
            }
            catch (TokenizerException e) {
                throw new RuntimeWrappedException((Throwable)e);
            }
        }
        return this.detailTokenizer;
    }

    public TokenWriter getDetailTokenWriter() throws IOException {
        if (!this.output) {
            throw new IllegalStateException("Read-only fault");
        }
        if (this.detailTokenWriter == null) {
            XMLWriterReader writer = new XMLWriterReader();
            this.detailTokenWriter = new EscapingUTF8TokenWriter((TokenWriter)writer);
            SOAPFault soapFault = (SOAPFault)this.getSOAPElement();
            SOAPElementImpl detailElement = (SOAPElementImpl)soapFault.getDetail();
            if (detailElement != null) {
                Node soapNode;
                ArrayList<Node> tmpList = new ArrayList<Node>(20);
                Iterator it = detailElement.getChildElements();
                while (it.hasNext()) {
                    soapNode = (Node)it.next();
                    tmpList.add(soapNode);
                }
                it = tmpList.iterator();
                while (it.hasNext()) {
                    soapNode = (Node)it.next();
                    soapNode.detachNode();
                    soapNode.recycleNode();
                }
            } else {
                try {
                    detailElement = (SOAPElementImpl)soapFault.addDetail();
                }
                catch (SOAPException e) {
                    throw new RuntimeWrappedException((Throwable)e);
                }
            }
            SOAPElementImpl detail = (SOAPElementImpl)soapFault.getDetail();
            Tokenizer content = XmlRPCUtils.setupElementStartingTokenWriter(this.detailTokenWriter, (Tokenizer)writer, detail);
            ElementFinalizingTokenizerWrapper detailTokenizer = new ElementFinalizingTokenizerWrapper(content, (SOAPElement)detail);
            ElementFinalizingTokenizerWrapper faultTokenzier = new ElementFinalizingTokenizerWrapper((Tokenizer)detailTokenizer, (SOAPElement)soapFault);
            SOAPElement body = soapFault.getParentElement();
            ElementFinalizingTokenizerWrapper bodyTokenzier = new ElementFinalizingTokenizerWrapper((Tokenizer)faultTokenzier, body);
            ElementFinalizingTokenizerWrapper envelopeTokenzier = new ElementFinalizingTokenizerWrapper((Tokenizer)bodyTokenzier, body.getParentElement());
            detailElement.setTokenizer((Tokenizer)envelopeTokenzier);
        }
        return this.detailTokenWriter;
    }

    public void send() throws IOException {
        if (this.detailTokenWriter != null) {
            this.detailTokenWriter.leave();
        }
    }
}

