/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap.bc;

import com.systinet.saaj.soap.NameImpl;
import com.systinet.saaj.soap.ParseException;
import com.systinet.saaj.soap.SOAPBodyImpl;
import com.systinet.saaj.soap.SOAPEnvelopeImpl;
import com.systinet.saaj.soap.SOAPFaultImpl;
import com.systinet.saaj.soap.SOAPHeaderElementImpl;
import com.systinet.saaj.soap.SOAPHeaderImpl;
import com.systinet.saaj.soap.SOAPPartImpl;
import com.systinet.saaj.soap.bc.AbstractMessagePart;
import com.systinet.saaj.soap.bc.BodyPartImpl;
import com.systinet.saaj.soap.bc.FaultImpl;
import com.systinet.saaj.soap.bc.HeaderPartImpl;
import com.systinet.saaj.soap.bc.MessageImpl;
import com.systinet.saaj.soap.bc.XmlRPCUtils;
import com.systinet.saaj.soap.util.ReleaseListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.Fault;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MessagePart;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.MultipleHeadersException;

public abstract class AbstractMessageImpl
implements Message,
ReleaseListener {
    private SOAPPartImpl part;
    private Map headersMap = new WeakHashMap(13);
    private AbstractMessagePart bodyPart;
    private FaultImpl faultPart;
    private Token token = new Token();
    private boolean needsBody = false;
    private boolean isInput = false;
    private DeclaredPrefixesStack dpStack = new DeclaredPrefixesStack();

    public AbstractMessageImpl() {
    }

    public AbstractMessageImpl(SOAPPartImpl part) {
        this();
        this.setPart(part);
    }

    public abstract void initInput() throws IOException, MessageProcessingException;

    public abstract void initFault() throws IOException;

    public abstract void initFault(boolean var1) throws IOException;

    public abstract void initOutput() throws IOException;

    public abstract void initOutput(boolean var1) throws IOException;

    public abstract void send() throws IOException;

    /*
     * WARNING - void declaration
     */
    public int getHeaderCount() {
        try {
            void e;
            int result = 0;
            SOAPEnvelope envelope = this.part.getEnvelope();
            SOAPHeader header = envelope.getHeader();
            if (header == null) {
                return 0;
            }
            Iterator it = header.getChildElements();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof SOAPHeaderElement)) continue;
                ++result;
            }
            return (int)e;
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public Tokenizer getHeader(int pos) {
        return this.getHeaderAsPart(pos).getTokenizer();
    }

    public Tokenizer getHeader(QName headerName) throws MultipleHeadersException {
        MessagePart headerAsPart = this.getHeaderAsPart(headerName);
        if (headerAsPart == null) {
            return null;
        }
        return headerAsPart.getTokenizer();
    }

    public MessagePart getHeaderAsPart(int pos) {
        try {
            SOAPHeaderElementImpl header = this.getHeaderElement(pos);
            HeaderPartImpl result = this.getHeaderPart(header);
            return result;
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public MessagePart getHeaderAsPart(QName headerName) throws MultipleHeadersException {
        try {
            SOAPHeaderElementImpl header = this.getHeaderElement(headerName);
            if (header == null) {
                return null;
            }
            HeaderPartImpl result = this.getHeaderPart(header);
            return result;
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public String getHeaderAsString(int pos) throws MessageProcessingException {
        try {
            SOAPHeaderElementImpl header = this.getHeaderElement(pos);
            HeaderPartImpl part = this.getHeaderPart(header);
            String result = part.getStringContent();
            this.removeHeader(pos);
            return result;
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public String getHeaderAsString(QName headerName) throws MessageProcessingException, MultipleHeadersException {
        try {
            SOAPHeaderElementImpl header = this.getHeaderElement(headerName);
            if (header == null) {
                return null;
            }
            HeaderPartImpl part = this.getHeaderPart(header);
            String result = part.getStringContent();
            this.removeHeader(headerName);
            return result;
        }
        catch (SOAPException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public void addHeader(Tokenizer content) throws TokenizerException, IOException, MessageProcessingException {
        try {
            content.readToken(this.token);
            SOAPHeaderImpl header = this.getSOAPHeader();
            this.dpStack.used = 0;
            content.pushNewlyDeclaredPrefixes(this.dpStack);
            content.next();
            header.addChildElement(content, this.token, this.dpStack, false);
        }
        catch (SOAPException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (ParseException e) {
            throw new MessageProcessingException((Throwable)((Object)e));
        }
    }

    public void addHeader(Tokenizer content, int pos) throws TokenizerException, IOException, MessageProcessingException {
        try {
            content.readToken(this.token);
            SOAPHeaderImpl header = this.getSOAPHeader();
            this.dpStack.used = 0;
            content.pushNewlyDeclaredPrefixes(this.dpStack);
            content.next();
            header.addChildElement(pos, content, this.token, this.dpStack, false);
        }
        catch (SOAPException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (ParseException e) {
            throw new MessageProcessingException((Throwable)((Object)e));
        }
    }

    public void addHeader(QName headerName, Map properties, Tokenizer content) throws IOException {
        try {
            XmlRPCUtils.createToken(headerName, properties, this.token, "http://schemas.xmlsoap.org/soap/actor/next");
            SOAPHeaderImpl header = this.getSOAPHeader();
            header.addChildElement(content, this.token, null, false);
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
        catch (ParseException e) {
            throw new RuntimeWrappedException((Throwable)((Object)e));
        }
    }

    public void addHeader(QName headerName, Map properties, Tokenizer content, int pos) throws IOException {
        try {
            XmlRPCUtils.createToken(headerName, properties, this.token, "http://schemas.xmlsoap.org/soap/actor/next");
            SOAPHeaderImpl header = this.getSOAPHeader();
            header.addChildElement(pos, content, this.token, null, false);
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
        catch (ParseException e) {
            throw new RuntimeWrappedException((Throwable)((Object)e));
        }
    }

    public void addHeader(QName headerName, Map properties, String content) throws IOException {
        try {
            SOAPHeaderImpl header = this.getSOAPHeader();
            SOAPEnvelope env = this.part.getEnvelope();
            Name name = env.createName(headerName.getLocalPart(), null, headerName.getNamespaceURI());
            SOAPElement child = header.addChildElement(name);
            child.addTextNode(content);
            this.addAttributes(child, properties);
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void addHeader(QName headerName, Map properties, String content, int pos) throws IOException {
        try {
            SOAPHeaderImpl header = this.getSOAPHeader();
            SOAPEnvelope env = this.part.getEnvelope();
            Name name = env.createName(headerName.getLocalPart(), null, headerName.getNamespaceURI());
            SOAPElement child = header.addChildElement(pos, name);
            child.addTextNode(content);
            this.addAttributes(child, properties);
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void removeHeader(int pos) {
        try {
            SOAPHeaderElementImpl header = this.getHeaderElement(pos);
            HeaderPartImpl part = this.removeHeaderPart(header);
            header.detachNode();
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void removeHeader(QName headerName) throws MultipleHeadersException {
        try {
            SOAPHeaderElementImpl header = this.getHeaderElement(headerName);
            if (header == null) {
                return;
            }
            header.detachNode();
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public MessagePart getBody() throws MessageProcessingException {
        try {
            SOAPBodyImpl body = (SOAPBodyImpl)this.part.getEnvelope().getBody();
            return this.getBodyPart(body, this.needsBody, this.isInput);
        }
        catch (SOAPException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public MessagePart createBody() throws IOException {
        try {
            SOAPEnvelope envelope = this.part.getEnvelope();
            SOAPBodyImpl body = (SOAPBodyImpl)envelope.getBody();
            body.detachNode();
            body.recycleNode();
            body = (SOAPBodyImpl)envelope.addBody();
            return this.getBodyPart(body, this.needsBody, this.isInput);
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public MessagePart createBody(Tokenizer bodyTokenizer) throws TokenizerException, IOException, MessageProcessingException {
        try {
            SOAPEnvelopeImpl envelope = (SOAPEnvelopeImpl)this.part.getEnvelope();
            bodyTokenizer.readToken(this.token);
            this.dpStack.used = 0;
            bodyTokenizer.pushNewlyDeclaredPrefixes(this.dpStack);
            bodyTokenizer.next();
            SOAPBodyImpl body = (SOAPBodyImpl)envelope.addChildElement(bodyTokenizer, null, null, false);
            return this.getBodyPart(body, this.needsBody, this.isInput);
        }
        catch (SOAPException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (ParseException e) {
            throw new MessageProcessingException((Throwable)((Object)e));
        }
    }

    public Fault getFault() throws MessageProcessingException {
        try {
            SOAPFaultImpl fault = (SOAPFaultImpl)this.part.getEnvelope().getBody().getFault();
            return this.getFaultPart(fault, false);
        }
        catch (SOAPException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public boolean isFault() throws MessageProcessingException {
        try {
            return this.part.getEnvelope().getBody().hasFault();
        }
        catch (SOAPException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public Fault createFault() throws IOException {
        try {
            SOAPBody body = this.part.getEnvelope().getBody();
            SOAPFaultImpl fault = (SOAPFaultImpl)body.addFault();
            return this.getFaultPart(fault, true);
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getElementAttribute(QName attributeName, int location) {
        try {
            void e;
            SOAPEnvelope envelope = this.part.getEnvelope();
            NameImpl name = (NameImpl)envelope.createName(attributeName.getLocalPart(), null, attributeName.getNamespaceURI());
            switch (location) {
                case 0: {
                    String result = envelope.getAttributeValue((Name)name);
                    break;
                }
                case 1: {
                    SOAPHeader header = envelope.getHeader();
                    if (header == null) {
                        return null;
                    }
                    String result = header.getAttributeValue((Name)name);
                    break;
                }
                case 2: {
                    String result = envelope.getBody().getAttributeValue((Name)name);
                    break;
                }
                default: {
                    String result = null;
                }
            }
            name.release();
            return e;
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void setElementAttribute(QName attributeName, String attributeValue, int location) {
        try {
            SOAPEnvelope envelope = this.part.getEnvelope();
            NameImpl name = (NameImpl)envelope.createName(attributeName.getLocalPart(), null, attributeName.getNamespaceURI());
            switch (location) {
                case 0: {
                    envelope.addAttribute((Name)name, attributeValue);
                    return;
                }
                case 1: {
                    SOAPHeaderImpl header = this.getSOAPHeader();
                    header.addAttribute(name, attributeValue);
                    return;
                }
                case 2: {
                    envelope.getBody().addAttribute((Name)name, attributeValue);
                    return;
                }
            }
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public String getNamespace(String prefix, int location) {
        try {
            SOAPEnvelope envelope = this.part.getEnvelope();
            switch (location) {
                case 0: {
                    return envelope.getNamespaceURI(prefix);
                }
                case 1: {
                    SOAPHeader header = envelope.getHeader();
                    if (header == null) {
                        return null;
                    }
                    return header.getNamespaceURI(prefix);
                }
                case 2: {
                    return envelope.getBody().getNamespaceURI(prefix);
                }
            }
            return null;
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void setNamespace(String prefix, String namespace, int location) {
        try {
            SOAPEnvelope envelope = this.part.getEnvelope();
            switch (location) {
                case 0: {
                    envelope.addNamespaceDeclaration(prefix, namespace);
                    return;
                }
                case 1: {
                    SOAPHeaderImpl header = this.getSOAPHeader();
                    header.addNamespaceDeclaration(prefix, namespace);
                    return;
                }
                case 2: {
                    envelope.getBody().addNamespaceDeclaration(prefix, namespace);
                    return;
                }
            }
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void releaseMessagePart(MessagePart part) {
    }

    public QName getAttrQNameEncodingStyle() {
        return MessageImpl.ENCODING_STYLE_ATTR_QNAME;
    }

    public QName getAttrQNameMustUnderstand() {
        return MessageImpl.MUST_UNDERSTAND_ATTR_QNAME;
    }

    public QName getAttrQNameRole() {
        return MessageImpl.ACTOR_ATTR_QNAME;
    }

    private SOAPHeaderElementImpl getHeaderElement(int pos) throws SOAPException {
        SOAPHeader head = this.part.getEnvelope().getHeader();
        if (head == null) {
            throw new SOAPException((Throwable)new IndexOutOfBoundsException());
        }
        Iterator it = head.getChildElements();
        int i = 0;
        Object node = null;
        while (it.hasNext()) {
            node = it.next();
            if (node instanceof SOAPHeaderElement) {
                ++i;
            }
            if (i > pos) break;
        }
        if (node == null || i <= pos) {
            throw new IndexOutOfBoundsException("Message has only " + i + " headers. Get header at possition " + pos + " failed");
        }
        SOAPHeaderElementImpl header = node;
        return header;
    }

    private SOAPHeaderElementImpl getHeaderElement(QName headerName) throws SOAPException, MultipleHeadersException {
        SOAPEnvelope envelope = this.part.getEnvelope();
        NameImpl name = (NameImpl)envelope.createName(headerName.getLocalPart(), null, headerName.getNamespaceURI());
        SOAPHeader soapheader = envelope.getHeader();
        if (soapheader == null) {
            return null;
        }
        Iterator it = soapheader.getChildElements((Name)name);
        if (!it.hasNext()) {
            return null;
        }
        SOAPHeaderElementImpl header = (SOAPHeaderElementImpl)it.next();
        if (it.hasNext()) {
            throw new MultipleHeadersException("Multiple headers with name:" + headerName);
        }
        name.release();
        return header;
    }

    private HeaderPartImpl getHeaderPart(SOAPHeaderElementImpl header) {
        HeaderPartImpl result = (HeaderPartImpl)this.headersMap.get(header);
        if (result == null) {
            result = new HeaderPartImpl((ReleaseListener)this, header);
            this.headersMap.put(header, result);
        }
        return result;
    }

    private HeaderPartImpl removeHeaderPart(SOAPHeaderElementImpl header) {
        HeaderPartImpl result = (HeaderPartImpl)this.headersMap.remove(header);
        return result;
    }

    private MessagePart getBodyPart(SOAPBodyImpl body, boolean needsBody, boolean isInput) {
        if (this.bodyPart != null && body == this.bodyPart.getSOAPElement()) {
            return this.bodyPart;
        }
        this.bodyPart = new BodyPartImpl(this, body, needsBody, isInput);
        return this.bodyPart;
    }

    private Fault getFaultPart(SOAPFaultImpl fault, boolean isInput) {
        if (fault == null) {
            return null;
        }
        if (this.faultPart != null && fault == this.faultPart.getSOAPElement()) {
            return this.faultPart;
        }
        this.faultPart = this.newFault(this, fault, isInput);
        return this.faultPart;
    }

    private void addAttributes(SOAPElement child, Map properties) throws SOAPException {
        if (properties == null) {
            return;
        }
        Iterator it = properties.entrySet().iterator();
        SOAPEnvelope env = this.part.getEnvelope();
        String[] qname = new String[2];
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Name attr = null;
            String value = (String)entry.getValue();
            qname[1] = null;
            if (key instanceof QName) {
                QName qName = (QName)key;
                XmlRPCUtils.propertyNameToQName(qName, value, qname, "http://schemas.xmlsoap.org/soap/actor/next");
            }
            if (qname[1] == null) continue;
            attr = env.createName(qname[1], null, qname[0]);
            child.addAttribute(attr, value);
        }
    }

    private SOAPHeaderImpl getSOAPHeader() throws SOAPException {
        SOAPEnvelope envelope = this.part.getEnvelope();
        SOAPHeaderImpl header = (SOAPHeaderImpl)envelope.getHeader();
        if (header == null) {
            header = (SOAPHeaderImpl)envelope.addHeader();
        }
        return header;
    }

    protected FaultImpl newFault(ReleaseListener listener, SOAPFaultImpl fault, boolean output) {
        return new FaultImpl(listener, fault, output);
    }

    public SOAPPartImpl getPart() {
        return this.part;
    }

    protected void setPart(SOAPPartImpl part) {
        this.part = part;
    }

    protected boolean isNeedsBody() {
        return this.needsBody;
    }

    public void setNeedsBody(boolean needsBody) {
        this.needsBody = needsBody;
    }

    protected boolean isInput() {
        return this.isInput;
    }

    public void setInput(boolean input) {
        this.isInput = input;
    }

    protected void finalizeBodyPart() throws IOException {
        if (this.bodyPart != null) {
            ((BodyPartImpl)this.bodyPart).finalize();
        }
    }

    public void released(Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof SOAPHeaderElement) {
            this.headersMap.remove(node);
        } else if (node instanceof SOAPBody) {
            this.bodyPart = null;
        } else if (node instanceof SOAPFault) {
            this.faultPart = null;
        }
    }
}

