/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import com.idoox.soap.EnvelopeCaching;
import com.idoox.soap.EnvelopeOutCache;
import com.idoox.soap.UnsupportedMediaTypeException;
import com.idoox.soap.VersionMismatchException;
import com.idoox.util.StreamReaderWriterPool;
import com.idoox.xml.DocumentBuilderFactory;
import com.idoox.xml.Element2Tokenizer;
import com.idoox.xml.Tokenizer2Writer;
import com.idoox.xml.XmlWriter;
import com.idoox.xml.XmlWriterPool;
import com.systinet.saaj.soap.CachingTokenizer;
import com.systinet.saaj.soap.MimeHeadersImpl;
import com.systinet.saaj.soap.NameImpl;
import com.systinet.saaj.soap.ParseException;
import com.systinet.saaj.soap.SOAPBodyImpl;
import com.systinet.saaj.soap.SOAPElement2Tokenizer;
import com.systinet.saaj.soap.SOAPElementImpl;
import com.systinet.saaj.soap.SOAPEnvelopeImpl;
import com.systinet.saaj.soap.SOAPFaultImpl;
import com.systinet.saaj.soap.common.IParsingNode;
import com.systinet.saaj.soap.common.SOAP11Constants;
import com.systinet.saaj.soap.pools.SAAJNodePool;
import com.systinet.wasp.soap.StopableTokenizer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.idoox.transport.OutputMessage;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.TokenizerSource;
import org.systinet.wasp.soap.MessagePart;
import org.systinet.wasp.soap.MimeHeadersSource;
import org.systinet.wasp.soap.SOAPElementContent;
import org.systinet.wasp.soap.util.LazyFillingTokenizer;
import org.systinet.xml.TokenizerInputSource;
import org.systinet.xml.TokenizerXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SOAPPartImpl
extends SOAPPart
implements IParsingNode {
    private Tokenizer tokenizer;
    private SOAPEnvelopeImpl envelope;
    protected MimeHeadersImpl headers;
    private List tokenizers = new ArrayList();
    DeclaredPrefixesStack dps = new DeclaredPrefixesStack();
    private boolean envelopeUsed;
    private boolean envelopeInitialized;
    private LazyFillingTokenizer lazyFillingTokenizer;
    private Token token = new Token();
    private EnvelopeOutCache envelopeOutCache;

    public SOAPPartImpl() {
        this.headers = new MimeHeadersImpl();
        this.headers.setHeader(MimeHeadersSource.CONTENT_TYPE_HEADER_LC, this.getSOAPContentType(null));
    }

    public void init(MessagePart xmlPart, String attachmentType, Source source) throws SOAPException, IOException {
        this.headers.init((MimeHeadersSource)xmlPart);
        String contentType = xmlPart.getContentType();
        if (contentType != null) {
            this.checkContentType(contentType, attachmentType);
        }
        this.setContent(source);
    }

    public SOAPEnvelope getEnvelope() throws SOAPException {
        try {
            if (this.envelope == null) {
                this.createEnvelope();
            }
            if (this.tokenizer != null && !this.envelopeInitialized) {
                this.parseEnvelope(true);
            }
            this.envelopeUsed = true;
            return this.envelope;
        }
        catch (ParseException e) {
            throw new SOAPException("Exception while parsing", (Throwable)((Object)e));
        }
    }

    public void removeMimeHeader(String header) {
        this.headers.removeHeader(header);
    }

    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    public String[] getMimeHeader(String name) {
        return this.headers.getHeader(name);
    }

    public void setMimeHeader(String name, String value) {
        this.headers.setHeader(name, value);
    }

    public void addMimeHeader(String name, String value) {
        this.headers.addHeader(name, value);
    }

    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this.headers.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this.headers.getNonMatchingHeaders(names);
    }

    public void setContent(Source source) throws SOAPException {
        if (source == null) {
            Iterator i = this.tokenizers.iterator();
            while (i.hasNext()) {
                ((SOAPElement2Tokenizer)i.next()).stopBuild();
            }
            this.tokenizers.clear();
            return;
        }
        if (this.envelope != null && this.envelopeUsed) {
            this.envelope = null;
            this.envelopeUsed = false;
            this.envelopeInitialized = false;
        }
        Tokenizer tokenizer = null;
        Iterator i = this.tokenizers.iterator();
        while (i.hasNext()) {
            ((SOAPElement2Tokenizer)i.next()).stopBuild();
        }
        this.tokenizers.clear();
        if (source instanceof TokenizerSource) {
            tokenizer = ((TokenizerSource)source).getTokenizer();
        } else if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            tokenizer = this.node2Tokenizer(node);
        } else {
            DOMResult result = null;
            try {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                result = new DOMResult(document);
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new SOAPException("Unable to convert source to DOM!", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new SOAPException("Unable to init DOM XML parser!", (Throwable)e);
            }
            tokenizer = this.node2Tokenizer(result.getNode());
        }
        try {
            this.parse(tokenizer, null, true, null);
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
    }

    private Tokenizer node2Tokenizer(Node node) throws SOAPException {
        Element2Tokenizer tokenizer;
        if (node == null) {
            return null;
        }
        if (node instanceof Element) {
            tokenizer = new Element2Tokenizer((Element)node);
        } else if (node instanceof Document) {
            Document document = (Document)node;
            tokenizer = new Element2Tokenizer(document.getDocumentElement());
        } else {
            throw new SOAPException("Unable to set DOMSource as content of SOAPPart - source.getNode() is not an instance of org.w3c.dom.Element nor org.w3c.dom.Document");
        }
        return tokenizer;
    }

    public Source getContent() throws SOAPException {
        TokenizerSource source = new TokenizerSource();
        SOAPEnvelope envelope = this.getEnvelope();
        Tokenizer tokenizer = ((SOAPEnvelopeImpl)envelope).getTokenizer();
        this.tokenizers.add(tokenizer);
        source.setTokenizer(tokenizer);
        return source;
    }

    public void parse(Tokenizer tokenizer, Token thisElement, boolean lazy, DeclaredPrefixesStack dps) throws ParseException {
        this.tokenizer = tokenizer;
    }

    private void parseEnvelope(boolean lazy) throws ParseException {
        byte state = this.tokenizer.currentState();
        try {
            while (state != 2 && state != 1) {
                state = this.tokenizer.next();
            }
            if (state == 1) {
                throw new ParseException("Can't find start token");
            }
            this.tokenizer.readToken(this.token);
            this.dps.used = 0;
            this.tokenizer.pushNewlyDeclaredPrefixes(this.dps);
            this.tokenizer.next();
            this.envelope.subelements.clear();
            this.envelope.parse(this.tokenizer, this.token, lazy, this.dps);
            this.envelopeInitialized = true;
        }
        catch (Exception e) {
            throw new ParseException("Exception while parsing", e);
        }
    }

    public SOAPElement getSOAPElement(Name name) {
        SOAPElementImpl element = null;
        if (!name.equals(this.getEnvelopeName())) {
            throw new VersionMismatchException();
        }
        element = this.newEnvelope();
        element.name = (Name)((NameImpl)name).clone();
        return element;
    }

    public void clear() {
        if (!this.envelopeUsed) {
            this.headers.removeAllHeaders();
            this.headers.setHeader(MimeHeadersSource.CONTENT_TYPE_HEADER_LC, this.getSOAPContentType(null));
            if (this.envelope != null) {
                this.envelope.namespaces.clear();
                NameImpl envName = (NameImpl)this.envelope.name;
                NameImpl origName = (NameImpl)this.getEnvelopeName();
                if (!origName.exactlySame(envName)) {
                    this.envelope.name = (Name)origName.clone();
                }
                this.envelope.namespaces.put(this.envelope.name.getPrefix(), this.envelope.name.getURI());
                this.envelope.readSubelements = 0;
                if (this.envelope.subelements.size() == 0) {
                    try {
                        this.envelope.subelements.add(this.envelope.getHeader());
                        this.envelope.subelements.add(this.envelope.getBody());
                    }
                    catch (SOAPException e) {
                        throw new RuntimeWrappedException((Throwable)e);
                    }
                }
            }
            this.tokenizer = null;
            if (this.envelope != null && this.envelope.body != null) {
                this.envelope.body.attributes.clear();
            }
        } else {
            this.headers.removeAllHeaders();
            this.headers.setHeader(MimeHeadersSource.CONTENT_TYPE_HEADER_LC, this.getSOAPContentType(null));
            this.tokenizer = null;
            this.tokenizers.clear();
            this.envelope.recycleNode();
            this.envelope = null;
            this.envelopeUsed = false;
        }
        this.envelopeInitialized = false;
        this.lazyFillingTokenizer = null;
        this.envelopeOutCache = null;
    }

    public void writeTo(OutputMessage out, String attachmentType) throws SOAPException, IOException, TokenizerException {
        this.writeContentType(out, attachmentType);
        this.headers.writeTo(out, false);
        XmlWriter writer = XmlWriterPool.getXmlWriter();
        Writer w = StreamReaderWriterPool.getOutputStreamUTFWriter((OutputStream)out);
        boolean leaveEnvelope = true;
        if (this.lazyFillingTokenizer == null) {
            writer.setOutput(w);
            TokenizerSource source = (TokenizerSource)this.getContent();
            SOAPElement2Tokenizer tokenizer = (SOAPElement2Tokenizer)source.getTokenizer();
            tokenizer.stopBuild();
            Tokenizer2Writer.copy((Tokenizer)tokenizer, (TokenWriter)writer);
        } else if (this.envelopeUsed) {
            writer.setOutput(w);
            this.lazyFillingTokenizer.setWriter((TokenWriter)writer);
            TokenizerSource source = (TokenizerSource)this.getContent();
            SOAPElement2Tokenizer tokenizer = (SOAPElement2Tokenizer)source.getTokenizer();
            tokenizer.stopBuild();
            Tokenizer2Writer.copy((Tokenizer)tokenizer, (TokenWriter)writer);
        } else {
            Iterator i;
            SOAPEnvelopeImpl env = (SOAPEnvelopeImpl)this.getEnvelope();
            if (EnvelopeCaching.isEnabled() && this.envelopeOutCache != null) {
                out.setStringHeader("X-WASP-Message-ID", this.envelopeOutCache.envelopeHeaderID);
                writer.setOutput(w, false, false);
                w.write(this.envelopeOutCache.envelopeStartTag);
                if (this.envelopeOutCache.prefixes != null) {
                    int i2 = 0;
                    while (i2 < this.envelopeOutCache.prefixes.length) {
                        writer.addKnownPrefixForNamespace(this.envelopeOutCache.prefixes[i2], this.envelopeOutCache.namespaces[i2]);
                        ++i2;
                    }
                }
                leaveEnvelope = false;
            } else {
                writer.setOutput(w);
                Name envName = this.getEnvelopeName();
                writer.enter(envName.getURI(), envName.getLocalName());
                Map prefixMap = env.getPrefixMapForRead();
                Iterator i3 = prefixMap.entrySet().iterator();
                while (i3.hasNext()) {
                    Map.Entry xmlns = i3.next();
                    writer.setPrefixForNamespace((String)xmlns.getKey(), (String)xmlns.getValue());
                }
                i = env.getAllAttributes();
                while (i.hasNext()) {
                    Name name = (Name)i.next();
                    writer.writeAttribute(name.getURI(), name.getLocalName(), env.getAttributeValue(name));
                }
            }
            Name bodyName = env.getBodyName();
            writer.enter(bodyName.getURI(), bodyName.getLocalName());
            SOAPBodyImpl body = (SOAPBodyImpl)env.getBody();
            Map prefixMap = body.getPrefixMapForRead();
            i = prefixMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry xmlns = i.next();
                writer.setPrefixForNamespace((String)xmlns.getKey(), (String)xmlns.getValue());
            }
            Iterator i4 = body.getAllAttributes();
            while (i4.hasNext()) {
                Name name = (Name)i4.next();
                writer.writeAttribute(name.getURI(), name.getLocalName(), body.getAttributeValue(name));
            }
            body.tokenizer = null;
            this.lazyFillingTokenizer.writeTo(writer);
            writer.leave();
            if (leaveEnvelope) {
                writer.leave();
            } else {
                String prefix = env.getElementName().getPrefix();
                if (prefix == null) {
                    prefix = "";
                } else if (prefix.length() > 0) {
                    prefix = prefix + ":";
                }
                w.write("</" + prefix + "Envelope>");
            }
            this.envelopeUsed = false;
            this.envelope.usedBody = false;
            this.envelope.usedHeader = false;
        }
        w.flush();
        XmlWriterPool.releaseXmlWriter((XmlWriter)writer);
        StreamReaderWriterPool.releaseOutputStreamUTFWriter((Writer)w);
    }

    public void writeTo(OutputStream out) throws SOAPException, IOException, TokenizerException {
        XmlWriter writer = XmlWriterPool.getXmlWriter();
        Writer w = StreamReaderWriterPool.getOutputStreamUTFWriter((OutputStream)out);
        writer.setOutput(w);
        TokenizerSource source = (TokenizerSource)this.getContent();
        SOAPElement2Tokenizer tokenizer = (SOAPElement2Tokenizer)source.getTokenizer();
        tokenizer.stopBuild();
        Tokenizer2Writer.copy((Tokenizer)tokenizer, (TokenWriter)writer);
        w.flush();
        XmlWriterPool.releaseXmlWriter((XmlWriter)writer);
        StreamReaderWriterPool.releaseOutputStreamUTFWriter((Writer)w);
    }

    protected String getOutputContentType(String attachmentType) {
        if ("application/dime".equals(attachmentType)) {
            return this.getSOAPContentType(attachmentType);
        }
        return this.getSOAPContentType(attachmentType) + ";charset=UTF-8";
    }

    public String getContentType() throws IOException {
        return this.headers.getMimeHeader(MimeHeadersSource.CONTENT_TYPE_HEADER_LC);
    }

    public void setContentType(String contentType) {
        this.setMimeHeader(MimeHeadersSource.CONTENT_TYPE_HEADER_LC, contentType);
    }

    protected Name getEnvelopeName() {
        return SOAP11Constants.ENVELOPE;
    }

    protected SOAPElementImpl newEnvelope() {
        return (SOAPElementImpl)SAAJNodePool.getNode(2);
    }

    protected String getSOAPContentType(String attachmentType) {
        if (attachmentType == null) {
            return "text/xml";
        }
        if ("application/dime".equals(attachmentType)) {
            return "http://schemas.xmlsoap.org/soap/envelope/";
        }
        return "text/xml";
    }

    public void checkContentType(String contentType, String attachmentType) throws SOAPException, IOException {
        String expectedContentType = this.getSOAPContentType(attachmentType);
        if (contentType == null || !contentType.startsWith(expectedContentType)) {
            throw new UnsupportedMediaTypeException(this.getContentType());
        }
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            XmlWriter outw = new XmlWriter((Writer)writer, false);
            Tokenizer t = ((TokenizerSource)this.getContent()).getTokenizer();
            Tokenizer2Writer.copy((Tokenizer)t, (TokenWriter)outw);
            outw.flush();
            return writer.toString();
        }
        catch (Exception e) {
            return "Unable to get string representation of this SOAPPart:" + e;
        }
    }

    public void startProcessing() throws SOAPException {
        this.envelopeUsed = false;
    }

    public void setLazyFillingTokenizer(LazyFillingTokenizer tokenizer) {
        this.lazyFillingTokenizer = tokenizer;
    }

    public Name getBodyName() {
        return SOAP11Constants.BODY;
    }

    public Tokenizer getBodyTokenizer() throws TokenizerException, IOException, SOAPException {
        if (!(this.tokenizer == null || this.envelopeUsed && this.envelope.isUsedBody())) {
            byte state = this.tokenizer.currentState();
            Name bodyName = this.getBodyName();
            while (state != 1) {
                if (state == 2) {
                    this.tokenizer.readToken(this.token);
                    if (this.token.getLocalName().equals(bodyName.getLocalName()) && this.token.getNamespace().equals(bodyName.getURI())) break;
                }
                state = this.tokenizer.next();
            }
            if (state == 1) {
                throw new RuntimeException("Message doesn't contain body.");
            }
            return this.tokenizer;
        }
        StopableTokenizer tokenizer = (StopableTokenizer)((SOAPElementContent)this.envelope.getBody()).getContent();
        tokenizer.stopBuild();
        return tokenizer;
    }

    public void setEnvelopeOutCache(EnvelopeOutCache envelopeOutCache) {
        this.envelopeOutCache = envelopeOutCache;
    }

    public boolean hasFault() throws SOAPException {
        if (!this.envelopeUsed) {
            return false;
        }
        return this.envelope.hasFault();
    }

    private void createEnvelope() throws SOAPException {
        this.envelope = (SOAPEnvelopeImpl)this.getSOAPElement(this.getEnvelopeName());
        NameImpl name = (NameImpl)this.envelope.getElementName();
        this.envelope.addNamespaceDeclaration(name.prefix, name.uri);
        this.envelope.addHeader();
        this.envelope.addBody();
        this.envelope.setEmpty();
    }

    public MimeHeadersImpl getMimeHeadersImpl() {
        return this.headers;
    }

    protected void writeContentType(OutputMessage out, String attachmentType) throws IOException {
        String contentType = null;
        contentType = this.getOutputContentType(attachmentType);
        out.setContentType(contentType);
    }

    public void setEnvelopePrefix(String prefix) throws SOAPException {
        if (this.getEnvelopeName().getPrefix().equals(prefix)) {
            return;
        }
        SOAPEnvelopeImpl env = (SOAPEnvelopeImpl)this.getEnvelope();
        NameImpl name = (NameImpl)env.getElementName();
        env.namespaces.remove(name.prefix);
        name.prefix = prefix;
        env.namespaces.put(name.prefix, name.uri);
    }

    public void load() throws SOAPException {
        Iterator childElements = this.getEnvelope().getChildElements();
        while (childElements.hasNext()) {
            childElements.next();
        }
    }

    public QName getFaultCode() throws SOAPException {
        SOAPFaultImpl fault = (SOAPFaultImpl)this.getEnvelope().getBody().getFault();
        if (fault == null) {
            throw new IllegalStateException("Cannot get fault code of SOAP message that does not contain fault! SOAPMessage:" + this.toString());
        }
        return fault.getFaultCodeQName();
    }

    public SAXSource getStreamContent() throws SOAPException {
        Tokenizer tokenizerClone = this.cloneTokenizer();
        return new SAXSource((XMLReader)new TokenizerXMLReader(), (InputSource)new TokenizerInputSource(tokenizerClone));
    }

    private Tokenizer cloneTokenizer() throws SOAPException {
        try {
            SOAPEnvelope envelope = this.getEnvelope();
            Tokenizer tokenizer = ((SOAPEnvelopeImpl)envelope).getTokenizer();
            CachingTokenizer cacheTokenizer = new CachingTokenizer(tokenizer);
            cacheTokenizer.fillCache();
            CachingTokenizer cacheTokenizerClone = (CachingTokenizer)cacheTokenizer.clone();
            TokenizerSource tokSource = new TokenizerSource();
            tokSource.setTokenizer((Tokenizer)cacheTokenizer);
            this.setContent((Source)tokSource);
            return cacheTokenizerClone;
        }
        catch (TokenizerException e) {
            throw new SOAPException("Error while creating XML Message:", (Throwable)e);
        }
        catch (IOException e) {
            throw new SOAPException("Error while creating XML Message:", (Throwable)e);
        }
    }
}

