/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import com.systinet.saaj.soap.NameImpl;
import com.systinet.saaj.soap.SOAPElementImpl;
import com.systinet.saaj.soap.common.SOAP11Constants;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xmlrpc.Constants;

public class SOAPHeaderElementImpl
extends SOAPElementImpl
implements SOAPHeaderElement {
    public void setActor(String actorURI) {
        try {
            this.removeAttribute(this.getActorName());
            this.addAttribute((Name)((NameImpl)this.getActorName()).clone(), actorURI);
        }
        catch (SOAPException ex) {
            throw new RuntimeWrappedException((Throwable)ex);
        }
    }

    public String getActor() {
        String actor = this.getAttributeValue(this.getActorName());
        if (actor == null) {
            actor = this.getDefaultActor();
        }
        return actor;
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        try {
            this.removeAttribute(this.getMUName());
            this.addAttribute((Name)((NameImpl)this.getMUName()).clone(), mustUnderstand ? this.getMustUnderstandTrue() : this.getMustUnderstandFalse());
        }
        catch (SOAPException ex) {
            throw new RuntimeWrappedException((Throwable)ex);
        }
    }

    public boolean getMustUnderstand() {
        String result = this.getAttributeValue(this.getMUName());
        if (result != null) {
            this.checkMUValue(result);
            if (result.equals("1") || result.equals(this.getMustUnderstandTrue())) {
                return true;
            }
        }
        return false;
    }

    protected void checkMUValue(String muValue) {
        if ("1".equals(muValue) || "0".equals(muValue)) {
            return;
        }
        throw new SOAPFaultException(Constants.CLIENT_FAULT_CODE, "'mustUnderstand' attribute of SOAP header block cannot have value:" + muValue, null, null);
    }

    protected Name getMUName() {
        return SOAP11Constants.MUST_UNDERSTAND;
    }

    protected Name getActorName() {
        return SOAP11Constants.ACTOR;
    }

    protected String getActorNextURI() {
        return "http://schemas.xmlsoap.org/soap/actor/next";
    }

    protected String getDefaultActor() {
        return null;
    }

    protected String getMustUnderstandTrue() {
        return "1";
    }

    protected String getMustUnderstandFalse() {
        return "0";
    }
}

