/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import com.systinet.saaj.soap.NameImpl;
import com.systinet.saaj.soap.SOAPElementImpl;
import com.systinet.saaj.soap.SOAPEnvelopeImpl;
import com.systinet.saaj.soap.common.SOAP11Constants;
import com.systinet.saaj.soap.pools.SAAJNodePool;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;

public class SOAPBodyImpl
extends SOAPElementImpl
implements SOAPBody {
    public SOAPFault addFault() throws SOAPException {
        this.subelements.clear();
        this.tokenizer = null;
        return (SOAPFault)this.addChildElement(this.getFaultName());
    }

    public boolean hasFault() {
        return this.getFault() != null;
    }

    public SOAPFault getFault() {
        Name faultName = this.getFaultName();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof SOAPElement)) continue;
            SOAPElement soapElement = (SOAPElement)o;
            if (faultName.equals(soapElement.getElementName())) {
                return (SOAPFault)soapElement;
            }
            return null;
        }
        return null;
    }

    public SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        return (SOAPBodyElement)this.addChildElement(name);
    }

    public SOAPElement getSOAPElement(Name name) {
        SOAPElementImpl element = null;
        element = name.equals(this.getFaultName()) ? this.newFault() : this.newBodyElement();
        element.name = (Name)((NameImpl)name).clone();
        return element;
    }

    public void recycleNode() {
        if (this.parent != null) {
            ((SOAPEnvelopeImpl)this.parent).body = null;
            ((SOAPEnvelopeImpl)this.parent).usedBody = false;
        }
        super.recycleNode();
    }

    protected Name getFaultName() {
        return SOAP11Constants.FAULT;
    }

    protected SOAPElementImpl newFault() {
        return (SOAPElementImpl)SAAJNodePool.getNode(4);
    }

    private SOAPElementImpl newBodyElement() {
        return (SOAPElementImpl)SAAJNodePool.getNode(6);
    }
}

