/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import com.idoox.util.Pool;
import com.systinet.saaj.soap.PoolableObject;
import com.systinet.saaj.soap.pools.NamePool;
import javax.xml.soap.Name;

public class NameImpl
implements Name,
PoolableObject,
Cloneable {
    public String localName;
    public String prefix;
    public String uri;
    private Pool pool;

    public NameImpl() {
    }

    public NameImpl(String localName, String prefix, String uri) {
        this.localName = localName;
        this.prefix = prefix;
        if (uri == null) {
            uri = "";
        }
        this.uri = uri;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getQualifiedName() {
        if (this.prefix == null || this.prefix.length() == 0) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getURI() {
        return this.uri;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NameImpl)) {
            return false;
        }
        NameImpl name = (NameImpl)obj;
        return (this.uri == null && name.uri == null || this.uri != null && this.uri.equals(name.uri)) && (this.localName == null && name.localName == null || this.localName != null && this.localName.equals(name.localName));
    }

    public final boolean exactlySame(NameImpl name) {
        boolean result = this.equals(name);
        if (!result) {
            return false;
        }
        if (this.prefix == null) {
            return name.prefix == null;
        }
        return this.prefix.equals(name.prefix);
    }

    public final int hashCode() {
        int uriHash = this.uri == null ? 0 : this.uri.hashCode();
        int localNameHash = this.localName == null ? 0 : this.localName.hashCode();
        return uriHash ^ localNameHash;
    }

    public void release() {
        if (this.pool != null) {
            Pool aux = this.pool;
            this.prefix = null;
            this.localName = null;
            this.uri = null;
            this.pool = null;
            aux.release((Object)this);
        }
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public Object clone() {
        NameImpl ret = (NameImpl)NamePool.getName();
        ret.localName = this.localName;
        ret.prefix = this.prefix;
        ret.uri = this.uri;
        return ret;
    }

    public String toString() {
        return '{' + this.uri + '}' + this.localName;
    }
}

