/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import com.idoox.debug.Category;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import org.idoox.transport.OutputMessage;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.soap.MimeHeadersSource;

public class MimeHeadersImpl
extends MimeHeaders {
    private static final Category dbg = Category.getCategory((String)"com.systinet.saaj.soap.MimeHeadersImpl");
    MimeHeadersSource source;
    Map headers = new HashMap();
    Map conversion = new HashMap();
    boolean readHeaders = true;

    public void init(MimeHeadersSource source) {
        this.source = source;
        this.headers.clear();
        this.conversion.clear();
        this.readHeaders = false;
    }

    public String[] getHeader(String name) {
        try {
            return new String[]{this.getMimeHeader(name.toLowerCase())};
        }
        catch (IOException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void setHeader(String name, String value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Illegal MimeHeader name");
        }
        this.loadAllHeaders();
        String lcName = name.toLowerCase();
        this.conversion.put(lcName, name);
        this.headers.put(lcName, value);
        this.readHeaders = true;
    }

    private void loadAllHeaders() {
        if (this.source == null) {
            return;
        }
        try {
            Iterator it = this.source.getHeaderNames().iterator();
            while (it.hasNext()) {
                String hName = (String)it.next();
                String lcName = hName.toLowerCase();
                this.headers.put(lcName, this.source.getMimeHeader(hName));
                this.conversion.put(lcName, hName);
            }
        }
        catch (IOException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void addHeader(String name, String value) {
        this.setHeader(name, value);
    }

    public void removeHeader(String name) {
        this.loadAllHeaders();
        this.headers.remove(name);
    }

    public void removeAllHeaders() {
        this.source = null;
        this.readHeaders = true;
        this.headers.clear();
    }

    public Iterator getAllHeaders() {
        this.loadAllHeaders();
        Set set = this.headers.entrySet();
        int size = set.size();
        ArrayList<MimeHeader> resultHolder = new ArrayList<MimeHeader>(size);
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            resultHolder.add(new MimeHeader((String)this.conversion.get(name), (String)entry.getValue()));
        }
        return resultHolder.iterator();
    }

    public Iterator getMatchingHeaders(String[] names) {
        return new IteratorHelper(this, this.getAllHeaders(), names, true);
    }

    public Iterator getNonMatchingHeaders(String[] names) {
        return new IteratorHelper(this, this.getAllHeaders(), names, false);
    }

    public Map getHeadersMap() {
        this.loadAllHeaders();
        return this.headers;
    }

    public String getMimeHeader(String name) throws IOException {
        if (this.readHeaders) {
            return (String)this.headers.get(name);
        }
        return this.source.getMimeHeader(name);
    }

    public void writeTo(OutputMessage message, boolean writeContentType) throws IOException {
        this.loadAllHeaders();
        String contentType = null;
        if (writeContentType) {
            contentType = (String)this.headers.remove(MimeHeadersSource.CONTENT_TYPE_HEADER_LC);
            if (contentType != null) {
                message.setContentType(contentType);
            }
        } else {
            this.headers.remove(MimeHeadersSource.CONTENT_TYPE_HEADER_LC);
        }
        Iterator it = this.headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String lcName = (String)entry.getKey();
            message.setStringHeader((String)this.conversion.get(lcName), (String)entry.getValue());
        }
        if (writeContentType && contentType != null) {
            this.headers.put(MimeHeadersSource.CONTENT_TYPE_HEADER_LC, contentType);
        }
    }

    private static class IteratorHelper
    implements Iterator {
        boolean match;
        String[] names;
        Iterator iterator;
        MimeHeader current;
        Object nextHeader;
        MimeHeadersImpl impl;

        IteratorHelper(MimeHeadersImpl impl, Iterator it, String[] names, boolean match) {
            this.match = match;
            this.names = names;
            this.iterator = it;
            this.impl = impl;
        }

        public boolean hasNext() {
            if (this.nextHeader == null) {
                this.nextHeader = this.nextEntry();
            }
            return this.nextHeader != null;
        }

        public Object next() {
            if (this.nextHeader != null) {
                this.current = (MimeHeader)this.nextHeader;
                this.nextHeader = null;
                return this.current;
            }
            if (this.hasNext()) {
                this.current = (MimeHeader)this.nextHeader;
                this.nextHeader = null;
                return this.current;
            }
            return null;
        }

        public void remove() {
            this.impl.removeHeader(this.current.getName());
            this.iterator.remove();
        }

        private Object nextEntry() {
            block0: while (this.iterator.hasNext()) {
                MimeHeader hdr = (MimeHeader)this.iterator.next();
                if (this.names == null) {
                    return this.match ? null : hdr;
                }
                int i = 0;
                while (i < this.names.length) {
                    if (hdr.getName().equalsIgnoreCase(this.names[i])) {
                        if (!this.match) continue block0;
                        return hdr;
                    }
                    ++i;
                }
                if (this.match) continue;
                return hdr;
            }
            return null;
        }
    }
}

