/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import com.idoox.util.Pool;
import com.systinet.saaj.soap.ParseException;
import com.systinet.saaj.soap.PoolableObject;
import com.systinet.saaj.soap.SOAPElementImpl;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.soap.Node;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.Tokenizer;

public class ElementIterator
implements Iterator,
PoolableObject {
    private SOAPElementImpl element;
    private int version;
    private int index;
    private Tokenizer tokenizer;
    private boolean stop;
    private Pool pool;

    void init(SOAPElementImpl element) {
        this.element = element;
        this.version = element.elementModCount;
        this.index = 0;
    }

    public boolean hasNext() {
        if (this.version != this.element.elementModCount) {
            throw new ConcurrentModificationException();
        }
        int size = this.element.subelements.size();
        if (size > this.index) {
            return true;
        }
        if (this.element.tokenizer == null) {
            return false;
        }
        try {
            if (this.stop) {
                this.tokenizer = this.element.tokenizer;
                return false;
            }
            if (size > 0) {
                this.element.ensureLoadedLastElement();
            }
            Node aux = null;
            while (aux == null && this.element.tokenizer != null) {
                aux = this.element.initNextSubelement(true);
            }
            return aux != null;
        }
        catch (ParseException e) {
            throw new RuntimeWrappedException((Throwable)((Object)e));
        }
    }

    public Object next() {
        if (this.version != this.element.elementModCount) {
            throw new ConcurrentModificationException();
        }
        if (this.element.subelements.size() > this.index) {
            return (Node)this.element.subelements.get(this.index++);
        }
        if (this.hasNext()) {
            return this.element.subelements.get(this.index++);
        }
        throw new NoSuchElementException("Interator has reached the last element");
    }

    public void remove() {
        if (this.version != this.element.elementModCount) {
            throw new ConcurrentModificationException();
        }
        this.element.ensureLoadedLastElement();
        --this.index;
        this.element.subelements.remove(this.index);
        this.version = ++this.element.elementModCount;
    }

    public void stop() {
        this.stop = true;
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public void release() {
        this.tokenizer = null;
        this.element = null;
        this.stop = false;
        Pool aux = this.pool;
        this.pool = null;
        if (aux != null) {
            aux.release((Object)this);
        }
    }
}

