/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class CachingTokenizer
implements Tokenizer,
Cloneable {
    private Tokenizer tokenizer;
    private int depth;
    private byte type;
    private boolean endReported;
    private LinkedList cache;
    private int[] cachedPrefixPos;
    private int[] cachedPrefixSize;
    private int[] cachePos = new int[10];
    private int cachedPrefixUsed;
    private DeclaredPrefixesStack cachedPrefixes = new DeclaredPrefixesStack();
    private String currentContent;
    private Token currentToken;
    private Map prefix2ns;

    public CachingTokenizer() {
    }

    private CachingTokenizer(Tokenizer tokenizer, int depth, byte type, boolean endReported, LinkedList cache, int[] cachedPrefixPos, int[] cachedPrefixSize, int[] cachePos, int cachedPrefixUsed, DeclaredPrefixesStack cachedPrefixes, String currentContent, Token currentToken, Map prefix2ns) {
        this.tokenizer = tokenizer;
        this.depth = depth;
        this.type = type;
        this.endReported = endReported;
        this.cache = cache;
        this.cachedPrefixPos = cachedPrefixPos;
        this.cachedPrefixSize = cachedPrefixSize;
        this.cachePos = cachePos;
        this.cachedPrefixUsed = cachedPrefixUsed;
        this.cachedPrefixes = cachedPrefixes;
        this.currentContent = currentContent;
        this.currentToken = currentToken;
        this.prefix2ns = prefix2ns;
    }

    public CachingTokenizer(Tokenizer tokenizer) {
        this.init(tokenizer);
    }

    public void init(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.depth = 1;
        this.type = tokenizer.currentState();
        if (this.type != 2) {
            throw new IllegalStateException("Only tokenizer that stands on the START_TOKEN can be used!");
        }
        this.endReported = false;
        this.cache = null;
        this.cachedPrefixUsed = 0;
        this.prefix2ns = null;
        this.cachedPrefixes.used = 0;
        this.ensurePrefixCacheSize();
        this.cachedPrefixPos[this.cachedPrefixUsed] = this.cachedPrefixes.used;
        this.cachedPrefixSize[this.cachedPrefixUsed] = tokenizer.pushNewlyDeclaredPrefixes(this.cachedPrefixes);
        this.cachePos[this.depth - 1] = this.cachedPrefixUsed++;
    }

    public String getLocalName() throws TokenizerException {
        if (this.tokenizer != null) {
            return this.tokenizer.getLocalName();
        }
        if (this.type == 2 || this.type == 3) {
            return this.currentToken.localName;
        }
        throw new TokenizerException("Not available - bad state");
    }

    public String getNamespace() throws TokenizerException {
        if (this.tokenizer != null) {
            return this.tokenizer.getNamespace();
        }
        if (this.type == 2 || this.type == 3) {
            return this.currentToken.uri;
        }
        throw new TokenizerException("Not available - bad state");
    }

    public QName parseQName(String qName) {
        if (qName.charAt(0) == '{') {
            return QName.valueOf(qName);
        }
        int p = qName.indexOf(58);
        String prefix = null;
        String localName = qName.substring(p + 1);
        if (p > 0) {
            prefix = qName.substring(0, p);
        }
        return new QName(this.getNamespaceForPrefix(prefix), localName);
    }

    public byte next() throws TokenizerException, IOException {
        if (this.tokenizer != null) {
            throw new TokenizerException("At first fillCache must be called!");
        }
        if (this.cache == null) {
            if (this.endReported) {
                throw new TokenizerException("Reading after end-of-document");
            }
            this.endReported = true;
            return 1;
        }
        Object item = this.cache.removeFirst();
        if (item instanceof Token) {
            this.currentToken = (Token)item;
            this.type = this.currentToken.type;
            ++this.cachedPrefixUsed;
            int p = this.cachedPrefixPos[this.cachedPrefixUsed];
            int s = this.cachedPrefixSize[this.cachedPrefixUsed];
            if (s > 0) {
                int i = 0;
                while (i < s) {
                    this.prefix2ns.put(this.cachedPrefixes.prefixes[i + p], this.cachedPrefixes.prefixValues[i + p]);
                    ++i;
                }
            } else if (s < 0) {
                s = this.cachedPrefixSize[-p];
                p = this.cachedPrefixPos[-p];
                int i = 0;
                while (i < s) {
                    if (this.cachedPrefixes.previousPrefixValues[i + p] == null) {
                        this.prefix2ns.remove(this.cachedPrefixes.prefixes[i + p]);
                    } else {
                        this.prefix2ns.put(this.cachedPrefixes.prefixes[i + p], this.cachedPrefixes.previousPrefixValues[i + p]);
                    }
                    ++i;
                }
            }
            if (this.cache.isEmpty()) {
                this.cache = null;
            }
            if (this.type == 1) {
                this.currentToken = null;
            }
        } else {
            this.type = (byte)4;
            this.currentContent = (String)item;
            if (this.cache.isEmpty()) {
                this.cache = null;
            }
        }
        return this.type;
    }

    public String readContent() throws TokenizerException {
        if (this.tokenizer != null) {
            return this.tokenizer.readContent();
        }
        if (this.type == 4) {
            return this.currentContent;
        }
        throw new TokenizerException("No content available");
    }

    public void readToken(Token token) throws TokenizerException, IOException {
        if (this.tokenizer != null) {
            this.tokenizer.readToken(token);
        } else if (this.type == 2 || this.type == 3) {
            this.currentToken.writeTo(token);
        } else {
            throw new TokenizerException("No token available");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fillCache() throws TokenizerException, IOException {
        if (this.tokenizer == null) {
            return;
        }
        this.prefix2ns = new HashMap(this.tokenizer.getCurrentPrefixMap());
        this.currentContent = null;
        if (this.type != 2) {
            throw new IllegalStateException("Only tokenizer that stands on the START_TOKEN can be used!");
        }
        int currDepth = this.depth;
        this.cache = new LinkedList();
        this.currentToken = new Token();
        this.tokenizer.readToken(this.currentToken);
        block7: while (true) {
            byte t = this.tokenizer.next();
            switch (t) {
                case 4: {
                    this.cache.add(this.tokenizer.readContent());
                    break;
                }
                case 2: {
                    ++currDepth;
                    Token token = new Token();
                    this.tokenizer.readToken(token);
                    this.cache.add(token);
                    this.ensurePrefixCacheSize();
                    this.cachedPrefixPos[this.cachedPrefixUsed] = this.cachedPrefixes.used;
                    this.cachedPrefixSize[this.cachedPrefixUsed] = this.tokenizer.pushNewlyDeclaredPrefixes(this.cachedPrefixes);
                    if (currDepth >= this.cachePos.length) {
                        int[] p = new int[this.cachePos.length + 10];
                        System.arraycopy(this.cachePos, 0, p, 0, this.cachePos.length);
                        this.cachePos = p;
                    }
                    this.cachePos[currDepth - 1] = this.cachedPrefixUsed++;
                    break;
                }
                case 3: {
                    this.ensurePrefixCacheSize();
                    this.cachedPrefixPos[this.cachedPrefixUsed] = -this.cachePos[--currDepth];
                    this.cachedPrefixSize[this.cachedPrefixUsed] = -1;
                    ++this.cachedPrefixUsed;
                    Token token = new Token();
                    this.tokenizer.readToken(token);
                    this.cache.add(token);
                    if (currDepth != 0) break;
                    break block7;
                }
                case 1: {
                    throw new TokenizerException("No matching end element found");
                }
                case 0: {
                    throw new RuntimeException("Internal tokenizer error: UNKNOWN element received");
                }
            }
        }
        this.cachedPrefixUsed = 0;
        this.tokenizer = null;
    }

    public String getNamespaceForPrefix(String prefix) {
        if (this.tokenizer != null) {
            return this.tokenizer.getNamespaceForPrefix(prefix);
        }
        return (String)this.prefix2ns.get(prefix);
    }

    public Map getCurrentPrefixMap() {
        if (this.tokenizer != null) {
            return this.tokenizer.getCurrentPrefixMap();
        }
        return Collections.unmodifiableMap(this.prefix2ns);
    }

    public int pushNewlyDeclaredPrefixes(DeclaredPrefixesStack prefixes) {
        if (this.tokenizer != null) {
            return this.tokenizer.pushNewlyDeclaredPrefixes(prefixes);
        }
        int pos = this.cachedPrefixPos[this.cachedPrefixUsed];
        int size = this.cachedPrefixSize[this.cachedPrefixUsed];
        if (size == 0) {
            return 0;
        }
        prefixes.enlarge(size);
        System.arraycopy(this.cachedPrefixes.prefixes, pos, prefixes.prefixes, prefixes.used, size);
        System.arraycopy(this.cachedPrefixes.prefixValues, pos, prefixes.prefixValues, prefixes.used, size);
        System.arraycopy(this.cachedPrefixes.previousPrefixValues, pos, prefixes.previousPrefixValues, prefixes.used, size);
        prefixes.used += size;
        return size;
    }

    public boolean whitespaceContent() throws TokenizerException {
        if (this.tokenizer != null) {
            return this.tokenizer.whitespaceContent();
        }
        if (this.type == 4) {
            return this.currentContent.trim() == "";
        }
        throw new TokenizerException("No content available");
    }

    public byte currentState() {
        if (this.tokenizer != null) {
            return this.tokenizer.currentState();
        }
        return this.type;
    }

    public Element getDOMRepresentation(Document doc) throws TokenizerException {
        if (this.tokenizer != null) {
            return this.tokenizer.getDOMRepresentation(doc);
        }
        throw new UnsupportedOperationException("getDOMRepresentation not supported while caching");
    }

    private void ensurePrefixCacheSize() {
        if (this.cachedPrefixPos == null) {
            this.cachedPrefixPos = new int[10];
            this.cachedPrefixSize = new int[10];
        } else if (this.cachedPrefixUsed == this.cachedPrefixPos.length) {
            int[] newCachedPrefixPos = new int[this.cachedPrefixPos.length * 5 / 4 + 10];
            System.arraycopy(this.cachedPrefixPos, 0, newCachedPrefixPos, 0, this.cachedPrefixPos.length);
            this.cachedPrefixPos = newCachedPrefixPos;
            int[] newCachedPrefixSize = new int[this.cachedPrefixSize.length * 5 / 4 + 10];
            System.arraycopy(this.cachedPrefixSize, 0, newCachedPrefixSize, 0, this.cachedPrefixSize.length);
            this.cachedPrefixSize = newCachedPrefixSize;
        }
    }

    public Object clone() {
        DeclaredPrefixesStack newCachedPrefixes = new DeclaredPrefixesStack();
        newCachedPrefixes.enlarge(this.cachedPrefixes.used);
        newCachedPrefixes.prefixes = this.cloneSringArray(this.cachedPrefixes.prefixes);
        newCachedPrefixes.prefixValues = this.cloneSringArray(this.cachedPrefixes.prefixValues);
        newCachedPrefixes.previousPrefixValues = this.cloneSringArray(this.cachedPrefixes.previousPrefixValues);
        Token newCurrentToken = null;
        if (this.currentToken != null) {
            newCurrentToken = new Token();
            this.currentToken.writeTo(newCurrentToken);
        }
        return new CachingTokenizer(this.tokenizer, this.depth, this.type, this.endReported, new LinkedList(this.cache), this.cloneIntArray(this.cachedPrefixPos), this.cloneIntArray(this.cachedPrefixSize), this.cloneIntArray(this.cachePos), this.cachedPrefixUsed, newCachedPrefixes, this.currentContent, newCurrentToken, new HashMap(this.prefix2ns));
    }

    private int[] cloneIntArray(int[] src) {
        if (src == null) {
            return null;
        }
        int[] ret = new int[src.length];
        System.arraycopy(src, 0, ret, 0, ret.length);
        return ret;
    }

    private String[] cloneSringArray(String[] src) {
        if (src == null) {
            return null;
        }
        String[] ret = new String[src.length];
        System.arraycopy(src, 0, ret, 0, ret.length);
        return ret;
    }

    public String toString() {
        return "Cur:" + this.currentToken + " cache:" + this.cache;
    }
}

