/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import com.idoox.util.Pool;
import com.systinet.saaj.soap.MimeHeadersImpl;
import com.systinet.saaj.soap.PoolableObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.idoox.transport.OutputMessage;
import org.systinet.wasp.soap.AttachmentPartInternal;
import org.systinet.wasp.soap.MessagePart;
import org.systinet.wasp.soap.MimeHeadersSource;

public class AttachmentPartImpl
extends AttachmentPart
implements PoolableObject,
AttachmentPartInternal {
    private MimeHeadersImpl mimeHeaders = new MimeHeadersImpl();
    private Pool pool;
    private DataHandler handler;
    private MessagePart part;

    public void init(MessagePart part) {
        this.mimeHeaders.init((MimeHeadersSource)part);
        this.part = part;
        this.handler = new DataHandler((DataSource)part);
    }

    public int getSize() throws SOAPException {
        try {
            Object input = this.getContent();
            InputStream inputStream = input instanceof InputStream ? (InputStream)input : this.getDataHandler().getInputStream();
            if (!inputStream.getClass().getName().equals("com.systinet.wasp.soap.MessagePartImpl$CachedInputStream")) {
                return -1;
            }
            return (int)inputStream.skip(Integer.MAX_VALUE);
        }
        catch (SOAPException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public void clearContent() {
        this.handler = null;
    }

    public Object getContent() throws SOAPException {
        try {
            return this.getDataHandler().getContent();
        }
        catch (IOException ex) {
            throw new SOAPException((Throwable)ex);
        }
        catch (SOAPException ex) {
            throw ex;
        }
    }

    public void setContent(Object object, String contentType) {
        DataHandler dh = new DataHandler(object, contentType);
        this.setDataHandler(dh);
        if (contentType != null) {
            this.setMimeHeader("Content-Type", contentType);
        }
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.handler == null) {
            throw new SOAPException("No data handler associated with this attachment");
        }
        return this.handler;
    }

    public void setDataHandler(DataHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null dataHandler argument to setDataHandler");
        }
        this.handler = handler;
        if (handler.getContentType() != null) {
            this.setMimeHeader("Content-Type", handler.getContentType());
        }
    }

    public void removeMimeHeader(String header) {
        this.mimeHeaders.removeHeader(header);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    public void setMimeHeader(String name, String value) {
        this.mimeHeaders.setHeader(name, value);
    }

    public void addMimeHeader(String name, String value) {
        this.mimeHeaders.addHeader(name, value);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this.mimeHeaders.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this.mimeHeaders.getNonMatchingHeaders(names);
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public void release() {
        this.mimeHeaders.removeAllHeaders();
        this.handler = null;
        this.part = null;
        if (this.pool != null) {
            this.pool.release((Object)this);
        }
    }

    public boolean hasAllHeaders(MimeHeaders hdrs) {
        Iterator i = hdrs.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader hdr = (MimeHeader)i.next();
            String[] values = this.mimeHeaders.getHeader(hdr.getName());
            boolean found = false;
            if (values != null) {
                int j = 0;
                while (j < values.length) {
                    if (hdr.getValue().equalsIgnoreCase(values[j])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public MessagePart getMessagePart() {
        return this.part;
    }

    public void writeTo(OutputMessage om, byte[] buffer) throws SOAPException, IOException {
        this.mimeHeaders.writeTo(om, true);
        Object input = this.getContent();
        InputStream inputStream = input instanceof InputStream ? (InputStream)input : this.getDataHandler().getInputStream();
        int count = inputStream.read(buffer);
        while (count != -1) {
            om.write(buffer, 0, count);
            count = inputStream.read(buffer);
        }
        inputStream.close();
    }
}

