/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.build.ant;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import java.util.Vector;

public class Runner {
    public static void main(String[] argv) {
        String mainClass = System.getProperty("torun");
        if (mainClass == null) {
            String message = "No main class to run specified (use 'torun' property).";
            System.err.println(message);
            throw new RuntimeException(message);
        }
        Vector<String> naVect = new Vector<String>();
        int i = 0;
        while (i < argv.length) {
            String arg = argv[i];
            if (arg.startsWith("-D")) {
                String key = arg.substring(2, arg.length());
                String value = null;
                int pos = key.indexOf("=");
                if (pos > 0) {
                    value = key.substring(pos + 1);
                    key = key.substring(0, pos);
                    System.setProperty(key, value);
                } else {
                    naVect.add(arg);
                }
            } else {
                naVect.add(arg);
            }
            ++i;
        }
        String[] newargv = new String[naVect.size()];
        int i2 = 0;
        while (i2 < naVect.size()) {
            newargv[i2] = (String)naVect.get(i2);
            ++i2;
        }
        String securityProvider = System.getProperty("wasp.security.provider");
        if (securityProvider != null) {
            try {
                Class<?> clazz = Class.forName(securityProvider);
                Provider provider = (Provider)clazz.newInstance();
                Security.insertProviderAt(provider, 1);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Could not load security provider " + securityProvider);
            }
            catch (Exception e) {
                System.err.println("Could not instanciate security provider " + securityProvider);
            }
        }
        Method mainMethod = null;
        try {
            Class<?> clazz = Class.forName(mainClass);
            Class[] paramTypes = new Class[]{newargv.getClass()};
            mainMethod = clazz.getMethod("main", paramTypes);
        }
        catch (ClassNotFoundException e) {
            String message = "Cannot find class: " + e.getMessage();
            System.err.println(message);
            throw new RuntimeException(message);
        }
        catch (NoSuchMethodException e) {
            String message = "No main method: " + e.getMessage();
            System.err.println(message);
            throw new RuntimeException(message);
        }
        try {
            Object[] args = new Object[]{newargv};
            mainMethod.invoke(null, args);
        }
        catch (IllegalAccessException e) {
            String message = "Cannot invoke main method: " + e.getMessage();
            System.err.println(message);
            e.printStackTrace();
            throw new RuntimeException(message);
        }
        catch (InvocationTargetException e) {
            Throwable ee = e.getTargetException();
            String message = "Exception: " + ee.getMessage();
            System.err.println(message);
            ee.printStackTrace();
            throw new RuntimeException(message);
        }
    }
}

