/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.persistentstore;

import com.idoox.debug.Category;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.systinet.uddi.config.ConfigHelper;
import com.systinet.uddi.config.ConfigurationException;
import com.systinet.uddi.database.config.DatabaseConfig;
import com.systinet.wasp.persistentstore.DbDestinationMsgPersistentStore;
import com.systinet.wasp.persistentstore.DbDestinationMsgStoreManagement;
import com.systinet.wasp.persistentstore.DbSequencePersistentStore;
import com.systinet.wasp.persistentstore.DbSequenceStoreManagement;
import com.systinet.wasp.persistentstore.DbSourceMsgPersistentStore;
import com.systinet.wasp.persistentstore.DbSourceMsgStoreManagement;
import com.systinet.wasp.persistentstore.WaspInstanceHelper;
import java.io.Externalizable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.idoox.config.Configurable;
import org.idoox.util.LongSet;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Module;
import org.idoox.wasp.WaspInternalException;
import org.systinet.wasp.sequence.ISequence;
import org.systinet.wasp.sequence.PersistentSequenceStore;
import org.systinet.wasp.sequence.PersistentStoreException;
import org.systinet.wasp.sequence.management.PersistentSequenceStoreManagement;
import org.systinet.wasp.sequence.messagestore.PersistentDestinationStore;
import org.systinet.wasp.sequence.messagestore.PersistentSourceStore;
import org.systinet.wasp.sequence.messagestore.management.PersistentMessageStoreManagement;
import org.systinet.wasp.transaction.CurrentTransaction;

public class PersistentStoreModule
implements Module {
    private static Category log = Category.getCategory((String)"com.systinet.wasp.persistentstore.PersistentStoreModule");
    private DbSequencePstoreLazyWrapper sequenceStoreWrapper = null;
    private DbSourceMsgPstoreLazyWrapper sourceMsgStoreWrapper = null;
    private DbDestinationMsgPstoreLazyWrapper destinationMsgStoreWrapper = null;
    private volatile boolean lazyInitDone = false;
    static /* synthetic */ Class class$org$systinet$wasp$sequence$PersistentSequenceStore;
    static /* synthetic */ Class class$org$systinet$wasp$sequence$messagestore$PersistentSourceStore;
    static /* synthetic */ Class class$org$systinet$wasp$sequence$messagestore$PersistentDestinationStore;
    static /* synthetic */ Class class$com$systinet$uddi$database$config$DatabaseConfig;

    public synchronized void load(Configurable config) throws WaspInternalException {
        this.sequenceStoreWrapper = new DbSequencePstoreLazyWrapper();
        InitialReferencesRegistrar.addInitialReference((String)(class$org$systinet$wasp$sequence$PersistentSequenceStore == null ? (class$org$systinet$wasp$sequence$PersistentSequenceStore = PersistentStoreModule.class$("org.systinet.wasp.sequence.PersistentSequenceStore")) : class$org$systinet$wasp$sequence$PersistentSequenceStore).getName(), (Object)this.sequenceStoreWrapper);
        this.sourceMsgStoreWrapper = new DbSourceMsgPstoreLazyWrapper();
        InitialReferencesRegistrar.addInitialReference((String)(class$org$systinet$wasp$sequence$messagestore$PersistentSourceStore == null ? (class$org$systinet$wasp$sequence$messagestore$PersistentSourceStore = PersistentStoreModule.class$("org.systinet.wasp.sequence.messagestore.PersistentSourceStore")) : class$org$systinet$wasp$sequence$messagestore$PersistentSourceStore).getName(), (Object)this.sourceMsgStoreWrapper);
        this.destinationMsgStoreWrapper = new DbDestinationMsgPstoreLazyWrapper();
        InitialReferencesRegistrar.addInitialReference((String)(class$org$systinet$wasp$sequence$messagestore$PersistentDestinationStore == null ? (class$org$systinet$wasp$sequence$messagestore$PersistentDestinationStore = PersistentStoreModule.class$("org.systinet.wasp.sequence.messagestore.PersistentDestinationStore")) : class$org$systinet$wasp$sequence$messagestore$PersistentDestinationStore).getName(), (Object)this.destinationMsgStoreWrapper);
    }

    public void init() throws WaspInternalException {
        try {
            Configurable configurable = ConfigHelper.getConfigurable((String)"database");
            DatabaseConfig dbConfig = (DatabaseConfig)configurable.narrow(class$com$systinet$uddi$database$config$DatabaseConfig == null ? (class$com$systinet$uddi$database$config$DatabaseConfig = PersistentStoreModule.class$("com.systinet.uddi.database.config.DatabaseConfig")) : class$com$systinet$uddi$database$config$DatabaseConfig);
            int maxNumberOfConnections = dbConfig.getDatabase().getConnectionPool().getMaxPoolSize();
            if (CurrentTransaction.getMaximumTransactions() > maxNumberOfConnections) {
                CurrentTransaction.setMaximumTransactions((int)maxNumberOfConnections);
                log.debug("Setting CurrentTransaction.setMaximumTransactions to " + maxNumberOfConnections);
            }
        }
        catch (ConfigurationException cfge) {
            throw new WaspInternalException("Cannot read database configuration", (Throwable)cfge);
        }
    }

    public void destroy() {
        DbSequencePersistentStore.destroyInstance();
        DbSourceMsgPersistentStore.destroyInstance();
        DbDestinationMsgPersistentStore.destroyInstance();
        WaspInstanceHelper.destroyInstance();
    }

    private final void lazyInit() {
        if (this.lazyInitDone) {
            return;
        }
        try {
            this.sequenceStoreWrapper.wrappedInst = DbSequencePersistentStore.getInstance();
        }
        catch (PersistentStoreException e) {
            String msg = "Cannot init sequence DB persistent store";
            log.error(msg, (Throwable)e);
            throw new RuntimeWrappedException(msg, (Throwable)e);
        }
        try {
            this.sourceMsgStoreWrapper.wrappedInst = DbSourceMsgPersistentStore.getInstance();
        }
        catch (PersistentStoreException e) {
            String msg = "Cannot init source message DB persistent store";
            log.error(msg, (Throwable)e);
            throw new RuntimeWrappedException(msg, (Throwable)e);
        }
        try {
            this.destinationMsgStoreWrapper.wrappedInst = DbDestinationMsgPersistentStore.getInstance();
        }
        catch (PersistentStoreException e) {
            String msg = "Cannot init destination message DB persistent store";
            log.error(msg, (Throwable)e);
            throw new RuntimeWrappedException(msg, (Throwable)e);
        }
        this.lazyInitDone = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class DbDestinationMsgPstoreLazyWrapper
    implements PersistentDestinationStore,
    PersistentMessageStoreManagement {
        private volatile PersistentDestinationStore wrappedInst;
        private DbDestinationMsgStoreManagement management = new DbDestinationMsgStoreManagement();

        private DbDestinationMsgPstoreLazyWrapper() {
        }

        public void insert(String sequenceId, long messageNumber, Externalizable message, boolean marked, long timeWhenReceived) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.insert(sequenceId, messageNumber, message, marked, timeWhenReceived);
        }

        public void setMarked(String sequenceId, long messageNumber) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.setMarked(sequenceId, messageNumber);
        }

        public void delete(String sequenceId, long messageNumber) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.delete(sequenceId, messageNumber);
        }

        public Iterator select(int number, ClassLoader classLoader) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            return this.wrappedInst.select(number, classLoader);
        }

        public Externalizable select(String sequenceId, long messageNumber, ClassLoader classLoader) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            return this.wrappedInst.select(sequenceId, messageNumber, classLoader);
        }

        public void setActive(String sequenceId, long messageNumber) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.setActive(sequenceId, messageNumber);
        }

        public void deleteAll(String sequenceId) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.deleteAll(sequenceId);
        }

        public void setBlocked(String sequenceId, boolean newValue) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.setBlocked(sequenceId, newValue);
        }

        public int clear() {
            return this.management.clear();
        }

        public Iterator select(ClassLoader classLoader) {
            return this.management.select(classLoader);
        }

        public Collection select(String sequenceId, String waspInstance, ClassLoader classLoader) throws PersistentStoreException {
            return this.management.select(sequenceId, waspInstance, classLoader);
        }

        public Collection select(String sequenceId, long numberFrom, long numberTo, String waspInstance, ClassLoader classLoader) throws PersistentStoreException {
            return this.management.select(sequenceId, numberFrom, numberTo, waspInstance, classLoader);
        }

        public int deleteForAnyInstance(String waspInstance) throws PersistentStoreException {
            return this.management.deleteForAnyInstance(waspInstance);
        }

        public int delete(String sequenceId, String waspInstance) throws PersistentStoreException {
            return this.management.delete(sequenceId, waspInstance);
        }

        public int delete(String sequenceId, long numberFrom, long numberTo, String waspInstance) throws PersistentStoreException {
            return this.management.delete(sequenceId, numberFrom, numberTo, waspInstance);
        }

        public int deleteByPrefix(String prefix, long numberFrom, long numberTo, String waspInstance) throws PersistentStoreException {
            return this.management.delete(prefix, numberFrom, numberTo, waspInstance);
        }

        public int deleteByPrefix(String prefix, String waspInstance) throws PersistentStoreException {
            return this.management.deleteByPrefix(prefix, waspInstance);
        }

        public int deleteByEndpoint(String endpoint, String sequencePrefix, long numberFrom, long numberTo, String waspInstance) throws PersistentStoreException {
            return this.management.deleteByEndpoint(endpoint, sequencePrefix, numberFrom, numberTo, waspInstance);
        }

        public int deleteByEndpoint(String endpoint, String sequencePrefix, String waspInstance) throws PersistentStoreException {
            return this.management.deleteByEndpoint(endpoint, sequencePrefix, waspInstance);
        }
    }

    private final class DbSourceMsgPstoreLazyWrapper
    implements PersistentSourceStore,
    PersistentMessageStoreManagement {
        private volatile PersistentSourceStore wrappedInst;
        private DbSourceMsgStoreManagement management = new DbSourceMsgStoreManagement();

        private DbSourceMsgPstoreLazyWrapper() {
        }

        public void insert(String sequenceId, long messageNumber, Externalizable message, Externalizable metaData, long timeToReschedule) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.insert(sequenceId, messageNumber, message, metaData, timeToReschedule);
        }

        public Iterator selectMetadata(String sequenceId, LongSet intervals, ClassLoader classLoader) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            return this.wrappedInst.selectMetadata(sequenceId, intervals, classLoader);
        }

        public void updateTimeToReschedule(String sequenceId, long messageNumber, long timeToReschedule) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.updateTimeToReschedule(sequenceId, messageNumber, timeToReschedule);
        }

        public void delete(String sequenceId, LongSet intervals) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.delete(sequenceId, intervals);
        }

        public Iterator select(int number, ClassLoader classLoader) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            return this.wrappedInst.select(number, classLoader);
        }

        public Externalizable select(String sequenceId, long messageNumber, ClassLoader classLoader) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            return this.wrappedInst.select(sequenceId, messageNumber, classLoader);
        }

        public void setActive(String sequenceId, long messageNumber) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.setActive(sequenceId, messageNumber);
        }

        public void deleteAll(String sequenceId) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.deleteAll(sequenceId);
        }

        public void setBlocked(String sequenceId, boolean newValue) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.setBlocked(sequenceId, newValue);
        }

        public int clear() {
            return this.management.clear();
        }

        public Iterator select(ClassLoader classLoader) {
            return this.management.select(classLoader);
        }

        public Collection select(String sequenceId, String waspInstance, ClassLoader classLoader) throws PersistentStoreException {
            return this.management.select(sequenceId, waspInstance, classLoader);
        }

        public Collection select(String sequenceId, long numberFrom, long numberTo, String waspInstance, ClassLoader classLoader) throws PersistentStoreException {
            return this.management.select(sequenceId, numberFrom, numberTo, waspInstance, classLoader);
        }

        public int deleteForAnyInstance(String waspInstance) throws PersistentStoreException {
            return this.management.deleteForAnyInstance(waspInstance);
        }

        public int delete(String sequenceId, String waspInstance) throws PersistentStoreException {
            return this.management.delete(sequenceId, waspInstance);
        }

        public int delete(String sequenceId, long numberFrom, long numberTo, String waspInstance) throws PersistentStoreException {
            return this.management.delete(sequenceId, numberFrom, numberTo, waspInstance);
        }

        public int deleteByPrefix(String prefix, long numberFrom, long numberTo, String waspInstance) throws PersistentStoreException {
            return this.management.deleteByPrefix(prefix, numberFrom, numberTo, waspInstance);
        }

        public int deleteByPrefix(String prefix, String waspInstance) throws PersistentStoreException {
            return this.management.deleteByPrefix(prefix, waspInstance);
        }

        public int deleteByEndpoint(String endpoint, String sequencePrefix, long numberFrom, long numberTo, String waspInstance) throws PersistentStoreException {
            return this.management.deleteByEndpoint(endpoint, sequencePrefix, numberFrom, numberTo, waspInstance);
        }

        public int deleteByEndpoint(String endpoint, String sequencePrefix, String waspInstance) throws PersistentStoreException {
            return this.management.deleteByEndpoint(endpoint, sequencePrefix, waspInstance);
        }
    }

    private final class DbSequencePstoreLazyWrapper
    implements PersistentSequenceStore,
    PersistentSequenceStoreManagement {
        private volatile PersistentSequenceStore wrappedInst;
        private DbSequenceStoreManagement management = new DbSequenceStoreManagement();

        private DbSequencePstoreLazyWrapper() {
        }

        public void insertSequence(ISequence sequence) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.insertSequence(sequence);
        }

        public void updateSequence(ISequence sequence) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.updateSequence(sequence);
        }

        public PersistentSequenceStore.SequenceData getSequence(String id, boolean output) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            return this.wrappedInst.getSequence(id, output);
        }

        public PersistentSequenceStore.SequenceData findSequence(String prefix, boolean output) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            return this.wrappedInst.findSequence(prefix, output);
        }

        public List findSequences(String prefix, boolean output) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            return this.wrappedInst.findSequences(prefix, output);
        }

        public void removeSequence(String id, boolean output) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.removeSequence(id, output);
        }

        public String[] findSequenceIDs(String endpointPath) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            return this.wrappedInst.findSequenceIDs(endpointPath);
        }

        public void enqueueSequence(String id, boolean output, String queueID, long priority) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.enqueueSequence(id, output, queueID, priority);
        }

        public void updateSequence(String id, boolean output, String queueID, long priority) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.updateSequence(id, output, queueID, priority);
        }

        public void removeSequence(String id, boolean output, String queueID) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            this.wrappedInst.removeSequence(id, output, queueID);
        }

        public PersistentSequenceStore.QueueRecord getFirstSequence(String queueID) throws PersistentStoreException {
            PersistentStoreModule.this.lazyInit();
            return this.wrappedInst.getFirstSequence(queueID);
        }

        public void clear() {
            this.management.clear();
        }

        public Iterator select() {
            return this.management.select();
        }

        public Collection selectAll(String waspInstance) throws PersistentStoreException {
            return this.management.selectAll(waspInstance);
        }

        public Collection selectByEndpoint(String endpoint, String sequencePrefix, String waspInstance) throws PersistentStoreException {
            return this.management.selectByEndpoint(endpoint, sequencePrefix, waspInstance);
        }

        public Collection selectById(String id, PersistentSequenceStoreManagement.SequenceDirection direction, String waspInstance) throws PersistentStoreException {
            return this.management.selectById(id, direction, waspInstance);
        }

        public Collection selectByPrefix(String prefix, PersistentSequenceStoreManagement.SequenceDirection direction, String waspInstance) throws PersistentStoreException {
            return this.management.selectByPrefix(prefix, direction, waspInstance);
        }

        public int deleteAll(String waspInstance) throws PersistentStoreException {
            return this.management.deleteAll(waspInstance);
        }

        public int deleteByEndpoint(String endpoint, String sequencePrefix, String waspInstance) throws PersistentStoreException {
            return this.management.deleteByEndpoint(endpoint, sequencePrefix, waspInstance);
        }

        public int deleteById(String id, PersistentSequenceStoreManagement.SequenceDirection direction, String waspInstance) throws PersistentStoreException {
            return this.management.deleteById(id, direction, waspInstance);
        }

        public int deleteByPrefix(String prefix, PersistentSequenceStoreManagement.SequenceDirection direction, String waspInstance) throws PersistentStoreException {
            return this.management.deleteByPrefix(prefix, direction, waspInstance);
        }
    }
}

