/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.persistentstore;

import com.systinet.persistence.query.PersistentClass;
import com.systinet.persistence.query.PersistentField;
import com.systinet.wasp.persistentstore.DbCommonMsgStoreManagement;
import com.systinet.wasp.persistentstore.DbSourceMessage;
import com.systinet.wasp.persistentstore.DbSourceMsgPersistentStore;
import java.io.Serializable;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.sequence.PersistentStoreException;
import org.systinet.wasp.sequence.messagestore.management.PersistentMessageStoreManagement;

public final class DbSourceMsgStoreManagement
extends DbCommonMsgStoreManagement {
    private volatile boolean initialized = false;

    protected synchronized void ensureInit() {
        if (this.initialized) {
            return;
        }
        try {
            DbSourceMsgPersistentStore.ensureTablesExist();
        }
        catch (PersistentStoreException e) {
            throw new RuntimeWrappedException("Initization failed", (Throwable)e);
        }
        this.initialized = true;
    }

    protected PersistentClass getMsgPersistentClass() {
        return DbSourceMessage.PERS_CLASS;
    }

    protected PersistentField getWaspInstanceField() {
        return DbSourceMessage.WASP_INSTANCE_FIELD;
    }

    protected PersistentField getSequecneIdField() {
        return DbSourceMessage.SEQUENCE_ID_FIELD;
    }

    protected PersistentField getMessageNumField() {
        return DbSourceMessage.MSG_NUM_FIELD;
    }

    protected Serializable extractMessageDataFromPersistentClass(Object instance) {
        return ((DbSourceMessage)instance).message;
    }

    protected PersistentMessageStoreManagement.PersistentMessageData wrapPersistentClassInstance(Object instance) {
        return new DbSourceMessageWrapper((DbSourceMessage)instance);
    }

    protected boolean messagesAreOutput() {
        return true;
    }

    private static class DbSourceMessageWrapper
    implements PersistentMessageStoreManagement.PersistentSourceMessageData {
        private DbSourceMessage msg;

        public DbSourceMessageWrapper(DbSourceMessage msg) {
            if (msg == null) {
                throw new NullPointerException("msg param cannot be null");
            }
            this.msg = msg;
        }

        public long getTimeToReschedule() {
            return this.msg.timeToReschedule;
        }

        public Serializable getMetadata() {
            return this.msg.metadata;
        }

        public String getSequenceId() {
            return this.msg.sequenceIdPK;
        }

        public long getMessageNumber() {
            return this.msg.messageNumberPK;
        }

        public boolean isBlocked() {
            return this.msg.blocked;
        }

        public boolean isActive() {
            return this.msg.active;
        }

        public Serializable getMessage() {
            return this.msg.message;
        }
    }
}

