/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.persistentstore;

import com.idoox.debug.Category;
import com.systinet.persistence.PersistenceDbCoreException;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.PersistenceManager;
import com.systinet.persistence.PersistenceSqlException;
import com.systinet.persistence.query.Constant;
import com.systinet.persistence.query.DeleteQuery;
import com.systinet.persistence.query.Expression;
import com.systinet.persistence.query.OrderBy;
import com.systinet.persistence.query.PersistentFieldCollection;
import com.systinet.persistence.query.PersistentFieldFilter;
import com.systinet.persistence.query.PersistentFieldFilterImpl;
import com.systinet.persistence.query.Query;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.TransactionManager;
import com.systinet.wasp.persistentstore.DbMsgPersistentStore;
import com.systinet.wasp.persistentstore.DbPersistentStore;
import com.systinet.wasp.persistentstore.DbSourceMessage;
import com.systinet.wasp.persistentstore.DbTerminatorHelper;
import com.systinet.wasp.persistentstore.PersistentStorePersistenceException;
import com.systinet.wasp.persistentstore.WaspInstanceHelper;
import java.io.Externalizable;
import java.sql.SQLException;
import java.util.Iterator;
import org.idoox.util.LongSet;
import org.systinet.wasp.sequence.PersistentStoreException;
import org.systinet.wasp.sequence.messagestore.PersistentMessageStore;
import org.systinet.wasp.sequence.messagestore.PersistentSourceStore;
import org.systinet.wasp.transaction.db.DbTerminator;

public class DbSourceMsgPersistentStore
extends DbMsgPersistentStore
implements PersistentSourceStore {
    private static Category log = Category.getCategory((String)"com.systinet.wasp.persistentstore.DbSourceMsgPersistentStore");
    private static DbSourceMsgPersistentStore instance = null;
    private static final Class[] persistentClasses = new Class[]{class$com$systinet$wasp$persistentstore$DbSourceMessage == null ? (class$com$systinet$wasp$persistentstore$DbSourceMessage = DbSourceMsgPersistentStore.class$("com.systinet.wasp.persistentstore.DbSourceMessage")) : class$com$systinet$wasp$persistentstore$DbSourceMessage};
    private static final PersistentFieldCollection instanceBlockedActiveTime = new PersistentFieldCollection();
    private static final PersistentFieldCollection[] indexes;
    private static boolean tablesCreated;
    private final Expression theRightWaspExpr;
    private static final PersistentFieldFilter MESSAGE_TIME_FILTER;
    static /* synthetic */ Class class$com$systinet$wasp$persistentstore$DbSourceMessage;
    static /* synthetic */ Class class$com$systinet$wasp$persistentstore$DbSourceMsgPersistentStore$MessageRecordImpl;

    static synchronized void ensureTablesExist() throws PersistentStorePersistenceException {
        if (tablesCreated) {
            return;
        }
        tablesCreated = true;
        PersistenceManager pm = PersistenceManager.getInstance();
        try {
            pm.createTables(persistentClasses, indexes);
        }
        catch (PersistenceException e) {
            throw new PersistentStorePersistenceException(e);
        }
    }

    public static synchronized DbSourceMsgPersistentStore getInstance() throws PersistentStoreException {
        if (instance == null) {
            DbSourceMsgPersistentStore.ensureTablesExist();
            instance = new DbSourceMsgPersistentStore(WaspInstanceHelper.getWaspInstance());
        }
        return instance;
    }

    static synchronized void destroyInstance() {
        tablesCreated = false;
        instance = null;
    }

    private DbSourceMsgPersistentStore(int waspInstance) throws PersistentStorePersistenceException {
        super(waspInstance);
        this.theRightWaspExpr = DbSourceMessage.WASP_INSTANCE_FIELD.equal((long)waspInstance);
        this.init();
    }

    private void init() throws PersistentStorePersistenceException {
        String sql = "UPDATE " + DbSourceMessage.TABLE_NAME + " SET " + DbSourceMessage.BLOCKED_FIELD.name() + "=?" + " , " + DbSourceMessage.ACTIVE_FIELD.name() + "=?" + " WHERE " + DbSourceMessage.WASP_INSTANCE_FIELD.name() + "=?";
        Constant[] parameter = new Constant[]{Constant.valueOf((boolean)true), Constant.valueOf((boolean)false), Constant.valueOf((int)this.waspInstance)};
        DbPersistentStore.updateSqlCommonStatic(sql, parameter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(String sequenceId, long messageNumber, Externalizable message, Externalizable metaData, long timeToReschedule) throws PersistentStoreException {
        DbSourceMessage dbData = new DbSourceMessage(this.waspInstance, sequenceId, messageNumber, false, false, timeToReschedule, metaData, null);
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                block9: {
                    TransactionManager tm = DbPersistentStore.persMgr.getDatabase().getTransactionManager();
                    tm.beginReadWrite();
                    boolean ok = false;
                    try {
                        DbPersistentStore.persMgr.insert((Object)dbData);
                        dbData.message = message;
                        DbPersistentStore.persMgr.update((Object)dbData, DbSourceMessage.MESSAGE_FILTER);
                        tm.commit();
                        ok = true;
                        Object var13_12 = null;
                        if (ok) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var13_13 = null;
                        if (ok) throw throwable;
                        tm.rollback();
                        throw throwable;
                    }
                    tm.rollback();
                }
                Object var15_16 = null;
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
            catch (DatabaseCoreException e) {
                throw new PersistentStorePersistenceException(new PersistenceDbCoreException(e));
            }
            catch (SQLException e) {
                throw new PersistentStorePersistenceException((Throwable)new PersistenceSqlException(e));
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator selectMetadata(String sequenceId, LongSet intervals, ClassLoader classLoader) throws PersistentStoreException {
        SelectMetadaIteratorWrappper selectMetadaIteratorWrappper;
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                Expression seqCond = DbSourceMessage.SEQUENCE_ID_FIELD.equal(sequenceId);
                Expression msgNumCond = this.createMsgNumCond(intervals);
                Expression getCond = this.theRightWaspExpr.and(seqCond.and(msgNumCond));
                Query getQ = new Query(getCond, DbSourceMessage.METADATA_FILTER);
                try {
                    selectMetadaIteratorWrappper = new SelectMetadaIteratorWrappper(getQ, classLoader);
                    Object var11_12 = null;
                }
                catch (PersistenceException e) {
                    getQ.close();
                    throw e;
                }
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
        return selectMetadaIteratorWrappper;
    }

    private Expression createMsgNumCond(LongSet intervals) {
        Expression msgNumCond = null;
        Iterator intervalIter = intervals.getPoints();
        while (intervalIter.hasNext()) {
            LongSet.LongPoint cpoint = (LongSet.LongPoint)intervalIter.next();
            long clower = cpoint.getLower();
            long cupper = cpoint.getUpper();
            Expression cbetweenEpr = DbSourceMessage.MSG_NUM_FIELD.between(clower, cupper);
            msgNumCond = msgNumCond == null ? cbetweenEpr : msgNumCond.or(cbetweenEpr);
        }
        if (msgNumCond == null) {
            throw new IllegalArgumentException("Param 'intervals' is empty");
        }
        return msgNumCond;
    }

    public void setActive(String sequenceId, long messageNumber) throws PersistentStoreException {
        DbSourceMessage dbData = new DbSourceMessage();
        dbData.waspInstancePK = this.waspInstance;
        dbData.sequenceIdPK = sequenceId;
        dbData.messageNumberPK = messageNumber;
        dbData.active = true;
        this.updateCommon(dbData, DbSourceMessage.ACTIVE_FILTER);
    }

    public void updateTimeToReschedule(String sequenceId, long messageNumber, long timeToReschedule) throws PersistentStoreException {
        DbSourceMessage dbData = new DbSourceMessage();
        dbData.waspInstancePK = this.waspInstance;
        dbData.sequenceIdPK = sequenceId;
        dbData.messageNumberPK = messageNumber;
        dbData.active = false;
        dbData.timeToReschedule = timeToReschedule;
        this.updateCommon(dbData, DbSourceMessage.TIME_ACTIVE_FILTER);
    }

    public void delete(String sequenceId, LongSet intervals) throws PersistentStoreException {
        if (intervals.isEmpty()) {
            return;
        }
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                Expression seqCond = DbSourceMessage.SEQUENCE_ID_FIELD.equal(sequenceId);
                Expression msgNumCond = this.createMsgNumCond(intervals);
                Expression deleteCond = this.theRightWaspExpr.and(seqCond.and(msgNumCond));
                DeleteQuery deleteQ = new DeleteQuery(deleteCond);
                deleteQ.execute();
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
    }

    public void setBlocked(String sequenceId, boolean newValue) throws PersistentStoreException {
        String sql = "UPDATE " + DbSourceMessage.TABLE_NAME + " SET " + DbSourceMessage.BLOCKED_FIELD.name() + "=?" + " WHERE " + DbSourceMessage.SEQUENCE_ID_FIELD.name() + "=?" + "  AND " + DbSourceMessage.WASP_INSTANCE_FIELD.name() + "=?";
        Constant[] parameters = new Constant[]{Constant.valueOf((boolean)newValue), Constant.valueOf((String)sequenceId), Constant.valueOf((int)this.waspInstance)};
        this.updateSqlCommon(sql, parameters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator select(int number, ClassLoader classLoader) throws PersistentStoreException {
        DbMsgPersistentStore.QueryResultSetIteratorWrapper queryResultSetIteratorWrapper;
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                Expression notBlocked = DbSourceMessage.BLOCKED_FIELD.equal(false);
                Expression notActive = DbSourceMessage.ACTIVE_FIELD.equal(false);
                OrderBy order = new OrderBy();
                order.addAsc(DbSourceMessage.TIME_FIELD);
                Query getQ = new Query(this.theRightWaspExpr.and(notBlocked).and(notActive), class$com$systinet$wasp$persistentstore$DbSourceMsgPersistentStore$MessageRecordImpl == null ? (class$com$systinet$wasp$persistentstore$DbSourceMsgPersistentStore$MessageRecordImpl = DbSourceMsgPersistentStore.class$("com.systinet.wasp.persistentstore.DbSourceMsgPersistentStore$MessageRecordImpl")) : class$com$systinet$wasp$persistentstore$DbSourceMsgPersistentStore$MessageRecordImpl, order, MESSAGE_TIME_FILTER, number);
                try {
                    queryResultSetIteratorWrapper = new DbMsgPersistentStore.QueryResultSetIteratorWrapper(getQ, classLoader);
                    Object var10_11 = null;
                }
                catch (PersistenceException e) {
                    getQ.close();
                    throw e;
                }
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
        return queryResultSetIteratorWrapper;
    }

    public Externalizable select(String sequenceId, long messageNumber, ClassLoader classLoader) throws PersistentStoreException {
        DbSourceMessage msg = (DbSourceMessage)this.selectCommon(this.theRightWaspExpr, DbSourceMessage.SEQUENCE_ID_FIELD, sequenceId, DbSourceMessage.MSG_NUM_FIELD, messageNumber, DbSourceMessage.MESSAGE_FILTER, classLoader);
        return msg.message;
    }

    public void deleteAll(String sequenceId) throws PersistentStoreException {
        DbMsgPersistentStore.deleteAll(this.theRightWaspExpr, DbSourceMessage.SEQUENCE_ID_FIELD, sequenceId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        instanceBlockedActiveTime.add(DbSourceMessage.WASP_INSTANCE_FIELD);
        instanceBlockedActiveTime.add(DbSourceMessage.BLOCKED_FIELD);
        instanceBlockedActiveTime.add(DbSourceMessage.ACTIVE_FIELD);
        instanceBlockedActiveTime.add(DbSourceMessage.TIME_FIELD);
        indexes = new PersistentFieldCollection[]{instanceBlockedActiveTime};
        tablesCreated = false;
        MESSAGE_TIME_FILTER = PersistentFieldFilterImpl.getPositiveFilter((Class)(class$com$systinet$wasp$persistentstore$DbSourceMsgPersistentStore$MessageRecordImpl == null ? (class$com$systinet$wasp$persistentstore$DbSourceMsgPersistentStore$MessageRecordImpl = DbSourceMsgPersistentStore.class$("com.systinet.wasp.persistentstore.DbSourceMsgPersistentStore$MessageRecordImpl")) : class$com$systinet$wasp$persistentstore$DbSourceMsgPersistentStore$MessageRecordImpl), (String[])new String[]{"message", "timeToReschedule"});
    }

    public static class MessageRecordImpl
    implements PersistentMessageStore.MessageRecord {
        public Externalizable message;
        public long timeToReschedule;

        public Externalizable getMessage() {
            return this.message;
        }

        public long getTime() {
            return this.timeToReschedule;
        }
    }

    private static class SelectMetadaIteratorWrappper
    extends DbMsgPersistentStore.QueryResultSetIteratorWrapper {
        SelectMetadaIteratorWrappper(Query query, ClassLoader loader) throws PersistenceException {
            super(query, loader);
        }

        public Object next() {
            return ((DbSourceMessage)super.next()).metadata;
        }
    }
}

