/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.persistentstore;

import com.idoox.debug.Category;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.PersistenceManager;
import com.systinet.persistence.ResultSetIterator;
import com.systinet.persistence.query.Constant;
import com.systinet.persistence.query.DeleteQuery;
import com.systinet.persistence.query.Expression;
import com.systinet.persistence.query.OrderBy;
import com.systinet.persistence.query.PersistentField;
import com.systinet.persistence.query.PersistentFieldCollection;
import com.systinet.persistence.query.Query;
import com.systinet.wasp.persistentstore.DbPersistentStore;
import com.systinet.wasp.persistentstore.DbSequenceData;
import com.systinet.wasp.persistentstore.DbSequenceQueue;
import com.systinet.wasp.persistentstore.DbTerminatorHelper;
import com.systinet.wasp.persistentstore.PersistentStorePersistenceException;
import com.systinet.wasp.persistentstore.WaspInstanceHelper;
import java.util.ArrayList;
import java.util.List;
import org.systinet.wasp.sequence.ISequence;
import org.systinet.wasp.sequence.PersistentSequenceStore;
import org.systinet.wasp.sequence.PersistentStoreException;
import org.systinet.wasp.transaction.db.DbTerminator;

public class DbSequencePersistentStore
extends DbPersistentStore
implements PersistentSequenceStore {
    private static Category log = Category.getCategory((String)"com.systinet.wasp.persistentstore.DbSequencePersistentStore");
    private static DbSequencePersistentStore instance = null;
    private static Class[] persistentClasses = new Class[]{class$com$systinet$wasp$persistentstore$DbSequenceData == null ? (class$com$systinet$wasp$persistentstore$DbSequenceData = DbSequencePersistentStore.class$("com.systinet.wasp.persistentstore.DbSequenceData")) : class$com$systinet$wasp$persistentstore$DbSequenceData, class$com$systinet$wasp$persistentstore$DbSequenceQueue == null ? (class$com$systinet$wasp$persistentstore$DbSequenceQueue = DbSequencePersistentStore.class$("com.systinet.wasp.persistentstore.DbSequenceQueue")) : class$com$systinet$wasp$persistentstore$DbSequenceQueue};
    private static PersistentFieldCollection searchByEndpointPath = new PersistentFieldCollection(class$com$systinet$wasp$persistentstore$DbSequenceData == null ? (class$com$systinet$wasp$persistentstore$DbSequenceData = DbSequencePersistentStore.class$("com.systinet.wasp.persistentstore.DbSequenceData")) : class$com$systinet$wasp$persistentstore$DbSequenceData, new String[]{"endpointPath"});
    private static PersistentFieldCollection maxSeqPriorityIndex = new PersistentFieldCollection(class$com$systinet$wasp$persistentstore$DbSequenceQueue == null ? (class$com$systinet$wasp$persistentstore$DbSequenceQueue = DbSequencePersistentStore.class$("com.systinet.wasp.persistentstore.DbSequenceQueue")) : class$com$systinet$wasp$persistentstore$DbSequenceQueue, new String[]{"waspInstancePK", "queueIdPK", "priority"});
    private static PersistentFieldCollection[] indexes = new PersistentFieldCollection[]{searchByEndpointPath, maxSeqPriorityIndex};
    private static boolean tablesCreated = false;
    final Expression theRightWaspExprData;
    final Expression theRightWaspExprQueue;
    static /* synthetic */ Class class$com$systinet$wasp$persistentstore$DbSequenceData;
    static /* synthetic */ Class class$com$systinet$wasp$persistentstore$DbSequenceQueue;
    static /* synthetic */ Class class$com$systinet$wasp$persistentstore$DbSequencePersistentStore$QueueRecordImpl;

    static synchronized void ensureTablesExist() throws PersistentStorePersistenceException {
        if (tablesCreated) {
            return;
        }
        tablesCreated = true;
        PersistenceManager pm = PersistenceManager.getInstance();
        try {
            pm.createTables(persistentClasses, indexes);
        }
        catch (PersistenceException e) {
            throw new PersistentStorePersistenceException(e);
        }
    }

    public static synchronized DbSequencePersistentStore getInstance() throws PersistentStoreException {
        if (instance == null) {
            DbSequencePersistentStore.ensureTablesExist();
            instance = new DbSequencePersistentStore(WaspInstanceHelper.getWaspInstance());
        }
        return instance;
    }

    static synchronized void destroyInstance() {
        tablesCreated = false;
        instance = null;
    }

    private DbSequencePersistentStore(int waspInstance) throws PersistentStoreException {
        super(waspInstance);
        this.theRightWaspExprData = DbSequenceData.WASP_INSTANCE_FIELD.equal((long)waspInstance);
        this.theRightWaspExprQueue = DbSequenceQueue.WASP_INSTANCE_FIELD.equal((long)waspInstance);
        this.init();
    }

    private void init() throws PersistentStorePersistenceException {
        String sql = "UPDATE " + DbSequenceData.PERS_CLASS.getName() + " SET " + DbSequenceData.PROCESSING_ID_FIELD.name() + "=?" + " WHERE " + DbSequenceData.WASP_INSTANCE_FIELD.name() + "=?";
        Constant[] parameter = new Constant[]{Constant.valueOf((long)-1L), Constant.valueOf((int)this.waspInstance)};
        DbPersistentStore.updateSqlCommonStatic(sql, parameter);
    }

    public void insertSequence(ISequence sequence) throws PersistentStoreException {
        DbSequenceData seqData = DbSequenceData.valueOf(sequence, this.waspInstance);
        this.insertCommon(seqData);
    }

    public void updateSequence(ISequence sequence) throws PersistentStoreException {
        DbSequenceData seqData = DbSequenceData.valueOf(sequence, this.waspInstance);
        int updCnt = this.updateCommon(seqData, DbSequenceData.EXCEPT_ENDPOINT_PATH);
        if (updCnt == 0) {
            throw new PersistentStoreException("Record " + seqData + " is not in DB");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PersistentSequenceStore.SequenceData getSequence(String id, boolean output) throws PersistentStoreException {
        DbSequenceData dbSequenceData;
        DbTerminator terminator;
        block10: {
            PersistentSequenceStore.SequenceData sequenceData;
            block9: {
                terminator = DbTerminatorHelper.ensureTx();
                try {
                    try {
                        Query getQuery;
                        block8: {
                            block7: {
                                Expression idCond = DbSequenceData.ID_FIELD.equal(id);
                                Expression outputCond = DbSequenceData.OUTPUT_FIELD.equal(output);
                                Expression pkCond = this.theRightWaspExprData.and(idCond.and(outputCond));
                                getQuery = new Query(pkCond);
                                try {
                                    DbSequenceData sequenceData2;
                                    ResultSetIterator iter = getQuery.execute();
                                    if (!iter.hasNext()) {
                                        sequenceData = null;
                                        Object var13_11 = null;
                                        break block7;
                                    }
                                    dbSequenceData = sequenceData2 = (DbSequenceData)iter.next();
                                    break block8;
                                }
                                catch (Throwable throwable) {
                                    Object var13_13 = null;
                                    getQuery.close();
                                    throw throwable;
                                }
                            }
                            getQuery.close();
                            Object var15_14 = null;
                            break block9;
                        }
                        Object var13_12 = null;
                        getQuery.close();
                        break block10;
                    }
                    catch (PersistenceException e) {
                        throw new PersistentStorePersistenceException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    DbTerminator.suspendTx((DbTerminator)terminator);
                    throw throwable;
                }
            }
            DbTerminator.suspendTx((DbTerminator)terminator);
            return sequenceData;
        }
        Object var15_15 = null;
        DbTerminator.suspendTx((DbTerminator)terminator);
        return dbSequenceData;
    }

    public PersistentSequenceStore.SequenceData findSequence(String prefix, boolean output) throws PersistentStoreException {
        List sequences = this.findSequenceInternal(prefix, output, 1);
        if (sequences.size() == 0) {
            return null;
        }
        return (PersistentSequenceStore.SequenceData)sequences.get(0);
    }

    public List findSequences(String prefix, boolean output) throws PersistentStoreException {
        return this.findSequenceInternal(prefix, output, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List findSequenceInternal(String prefix, boolean output, int limit) throws PersistentStorePersistenceException {
        ArrayList<Object> arrayList;
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                Query getQuery;
                Expression outputCond = DbSequenceData.OUTPUT_FIELD.equal(output);
                if (prefix == null || prefix.equals("")) {
                    getQuery = new Query(this.theRightWaspExprData.and(outputCond), class$com$systinet$wasp$persistentstore$DbSequenceData == null ? (class$com$systinet$wasp$persistentstore$DbSequenceData = DbSequencePersistentStore.class$("com.systinet.wasp.persistentstore.DbSequenceData")) : class$com$systinet$wasp$persistentstore$DbSequenceData, null, limit);
                } else {
                    prefix = PersistentField.escapeLikePattern((String)prefix);
                    Expression idCond = DbSequenceData.ID_FIELD.like(prefix + "%");
                    Expression cond = this.theRightWaspExprData.and(outputCond.and(idCond));
                    getQuery = new Query(cond, class$com$systinet$wasp$persistentstore$DbSequenceData == null ? (class$com$systinet$wasp$persistentstore$DbSequenceData = DbSequencePersistentStore.class$("com.systinet.wasp.persistentstore.DbSequenceData")) : class$com$systinet$wasp$persistentstore$DbSequenceData, null, limit);
                }
                try {
                    ArrayList<Object> results = new ArrayList<Object>();
                    ResultSetIterator iter = getQuery.execute();
                    while (true) {
                        if (!iter.hasNext()) {
                            arrayList = results;
                            Object var11_11 = null;
                            break;
                        }
                        results.add(iter.next());
                    }
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    getQuery.close();
                    throw throwable;
                }
                getQuery.close();
                Object var13_13 = null;
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] findSequenceIDs(String endpointPath) throws PersistentStoreException {
        String[] stringArray;
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                Expression endpointPathCond = DbSequenceData.ENDPOINT_PATH_FIELD.equal(endpointPath);
                Expression cond = endpointPathCond.and(this.theRightWaspExprData);
                Query getQuery = new Query(cond, DbSequenceData.ID_FILTER);
                try {
                    ArrayList<String> results = new ArrayList<String>();
                    ResultSetIterator iter = getQuery.execute();
                    while (true) {
                        if (!iter.hasNext()) {
                            stringArray = results.toArray(new String[results.size()]);
                            Object var10_10 = null;
                            break;
                        }
                        DbSequenceData curSeqData = (DbSequenceData)iter.next();
                        results.add(curSeqData.idPK);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    getQuery.close();
                    throw throwable;
                }
                getQuery.close();
                Object var12_12 = null;
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
        return stringArray;
    }

    public void removeSequence(String id, boolean output) throws PersistentStoreException {
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                Expression deleteCond = DbSequenceData.ID_FIELD.equal(id).and(DbSequenceData.OUTPUT_FIELD.equal(output));
                DeleteQuery dq = new DeleteQuery(this.theRightWaspExprData.and(deleteCond));
                dq.execute();
                Expression deleteFromQueueCond = DbSequenceQueue.ID_PERS_FIELD.equal(id).and(DbSequenceQueue.OUTPUT_PERS_FIELD.equal(output));
                DeleteQuery queueDq = new DeleteQuery(this.theRightWaspExprQueue.and(deleteFromQueueCond));
                queueDq.execute();
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
    }

    public void enqueueSequence(String id, boolean output, String queueID, long priority) throws PersistentStoreException {
        DbSequenceQueue queueData = new DbSequenceQueue(this.waspInstance, id, output, queueID, priority);
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                DbPersistentStore.persMgr.insert((Object)queueData);
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
    }

    public void updateSequence(String id, boolean output, String queueID, long priority) throws PersistentStoreException {
        DbSequenceQueue queueData = new DbSequenceQueue(this.waspInstance, id, output, queueID, priority);
        this.updateCommon(queueData, null);
    }

    public void removeSequence(String id, boolean output, String queueID) throws PersistentStorePersistenceException {
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                Expression seqIdCond = DbSequenceQueue.ID_PERS_FIELD.equal(id);
                Expression outputCond = DbSequenceQueue.OUTPUT_PERS_FIELD.equal(output);
                Expression queueIdCond = DbSequenceQueue.QUEUE_ID_PERS_FIELD.equal(queueID);
                Expression deleteCond = seqIdCond.and(outputCond).and(queueIdCond);
                DeleteQuery dq = new DeleteQuery(this.theRightWaspExprQueue.and(deleteCond));
                dq.execute();
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PersistentSequenceStore.QueueRecord getFirstSequence(String queueId) throws PersistentStoreException {
        PersistentSequenceStore.QueueRecord queueRecord;
        DbTerminator terminator;
        block10: {
            PersistentSequenceStore.QueueRecord queueRecord2;
            block9: {
                terminator = DbTerminatorHelper.ensureTx();
                try {
                    try {
                        Query firstInQueue;
                        block8: {
                            block7: {
                                Expression chooseQueue = DbSequenceQueue.QUEUE_ID_PERS_FIELD.equal(queueId);
                                OrderBy order = new OrderBy();
                                order.addDesc(DbSequenceQueue.PRIORITY_PERS_FIELD);
                                firstInQueue = new Query(this.theRightWaspExprQueue.and(chooseQueue), class$com$systinet$wasp$persistentstore$DbSequencePersistentStore$QueueRecordImpl == null ? (class$com$systinet$wasp$persistentstore$DbSequencePersistentStore$QueueRecordImpl = DbSequencePersistentStore.class$("com.systinet.wasp.persistentstore.DbSequencePersistentStore$QueueRecordImpl")) : class$com$systinet$wasp$persistentstore$DbSequencePersistentStore$QueueRecordImpl, order, 1);
                                try {
                                    ResultSetIterator i = firstInQueue.execute();
                                    if (i.hasNext()) {
                                        PersistentSequenceStore.QueueRecord result;
                                        queueRecord2 = result = (PersistentSequenceStore.QueueRecord)i.next();
                                        Object var10_11 = null;
                                        break block7;
                                    }
                                    queueRecord = null;
                                    break block8;
                                }
                                catch (Throwable throwable) {
                                    Object var10_13 = null;
                                    firstInQueue.close();
                                    throw throwable;
                                }
                            }
                            firstInQueue.close();
                            Object var12_14 = null;
                            break block9;
                        }
                        Object var10_12 = null;
                        firstInQueue.close();
                        break block10;
                    }
                    catch (PersistenceException e) {
                        throw new PersistentStorePersistenceException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    DbTerminator.suspendTx((DbTerminator)terminator);
                    throw throwable;
                }
            }
            DbTerminator.suspendTx((DbTerminator)terminator);
            return queueRecord2;
        }
        Object var12_15 = null;
        DbTerminator.suspendTx((DbTerminator)terminator);
        return queueRecord;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class QueueRecordImpl
    implements PersistentSequenceStore.QueueRecord {
        public String idPK;
        public boolean outputPK;
        public long priority;

        public String getID() {
            return this.idPK;
        }

        public boolean isOutput() {
            return this.outputPK;
        }

        public long getPriority() {
            return this.priority;
        }

        public String toString() {
            return "QueueRecordImpl: id=" + this.idPK + " output=" + this.outputPK + " priority=" + this.priority;
        }
    }
}

