/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.persistentstore;

import com.idoox.debug.Category;
import com.systinet.persistence.PersistenceDbCoreException;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.PersistenceManager;
import com.systinet.persistence.query.Constant;
import com.systinet.persistence.query.DeleteQuery;
import com.systinet.persistence.query.Expression;
import com.systinet.persistence.query.PersistentClass;
import com.systinet.persistence.query.PersistentField;
import com.systinet.uddi.database.ConnectionMonitor;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.TransactionManager;
import com.systinet.wasp.persistentstore.DbPersistentStore;
import com.systinet.wasp.persistentstore.PersistentStorePersistenceException;
import com.systinet.wasp.persistentstore.WaspInstanceHelper;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.sequence.PersistentStoreException;

abstract class DbPersistentStoreManagement {
    private static Category log = Category.getCategory((String)"com.systinet.wasp.persistentstore.DbPersistentStoreManagement");

    DbPersistentStoreManagement() {
    }

    static final int updateSqlCommon(String pstmtSql, List parameters) throws PersistentStorePersistenceException {
        return DbPersistentStoreManagement.updateSqlCommon(pstmtSql, parameters.toArray(new Constant[parameters.size()]));
    }

    static final int updateSqlCommon(String pstmtSql, Constant[] parameters) throws PersistentStorePersistenceException {
        return DbPersistentStore.updateSqlCommonStatic(pstmtSql, parameters);
    }

    final int deleteForWhere(Expression where) throws PersistentStoreException {
        try {
            DeleteQuery dq = new DeleteQuery(where);
            return dq.execute();
        }
        catch (PersistenceException e) {
            throw new PersistentStorePersistenceException(e);
        }
    }

    final String createPrefixForLike(String prefix) {
        prefix = PersistentField.escapeLikePattern((String)prefix);
        return prefix + "%";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int clearTables(PersistentClass[] tables) {
        try {
            int n;
            PersistenceManager pm = PersistenceManager.getInstance();
            TransactionManager tm = pm.getDatabase().getTransactionManager();
            tm.beginReadWrite();
            boolean ok = false;
            try {
                int deletedRows;
                block12: {
                    ConnectionMonitor conn = tm.getConnection();
                    Statement stmt = null;
                    deletedRows = 0;
                    try {
                        stmt = conn.createStatement();
                        int i = 0;
                        while (true) {
                            if (i >= tables.length) {
                                Object var9_11 = null;
                                if (stmt == null) break block12;
                                break;
                            }
                            deletedRows += stmt.executeUpdate("DELETE FROM " + tables[i].getName() + " WHERE waspInstancePK=" + WaspInstanceHelper.getWaspInstance());
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        if (stmt != null) {
                            conn.close(stmt);
                        }
                        throw throwable;
                    }
                    conn.close(stmt);
                }
                tm.commit();
                ok = true;
                n = deletedRows;
                Object var11_14 = null;
                if (ok) return n;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (!ok) {
                    tm.rollback();
                }
                throw throwable;
            }
            tm.rollback();
            return n;
        }
        catch (PersistenceDbCoreException e) {
            log.warn("Clean failed", (Throwable)e);
            throw new RuntimeWrappedException((Throwable)e);
        }
        catch (DatabaseCoreException e) {
            log.warn("Clean failed", (Throwable)e);
            throw new RuntimeWrappedException((Throwable)e);
        }
        catch (SQLException e) {
            log.warn("Clean failed", (Throwable)e);
            throw new RuntimeWrappedException((Throwable)e);
        }
    }
}

