/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.persistentstore;

import com.idoox.debug.Category;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.ResultSetIterator;
import com.systinet.persistence.query.DeleteQuery;
import com.systinet.persistence.query.Expression;
import com.systinet.persistence.query.PersistentField;
import com.systinet.persistence.query.PersistentFieldFilter;
import com.systinet.persistence.query.Query;
import com.systinet.wasp.persistentstore.DbPersistentStore;
import com.systinet.wasp.persistentstore.DbTerminatorHelper;
import com.systinet.wasp.persistentstore.PersistentStorePersistenceException;
import java.util.Iterator;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.sequence.PersistentStoreException;
import org.systinet.wasp.transaction.db.DbTerminator;

abstract class DbMsgPersistentStore
extends DbPersistentStore {
    private static Category log = Category.getCategory((String)"com.systinet.wasp.persistentstore.DbMsgPersistentStore");

    DbMsgPersistentStore(int waspInstance) {
        super(waspInstance);
    }

    static final void deleteAll(Expression waspInstanceExpr, PersistentField persistentField, String sequenceId) throws PersistentStoreException {
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                Expression deleteCond = waspInstanceExpr.and(persistentField.equal(sequenceId));
                DeleteQuery deleteQ = new DeleteQuery(deleteCond);
                deleteQ.execute();
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Object selectCommon(Expression waspInstanceExpr, PersistentField sequenceIdField, String sequenceId, PersistentField messageNumberField, long messageNumber, PersistentFieldFilter resultFilter, ClassLoader classLoader) throws PersistentStoreException {
        Object object;
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                Expression seqCond = sequenceIdField.equal(sequenceId);
                Expression msgNumCond = messageNumberField.equal(messageNumber);
                Query getQ = new Query(waspInstanceExpr.and(seqCond.and(msgNumCond)), resultFilter);
                try {
                    ResultSetIterator i = getQ.execute(classLoader);
                    if (!i.hasNext()) {
                        throw new PersistentStoreException("Record for msg: seq=" + sequenceId + ", num=" + messageNumber + " not found in DB");
                    }
                    object = i.next();
                    Object var16_15 = null;
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    getQ.close();
                    throw throwable;
                }
                getQ.close();
                Object var18_17 = null;
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
        return object;
    }

    static class QueryResultSetIteratorWrapper
    extends ResultSetIteratorWrapper {
        private Query query;

        QueryResultSetIteratorWrapper(Query query, ClassLoader loader) throws PersistenceException {
            super(query.execute(loader));
            this.query = query;
        }

        void close() {
            if (this.query != null) {
                try {
                    DbTerminator terminator = DbTerminatorHelper.ensureTx();
                    try {
                        this.query.close();
                        Object var3_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        DbTerminator.suspendTx((DbTerminator)terminator);
                        throw throwable;
                    }
                    DbTerminator.suspendTx((DbTerminator)terminator);
                    this.query = null;
                }
                catch (PersistenceException e) {
                    throw new RuntimeWrappedException((Throwable)e);
                }
                catch (PersistentStorePersistenceException e) {
                    throw new RuntimeWrappedException((Throwable)((Object)e));
                }
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.query != null) {
                    log.debug("There was as unclosed itaration for: " + this.query);
                    this.query.close();
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                super.finalize();
                throw throwable;
            }
            super.finalize();
        }
    }

    static abstract class ResultSetIteratorWrapper
    implements Iterator {
        private ResultSetIterator wrappedIterator;

        ResultSetIteratorWrapper(ResultSetIterator wrappedIterator) {
            if (wrappedIterator == null) {
                throw new NullPointerException("Param wrappedIterator is null");
            }
            this.wrappedIterator = wrappedIterator;
        }

        /*
         * WARNING - void declaration
         */
        public boolean hasNext() {
            try {
                void e;
                boolean result = this.wrappedIterator.hasNext();
                if (!result) {
                    this.close();
                }
                return (boolean)e;
            }
            catch (PersistenceException e) {
                this.close();
                throw new RuntimeWrappedException((Throwable)e);
            }
        }

        public Object next() {
            try {
                return this.wrappedIterator.next();
            }
            catch (PersistenceException e) {
                this.close();
                throw new RuntimeWrappedException((Throwable)e);
            }
        }

        public void remove() {
            try {
                this.wrappedIterator.remove();
            }
            catch (PersistenceException e) {
                this.close();
                throw new RuntimeWrappedException((Throwable)e);
            }
        }

        abstract void close();
    }
}

