/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.persistentstore;

import com.systinet.persistence.query.PersistentClass;
import com.systinet.persistence.query.PersistentField;
import com.systinet.wasp.persistentstore.DbCommonMsgStoreManagement;
import com.systinet.wasp.persistentstore.DbDestinationMessage;
import com.systinet.wasp.persistentstore.DbDestinationMsgPersistentStore;
import java.io.Serializable;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.sequence.PersistentStoreException;
import org.systinet.wasp.sequence.messagestore.management.PersistentMessageStoreManagement;

public final class DbDestinationMsgStoreManagement
extends DbCommonMsgStoreManagement {
    private boolean initialized = false;

    protected synchronized void ensureInit() {
        if (this.initialized) {
            return;
        }
        try {
            DbDestinationMsgPersistentStore.ensureTablesExist();
        }
        catch (PersistentStoreException e) {
            throw new RuntimeWrappedException("Initization failed", (Throwable)e);
        }
        this.initialized = true;
    }

    protected PersistentClass getMsgPersistentClass() {
        return DbDestinationMessage.PERS_CLASS;
    }

    protected PersistentField getWaspInstanceField() {
        return DbDestinationMessage.WASP_INSTANCE_FIELD;
    }

    protected PersistentField getSequecneIdField() {
        return DbDestinationMessage.SEQUENCE_ID_FIELD;
    }

    protected PersistentField getMessageNumField() {
        return DbDestinationMessage.MSG_NUM_FIELD;
    }

    protected Serializable extractMessageDataFromPersistentClass(Object instance) {
        return ((DbDestinationMessage)instance).message;
    }

    protected PersistentMessageStoreManagement.PersistentMessageData wrapPersistentClassInstance(Object instance) {
        return new DbDestinationMessageWrapper((DbDestinationMessage)instance);
    }

    protected boolean messagesAreOutput() {
        return false;
    }

    private static class DbDestinationMessageWrapper
    implements PersistentMessageStoreManagement.PersistentDestinationMessageData {
        private DbDestinationMessage msg;

        DbDestinationMessageWrapper(DbDestinationMessage msg) {
            this.msg = msg;
        }

        public long getTimeWhenReceived() {
            return this.msg.timeWhenReceived;
        }

        public boolean isMarked() {
            return this.msg.marked;
        }

        public String getSequenceId() {
            return this.msg.sequenceIdPK;
        }

        public long getMessageNumber() {
            return this.msg.messageNumberPK;
        }

        public boolean isBlocked() {
            return this.msg.blocked;
        }

        public boolean isActive() {
            return this.msg.active;
        }

        public Serializable getMessage() {
            return this.msg.message;
        }
    }
}

