/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.persistentstore;

import com.idoox.debug.Category;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.PersistenceManager;
import com.systinet.persistence.query.Constant;
import com.systinet.persistence.query.DeleteQuery;
import com.systinet.persistence.query.Expression;
import com.systinet.persistence.query.OrderBy;
import com.systinet.persistence.query.PersistentFieldCollection;
import com.systinet.persistence.query.PersistentFieldFilter;
import com.systinet.persistence.query.PersistentFieldFilterImpl;
import com.systinet.persistence.query.Query;
import com.systinet.wasp.persistentstore.DbDestinationMessage;
import com.systinet.wasp.persistentstore.DbMsgPersistentStore;
import com.systinet.wasp.persistentstore.DbPersistentStore;
import com.systinet.wasp.persistentstore.DbTerminatorHelper;
import com.systinet.wasp.persistentstore.PersistentStorePersistenceException;
import com.systinet.wasp.persistentstore.WaspInstanceHelper;
import java.io.Externalizable;
import java.util.Iterator;
import org.systinet.wasp.sequence.PersistentStoreException;
import org.systinet.wasp.sequence.messagestore.PersistentDestinationStore;
import org.systinet.wasp.sequence.messagestore.PersistentMessageStore;
import org.systinet.wasp.transaction.db.DbTerminator;

public class DbDestinationMsgPersistentStore
extends DbMsgPersistentStore
implements PersistentDestinationStore {
    private static Category log = Category.getCategory((String)"com.systinet.wasp.persistentstore.DbDestinationMsgPersistentStore");
    private static DbDestinationMsgPersistentStore instance = null;
    private static final Class[] PERSISTENT_CLASSES = new Class[]{class$com$systinet$wasp$persistentstore$DbDestinationMessage == null ? (class$com$systinet$wasp$persistentstore$DbDestinationMessage = DbDestinationMsgPersistentStore.class$("com.systinet.wasp.persistentstore.DbDestinationMessage")) : class$com$systinet$wasp$persistentstore$DbDestinationMessage};
    private static final PersistentFieldCollection INSTANCE_BLOCKED_ACTIVE_MARKED_TIME = new PersistentFieldCollection();
    private static final PersistentFieldCollection[] INDEXES;
    private static boolean tablesCreated;
    private final Expression theRightWaspExpr;
    private static final PersistentFieldFilter MESSAGE_AND_TIME_FILTER;
    static /* synthetic */ Class class$com$systinet$wasp$persistentstore$DbDestinationMessage;
    static /* synthetic */ Class class$com$systinet$wasp$persistentstore$DbDestinationMsgPersistentStore$MessageRecordImpl;

    static synchronized void ensureTablesExist() throws PersistentStorePersistenceException {
        if (tablesCreated) {
            return;
        }
        tablesCreated = true;
        PersistenceManager pm = PersistenceManager.getInstance();
        try {
            pm.createTables(PERSISTENT_CLASSES, INDEXES);
        }
        catch (PersistenceException e) {
            throw new PersistentStorePersistenceException(e);
        }
    }

    public static synchronized DbDestinationMsgPersistentStore getInstance() throws PersistentStoreException {
        if (instance == null) {
            DbDestinationMsgPersistentStore.ensureTablesExist();
            instance = new DbDestinationMsgPersistentStore(WaspInstanceHelper.getWaspInstance());
        }
        return instance;
    }

    static synchronized void destroyInstance() {
        tablesCreated = false;
        instance = null;
    }

    private DbDestinationMsgPersistentStore(int waspInstance) throws PersistentStoreException {
        super(waspInstance);
        this.theRightWaspExpr = DbDestinationMessage.WASP_INSTANCE_FIELD.equal((long)waspInstance);
        this.init();
    }

    private void init() throws PersistentStoreException {
        String sql = "UPDATE " + DbDestinationMessage.TABLE_NAME + " SET blocked=?, active=?" + " WHERE waspInstancePK=?";
        Constant[] parameters = new Constant[]{Constant.valueOf((boolean)true), Constant.valueOf((boolean)false), Constant.valueOf((int)this.waspInstance)};
        DbPersistentStore.updateSqlCommonStatic(sql, parameters);
    }

    public void insert(String sequenceId, long messageNumber, Externalizable message, boolean marked, long timeWhenReceived) throws PersistentStoreException {
        DbDestinationMessage dbData = new DbDestinationMessage(this.waspInstance, sequenceId, messageNumber, false, false, timeWhenReceived, marked, message);
        this.insertCommon(dbData);
    }

    public void setMarked(String sequenceId, long messageNumber) throws PersistentStoreException {
        DbDestinationMessage dbData = new DbDestinationMessage();
        dbData.waspInstancePK = this.waspInstance;
        dbData.sequenceIdPK = sequenceId;
        dbData.messageNumberPK = messageNumber;
        dbData.marked = true;
        this.updateCommon(dbData, DbDestinationMessage.MARKED_FILTER);
    }

    public void delete(String sequenceId, long messageNumber) throws PersistentStoreException {
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                Expression seqCond = DbDestinationMessage.SEQUENCE_ID_FIELD.equal(sequenceId);
                Expression msgNumCond = DbDestinationMessage.MSG_NUM_FIELD.equal(messageNumber);
                DeleteQuery deleteQ = new DeleteQuery(this.theRightWaspExpr.and(seqCond.and(msgNumCond)));
                deleteQ.execute();
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator select(int number, ClassLoader classLoader) throws PersistentStoreException {
        DbMsgPersistentStore.QueryResultSetIteratorWrapper queryResultSetIteratorWrapper;
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                Expression notBlocked = DbDestinationMessage.BLOCKED_FIELD.equal(false);
                Expression notActive = DbDestinationMessage.ACTIVE_FIELD.equal(false);
                Expression isMarked = DbDestinationMessage.MARKED_FIELD.equal(true);
                Expression cond = this.theRightWaspExpr.and(notBlocked).and(notActive).and(isMarked);
                OrderBy order = new OrderBy();
                order.addAsc(DbDestinationMessage.TIME_FIELD);
                Query getQ = new Query(cond, class$com$systinet$wasp$persistentstore$DbDestinationMsgPersistentStore$MessageRecordImpl == null ? (class$com$systinet$wasp$persistentstore$DbDestinationMsgPersistentStore$MessageRecordImpl = DbDestinationMsgPersistentStore.class$("com.systinet.wasp.persistentstore.DbDestinationMsgPersistentStore$MessageRecordImpl")) : class$com$systinet$wasp$persistentstore$DbDestinationMsgPersistentStore$MessageRecordImpl, order, MESSAGE_AND_TIME_FILTER, number);
                try {
                    queryResultSetIteratorWrapper = new DbMsgPersistentStore.QueryResultSetIteratorWrapper(getQ, classLoader);
                    Object var12_13 = null;
                }
                catch (PersistenceException e) {
                    getQ.close();
                    throw e;
                }
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
        return queryResultSetIteratorWrapper;
    }

    public Externalizable select(String sequenceId, long messageNumber, ClassLoader classLoader) throws PersistentStoreException {
        DbDestinationMessage msg = (DbDestinationMessage)this.selectCommon(this.theRightWaspExpr, DbDestinationMessage.SEQUENCE_ID_FIELD, sequenceId, DbDestinationMessage.MSG_NUM_FIELD, messageNumber, DbDestinationMessage.MESSAGE_FILTER, classLoader);
        return msg.message;
    }

    public void setActive(String sequenceId, long messageNumber) throws PersistentStoreException {
        DbDestinationMessage dbData = new DbDestinationMessage();
        dbData.waspInstancePK = this.waspInstance;
        dbData.sequenceIdPK = sequenceId;
        dbData.messageNumberPK = messageNumber;
        dbData.active = true;
        this.updateCommon(dbData, DbDestinationMessage.ACTIVE_FILTER);
    }

    public void setBlocked(String sequenceId, boolean newValue) throws PersistentStoreException {
        String sql = "UPDATE " + DbDestinationMessage.TABLE_NAME + " SET " + DbDestinationMessage.BLOCKED_FIELD.name() + "=?" + " WHERE " + DbDestinationMessage.SEQUENCE_ID_FIELD.name() + "=?" + "  AND " + DbDestinationMessage.WASP_INSTANCE_FIELD.name() + "=?";
        Constant[] parameters = new Constant[]{Constant.valueOf((boolean)newValue), Constant.valueOf((String)sequenceId), Constant.valueOf((int)this.waspInstance)};
        this.updateSqlCommon(sql, parameters);
    }

    public void deleteAll(String sequenceId) throws PersistentStoreException {
        DbMsgPersistentStore.deleteAll(this.theRightWaspExpr, DbDestinationMessage.SEQUENCE_ID_FIELD, sequenceId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        INSTANCE_BLOCKED_ACTIVE_MARKED_TIME.add(DbDestinationMessage.WASP_INSTANCE_FIELD);
        INSTANCE_BLOCKED_ACTIVE_MARKED_TIME.add(DbDestinationMessage.BLOCKED_FIELD);
        INSTANCE_BLOCKED_ACTIVE_MARKED_TIME.add(DbDestinationMessage.ACTIVE_FIELD);
        INSTANCE_BLOCKED_ACTIVE_MARKED_TIME.add(DbDestinationMessage.MARKED_FIELD);
        INSTANCE_BLOCKED_ACTIVE_MARKED_TIME.add(DbDestinationMessage.TIME_FIELD);
        INDEXES = new PersistentFieldCollection[]{INSTANCE_BLOCKED_ACTIVE_MARKED_TIME};
        tablesCreated = false;
        MESSAGE_AND_TIME_FILTER = PersistentFieldFilterImpl.getPositiveFilter((Class)(class$com$systinet$wasp$persistentstore$DbDestinationMsgPersistentStore$MessageRecordImpl == null ? (class$com$systinet$wasp$persistentstore$DbDestinationMsgPersistentStore$MessageRecordImpl = DbDestinationMsgPersistentStore.class$("com.systinet.wasp.persistentstore.DbDestinationMsgPersistentStore$MessageRecordImpl")) : class$com$systinet$wasp$persistentstore$DbDestinationMsgPersistentStore$MessageRecordImpl), (String[])new String[]{"message", "timeWhenReceived"});
    }

    public static class MessageRecordImpl
    implements PersistentMessageStore.MessageRecord {
        public Externalizable message;
        public long timeWhenReceived;

        public Externalizable getMessage() {
            return this.message;
        }

        public long getTime() {
            return this.timeWhenReceived;
        }
    }
}

