/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.persistentstore;

import com.idoox.debug.Category;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.ResultSetIterator;
import com.systinet.persistence.query.Constant;
import com.systinet.persistence.query.DeleteQuery;
import com.systinet.persistence.query.Expression;
import com.systinet.persistence.query.PersistentClass;
import com.systinet.persistence.query.PersistentField;
import com.systinet.persistence.query.Query;
import com.systinet.wasp.persistentstore.DbPersistentStoreManagement;
import com.systinet.wasp.persistentstore.DbSequenceData;
import com.systinet.wasp.persistentstore.DbSequencePersistentStore;
import com.systinet.wasp.persistentstore.PersistentStorePersistenceException;
import com.systinet.wasp.persistentstore.WaspInstanceHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.sequence.PersistentStoreException;
import org.systinet.wasp.sequence.messagestore.management.PersistentMessageStoreManagement;

abstract class DbCommonMsgStoreManagement
extends DbPersistentStoreManagement
implements PersistentMessageStoreManagement {
    private static Category log = Category.getCategory((String)"com.systinet.wasp.persistentstore.DbCommonMsgStoreManagement");

    DbCommonMsgStoreManagement() {
    }

    protected abstract void ensureInit();

    protected abstract PersistentClass getMsgPersistentClass();

    protected abstract PersistentField getWaspInstanceField();

    protected abstract PersistentField getSequecneIdField();

    protected abstract PersistentField getMessageNumField();

    protected abstract Serializable extractMessageDataFromPersistentClass(Object var1);

    protected abstract PersistentMessageStoreManagement.PersistentMessageData wrapPersistentClassInstance(Object var1);

    protected abstract boolean messagesAreOutput();

    public int clear() {
        this.ensureInit();
        return DbPersistentStoreManagement.clearTables(new PersistentClass[]{this.getMsgPersistentClass()});
    }

    public Iterator select(ClassLoader classLoader) {
        this.ensureInit();
        try {
            Iterator iterator;
            Expression waspInstanceCond = this.getWaspInstanceField().equal((long)WaspInstanceHelper.getWaspInstance());
            Query getMsgsQ = new Query(waspInstanceCond);
            try {
                ArrayList<Serializable> results = new ArrayList<Serializable>();
                ResultSetIterator i = getMsgsQ.execute(classLoader);
                while (i.hasNext()) {
                    results.add(this.extractMessageDataFromPersistentClass(i.next()));
                }
                iterator = results.iterator();
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                getMsgsQ.close();
                throw throwable;
            }
            getMsgsQ.close();
            return iterator;
        }
        catch (PersistenceException e) {
            log.warn("Select failed", (Throwable)e);
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public Collection select(String sequenceId, String waspInstance, ClassLoader classLoader) throws PersistentStoreException {
        this.ensureInit();
        Expression where = this.getSequecneIdField().equal(sequenceId);
        where = this.addWaspInstance(where, waspInstance);
        if (where == null) {
            return new ArrayList(1);
        }
        return this.getDbSourceDataWrapperListFrom(where, classLoader);
    }

    public Collection select(String sequenceId, long numberFrom, long numberTo, String waspInstance, ClassLoader classLoader) throws PersistentStoreException {
        this.ensureInit();
        Expression where = this.getSequecneIdField().equal(sequenceId);
        where = this.addWaspInstance(where, waspInstance);
        if (where == null) {
            return new ArrayList(1);
        }
        where = this.addMessageRange(where, numberFrom, numberTo);
        return this.getDbSourceDataWrapperListFrom(where, classLoader);
    }

    public int deleteForAnyInstance(String waspInstance) throws PersistentStorePersistenceException {
        this.ensureInit();
        if (waspInstance == null) {
            return DbPersistentStoreManagement.updateSqlCommon("DELETE FROM " + this.getMsgPersistentClass().getName(), (Constant[])null);
        }
        int waspId = WaspInstanceHelper.translateWaspInstance(waspInstance);
        if (waspId == -1) {
            return 0;
        }
        Expression where = this.getWaspInstanceField().equal((long)waspId);
        DeleteQuery dq = new DeleteQuery(where);
        try {
            return dq.execute();
        }
        catch (PersistenceException e) {
            throw new PersistentStorePersistenceException(e);
        }
    }

    public int delete(String sequenceId, String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        Expression where = this.createWhereForId(sequenceId, waspInstance);
        if (where == null) {
            return 0;
        }
        return this.deleteForWhere(where);
    }

    public int delete(String sequenceId, long numberFrom, long numberTo, String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        Expression where = this.createWhereForId(sequenceId, waspInstance);
        if (where == null) {
            return 0;
        }
        where = this.addMessageRange(where, numberFrom, numberTo);
        return this.deleteForWhere(where);
    }

    public int deleteByPrefix(String prefix, long numberFrom, long numberTo, String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        Expression where = this.createWhereForPrefix(prefix, waspInstance);
        if (where == null) {
            return 0;
        }
        where = this.addMessageRange(where, numberFrom, numberTo);
        return this.deleteForWhere(where);
    }

    public int deleteByPrefix(String prefix, String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        Expression where = this.createWhereForPrefix(prefix, waspInstance);
        if (where == null) {
            return 0;
        }
        return this.deleteForWhere(where);
    }

    public int deleteByEndpoint(String endpoint, String sequencePrefix, long numberFrom, long numberTo, String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        PstmtConstantsPair pair = this.createPstmtForEndpoint(endpoint, sequencePrefix, waspInstance);
        if (pair == null) {
            return 0;
        }
        String enhPstmt = pair.pstmt + " AND " + this.getMessageNumField().name() + " BETWEEN ? AND ?";
        List constants = pair.constants;
        constants.add(Constant.valueOf((long)numberFrom));
        constants.add(Constant.valueOf((long)numberTo));
        return DbPersistentStoreManagement.updateSqlCommon(enhPstmt, constants);
    }

    public int deleteByEndpoint(String endpoint, String sequencePrefix, String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        PstmtConstantsPair pair = this.createPstmtForEndpoint(endpoint, sequencePrefix, waspInstance);
        if (pair == null) {
            return 0;
        }
        return DbPersistentStoreManagement.updateSqlCommon(pair.pstmt, pair.constants);
    }

    private List getDbSourceDataWrapperListFrom(Expression where, ClassLoader cl) throws PersistentStoreException {
        try {
            ArrayList<PersistentMessageStoreManagement.PersistentMessageData> arrayList;
            Query q = new Query(where);
            try {
                ArrayList<PersistentMessageStoreManagement.PersistentMessageData> result = new ArrayList<PersistentMessageStoreManagement.PersistentMessageData>();
                ResultSetIterator i = q.execute(cl);
                while (i.hasNext()) {
                    result.add(this.wrapPersistentClassInstance(i.next()));
                }
                arrayList = result;
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                q.close();
                throw throwable;
            }
            q.close();
            return arrayList;
        }
        catch (PersistenceException e) {
            throw new PersistentStorePersistenceException(e);
        }
    }

    private Expression addWaspInstance(Expression where, String waspInstance) throws PersistentStorePersistenceException {
        if (waspInstance == null) {
            return where;
        }
        int waspId = WaspInstanceHelper.translateWaspInstance(waspInstance);
        if (waspId == -1) {
            return null;
        }
        return where.and(this.getWaspInstanceField().equal((long)waspId));
    }

    private Expression addMessageRange(Expression where, long numberFrom, long numberTo) {
        return where.and(this.getMessageNumField().between(numberFrom, numberTo));
    }

    private Expression createWhereForId(String sequenceId, String waspInstance) throws PersistentStorePersistenceException {
        Expression where = this.getSequecneIdField().equal(sequenceId);
        return this.addWaspInstance(where, waspInstance);
    }

    private Expression createWhereForPrefix(String prefix, String waspInstance) throws PersistentStorePersistenceException {
        Expression where = this.getSequecneIdField().like(this.createPrefixForLike(prefix));
        return this.addWaspInstance(where, waspInstance);
    }

    private PstmtConstantsPair createPstmtForEndpoint(String endpoint, String sequencePrefix, String waspInstance) throws PersistentStorePersistenceException {
        DbSequencePersistentStore.ensureTablesExist();
        StringBuffer sql = new StringBuffer();
        ArrayList<Constant> params = new ArrayList<Constant>(4);
        sql.append("DELETE FROM " + this.getMsgPersistentClass().getName() + " WHERE ");
        if (waspInstance != null) {
            int waspId = WaspInstanceHelper.translateWaspInstance(waspInstance);
            if (waspId == -1) {
                return null;
            }
            sql.append(this.getWaspInstanceField().name() + "=? AND ");
            params.add(Constant.valueOf((int)waspId));
        }
        if (sequencePrefix != null) {
            sql.append(this.getSequecneIdField().name() + " LIKE ? AND ");
            params.add(Constant.valueOf((String)this.createPrefixForLike(sequencePrefix)));
        }
        sql.append("1 IN (SELECT 1");
        sql.append(" FROM " + DbSequenceData.PERS_CLASS.getName());
        sql.append(" WHERE DbSequenceData.waspInstancePK=" + this.getMsgPersistentClass().getName() + ".waspInstancePK");
        sql.append(" AND DbSequenceData.idPK=" + this.getMsgPersistentClass().getName() + ".sequenceIdPK");
        sql.append(" AND " + DbSequenceData.OUTPUT_FIELD.name() + "=?");
        params.add(Constant.valueOf((boolean)this.messagesAreOutput()));
        sql.append(" AND " + DbSequenceData.ENDPOINT_PATH_FIELD.name() + "=?");
        params.add(Constant.valueOf((String)endpoint));
        sql.append(")");
        return new PstmtConstantsPair(sql.toString(), params);
    }

    private static class PstmtConstantsPair {
        String pstmt;
        List constants;

        public PstmtConstantsPair(String pstmt, List constants) {
            this.pstmt = pstmt;
            this.constants = constants;
        }
    }
}

