/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.admin;

import java.io.Serializable;

public class ServiceBindingPerformanceLog
implements Serializable {
    public long last = 0L;
    public long slowest = 0L;
    public long fastest = Long.MAX_VALUE;
    public long average = 0L;
    public long total = 0L;
    public int hits = 0;
    public long lastRequestTimestamp;

    public void reset() {
        this.total = 0L;
        this.average = 0L;
        this.slowest = 0L;
        this.last = 0L;
        this.fastest = Long.MAX_VALUE;
        this.hits = 0;
    }

    public void update(long last) {
        this.last = last;
        this.total += last;
        ++this.hits;
        if (this.slowest < last) {
            this.slowest = last;
        }
        if (this.fastest > last) {
            this.fastest = last;
        }
        this.average = this.total / (long)this.hits;
        this.lastRequestTimestamp = System.currentTimeMillis();
    }

    public String toString() {
        return "\nPerformance record:\n last   : " + this.last + "\n" + " slowest: " + this.slowest + "\n" + " fastest: " + this.fastest + "\n" + " average: " + this.average + "\n" + " total  : " + this.total + "\n" + " hits   : " + this.hits + "\n" + " stamp  : " + this.lastRequestTimestamp + "\n";
    }
}

