/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.admin.interceptor;

import com.systinet.wasp.admin.interceptor.MsgSizeCheckerInterceptorConfigHelper;
import java.io.IOException;
import java.util.Hashtable;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.InputMessageWrapper;
import org.idoox.wasp.Context;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.interceptor.TransportInterceptor;
import org.systinet.wasp.admin.InputSizeException;

public class MsgSizeCheckerInterceptor
implements TransportInterceptor {
    private static boolean persistentLimits = true;
    private static Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
    public static Hashtable limitMap = new Hashtable();
    static /* synthetic */ Class class$com$systinet$wasp$admin$interceptor$MsgSizeCheckerInterceptorConfigHelper;

    public MsgSizeCheckerInterceptor() {
        try {
            MsgSizeCheckerInterceptor.loadLimits();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void load(Configurable config) {
    }

    public void destroy() {
    }

    public void intercept(Connection connection, InterceptorChain chain, int position) {
        this.intercept(connection);
    }

    public void intercept(Connection connection) {
        String path = connection.getURI().getPath();
        int limit = Integer.MAX_VALUE;
        Integer i = (Integer)limitMap.get(path);
        if (i != null) {
            limit = i;
        }
        if (connection.getInputMessage() != null) {
            connection.setInputMessage((InputMessage)new CheckedInputMessage(connection.getInputMessage(), limit));
        }
    }

    public static int getLimit(String bindingUri) {
        Hashtable hashtable = limitMap;
        synchronized (hashtable) {
            Integer i = (Integer)limitMap.get(bindingUri);
            if (i != null) {
                int n = i;
                return n;
            }
            int n = -1;
            return n;
        }
    }

    public static void setLimit(String bindingUri, int maxMessageLength) {
        Hashtable hashtable = limitMap;
        synchronized (hashtable) {
            limitMap.put(bindingUri, new Integer(maxMessageLength));
            try {
                MsgSizeCheckerInterceptor.storeLimits();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public static void removeLimit(String bindingUri) {
        Hashtable hashtable = limitMap;
        synchronized (hashtable) {
            limitMap.remove(bindingUri);
            try {
                MsgSizeCheckerInterceptor.storeLimits();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private static void storeLimits() {
        MsgSizeCheckerInterceptorConfigHelper helper;
        if (limitMap.size() == 0) {
            return;
        }
        Integer[] limits = limitMap.values().toArray(new Integer[0]);
        String[] bindings = limitMap.keySet().toArray(new String[0]);
        if (limits == null || bindings == null || limits.length != bindings.length) {
            return;
        }
        Configurable configurable = Configurator.getConfigurable((String)"config", (String)"main");
        if (configurable != null && (helper = (MsgSizeCheckerInterceptorConfigHelper)configurable.narrow(class$com$systinet$wasp$admin$interceptor$MsgSizeCheckerInterceptorConfigHelper == null ? (class$com$systinet$wasp$admin$interceptor$MsgSizeCheckerInterceptorConfigHelper = MsgSizeCheckerInterceptor.class$("com.systinet.wasp.admin.interceptor.MsgSizeCheckerInterceptorConfigHelper")) : class$com$systinet$wasp$admin$interceptor$MsgSizeCheckerInterceptorConfigHelper)) != null) {
            MsgSizeCheckerInterceptorConfigHelper.MsgSizeCheckerInterceptorConfig c = helper.newMsgSizeCheckerInterceptorConfig();
            MsgSizeCheckerInterceptorConfigHelper.MsgSizeCheckerInterceptorConfig.Limit[] configLimits = new MsgSizeCheckerInterceptorConfigHelper.MsgSizeCheckerInterceptorConfig.Limit[limits.length];
            int i = 0;
            while (i < limits.length) {
                configLimits[i] = c.newLimit();
                configLimits[i].setValue(limits[i].toString());
                configLimits[i].setBinding(bindings[i]);
                ++i;
            }
            helper.setMsgSizeCheckerInterceptorConfig(c);
            c.setLimit(configLimits);
        }
        Configurator.flush();
    }

    private static void loadLimits() {
        MsgSizeCheckerInterceptorConfigHelper.MsgSizeCheckerInterceptorConfig.Limit[] limits;
        MsgSizeCheckerInterceptorConfigHelper.MsgSizeCheckerInterceptorConfig c;
        MsgSizeCheckerInterceptorConfigHelper helper;
        Configurable configurable = Configurator.getConfigurable((String)"config", (String)"main");
        if (configurable != null && (helper = (MsgSizeCheckerInterceptorConfigHelper)configurable.narrow(class$com$systinet$wasp$admin$interceptor$MsgSizeCheckerInterceptorConfigHelper == null ? (class$com$systinet$wasp$admin$interceptor$MsgSizeCheckerInterceptorConfigHelper = MsgSizeCheckerInterceptor.class$("com.systinet.wasp.admin.interceptor.MsgSizeCheckerInterceptorConfigHelper")) : class$com$systinet$wasp$admin$interceptor$MsgSizeCheckerInterceptorConfigHelper)) != null && (c = helper.getMsgSizeCheckerInterceptorConfig()) != null && (limits = c.getLimit()) != null && limits.length != 0) {
            int i = 0;
            while (i < limits.length) {
                limitMap.put(limits[i].getBinding(), new Integer(limits[i].getValue()));
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class CheckedInputMessage
    extends InputMessageWrapper {
        private int size = 0;
        private int limit = Integer.MAX_VALUE;

        public CheckedInputMessage(InputMessage message, int limit) {
            super(message);
            this.limit = limit;
        }

        public int read(byte[] bytes) throws IOException {
            int n = super.read(bytes);
            if (n != -1) {
                this.checkSize(n);
            }
            return n;
        }

        public int read(byte[] bytes, int offset, int length) throws IOException {
            int n = super.read(bytes, offset, length);
            if (n != -1) {
                this.checkSize(n);
            }
            return n;
        }

        public int read() throws IOException {
            int n = super.read();
            if (n != -1) {
                this.checkSize(1);
            }
            return n;
        }

        private void checkSize(int n) throws IOException {
            if (n != -1) {
                this.size += n;
            }
            if (this.limit < this.size) {
                this.close();
                throw new InputSizeException("Message too large (size/limit): " + this.size + "/" + this.limit, this.limit);
            }
        }
    }
}

