/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.admin.interceptor;

import java.io.IOException;
import java.util.Hashtable;
import org.idoox.config.Configurable;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.InputMessageWrapper;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.OutputMessageWrapper;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.interceptor.TransportInterceptor;
import org.systinet.wasp.admin.ServiceEndpointThroughputLog;

public class DataThroughputInterceptor
implements TransportInterceptor {
    public static Hashtable recordMap = new Hashtable();

    public void load(Configurable config) {
    }

    public void destroy() {
    }

    public void intercept(Connection connection, InterceptorChain chain, int position) {
        String path = connection.getURI().getPath();
        if (connection.getInputMessage() != null) {
            connection.setInputMessage((InputMessage)new DataThroughputInputMessage(connection.getInputMessage(), new ServiceEndpointThroughputLog(), path));
        }
        if (connection.getOutputMessage() != null) {
            connection.setOutputMessage((OutputMessage)new DataThroughputOutputMessage(connection.getOutputMessage(), new ServiceEndpointThroughputLog(), path));
        }
    }

    public static void resetRecord(String endpointPath) {
        DataThroughputInterceptor.addRecord(endpointPath);
    }

    public static void addRecord(String endpointPath) {
        recordMap.put(endpointPath, new ServiceEndpointThroughputLog());
    }

    public static ServiceEndpointThroughputLog getRecord(String endpointPath) {
        return (ServiceEndpointThroughputLog)recordMap.get(endpointPath);
    }

    public static void removeRecord(String endpointPath) {
        recordMap.remove(endpointPath);
    }

    class DataThroughputOutputMessage
    extends OutputMessageWrapper {
        private ServiceEndpointThroughputLog record = null;
        private String path = null;

        public DataThroughputOutputMessage(OutputMessage message, ServiceEndpointThroughputLog record, String path) {
            super(message);
            this.record = record;
            this.path = path;
        }

        public void write(byte[] b) throws IOException {
            if (b != null) {
                this.record.lastRequestOutBytes += (long)b.length;
            }
            super.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (b != null) {
                this.record.lastRequestOutBytes += (long)len;
            }
            super.write(b, off, len);
        }

        public void write(int b) throws IOException {
            ++this.record.lastRequestOutBytes;
            super.write(b);
        }

        public void close() throws IOException {
            super.close();
            Hashtable hashtable = recordMap;
            synchronized (hashtable) {
                ServiceEndpointThroughputLog masterRecord = (ServiceEndpointThroughputLog)recordMap.get(this.path);
                if (masterRecord == null) {
                    masterRecord = this.record;
                    masterRecord.totalOutBytes = masterRecord.lastRequestOutBytes;
                    if (this.record.lastRequestOutBytes > masterRecord.longestOutBytes) {
                        masterRecord.longestOutBytes = this.record.lastRequestOutBytes;
                    }
                    if (this.record.lastRequestOutBytes < masterRecord.shortestOutBytes) {
                        masterRecord.shortestOutBytes = this.record.lastRequestOutBytes;
                    }
                    recordMap.put(this.path, masterRecord);
                }
                masterRecord.totalOutBytes += this.record.lastRequestOutBytes;
                masterRecord.lastRequestOutBytes = this.record.lastRequestOutBytes;
                if (this.record.lastRequestOutBytes > masterRecord.longestOutBytes) {
                    masterRecord.longestOutBytes = this.record.lastRequestOutBytes;
                }
                if (this.record.lastRequestOutBytes < masterRecord.shortestOutBytes) {
                    masterRecord.shortestOutBytes = this.record.lastRequestOutBytes;
                }
            }
        }
    }

    class DataThroughputInputMessage
    extends InputMessageWrapper {
        private ServiceEndpointThroughputLog record = null;
        private String path = null;

        public DataThroughputInputMessage(InputMessage message, ServiceEndpointThroughputLog record, String path) {
            super(message);
            this.record = record;
            this.record.lastRequestTimestamp = System.currentTimeMillis();
            this.path = path;
        }

        public int read(byte[] b) throws IOException {
            int n = super.read(b);
            if (n != -1) {
                this.record.lastRequestInBytes += (long)n;
            }
            return n;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int n = super.read(b, off, len);
            if (n != -1) {
                this.record.lastRequestInBytes += (long)n;
            }
            return n;
        }

        public int read() throws IOException {
            int n = super.read();
            if (n != -1) {
                ++this.record.lastRequestInBytes;
            }
            return n;
        }

        public void close() throws IOException {
            super.close();
            Hashtable hashtable = recordMap;
            synchronized (hashtable) {
                ServiceEndpointThroughputLog masterRecord = (ServiceEndpointThroughputLog)recordMap.get(this.path);
                if (masterRecord == null) {
                    masterRecord = this.record;
                    ++masterRecord.hits;
                    masterRecord.totalInBytes = masterRecord.lastRequestInBytes;
                    if (this.record.lastRequestInBytes > masterRecord.longestInBytes) {
                        masterRecord.longestInBytes = this.record.lastRequestInBytes;
                    }
                    if (this.record.lastRequestInBytes < masterRecord.shortestInBytes) {
                        masterRecord.shortestInBytes = this.record.lastRequestInBytes;
                    }
                    recordMap.put(this.path, masterRecord);
                }
                ++masterRecord.hits;
                masterRecord.lastRequestTimestamp = this.record.lastRequestTimestamp;
                masterRecord.totalInBytes += this.record.lastRequestInBytes;
                masterRecord.lastRequestInBytes = this.record.lastRequestInBytes;
                if (this.record.lastRequestInBytes > masterRecord.longestInBytes) {
                    masterRecord.longestInBytes = this.record.lastRequestInBytes;
                }
                if (this.record.lastRequestInBytes < masterRecord.shortestInBytes) {
                    masterRecord.shortestInBytes = this.record.lastRequestInBytes;
                }
            }
        }
    }
}

