/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.jaxrpc.rpc.handler;

import com.idoox.soap.MustUnderstandException;
import com.systinet.wasp.rpc.handler.HPAdaptor;
import com.systinet.wasp.rpc.handler.HandlerRepositoryException;
import com.systinet.wasp.rpc.handler.WaspHandlerInfoImpl;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.idoox.wasp.SoapFaultException;
import org.idoox.xmlrpc.Constants;
import org.idoox.xmlrpc.header.HeaderProcessor;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.handler.WaspHandlerInfo;
import org.systinet.wasp.rpc.handler.WaspHandlerChain;
import org.systinet.wasp.rpc.handler.soap.WaspSOAPMessageContext;

public class HandlerChainImpl
extends ArrayList
implements WaspHandlerChain {
    private List handlerInfos;
    private boolean initialized = false;
    private String[] roles = new String[]{"http://schemas.xmlsoap.org/soap/actor/next", Constants.URI_SOAP12_ACTOR_NEXT};
    private List understoodHeaders = new ArrayList();
    private static String CURRENT_POSITION = "current.position.in.chain";
    private static String CURRENT_HANDLER_INFO = "current.handler.info";
    private PositionHelper positionHelper;
    private Map clazzTohandlerInstance;
    private int processingType;
    private HandlerRepository.DirectionPositionEntry[] positions;
    static /* synthetic */ Class class$org$idoox$xmlrpc$header$HeaderProcessor;

    public HandlerChainImpl(List handlerInfos, List currentToRealMap, Map instancePool, int processingType, HandlerRepository.DirectionPositionEntry[] positions) {
        this.init(handlerInfos, currentToRealMap, instancePool, processingType, positions);
    }

    public void init(List handlerInfos, List currentToRealMap, Map instancePool, int processingType, HandlerRepository.DirectionPositionEntry[] positions) {
        this.handlerInfos = handlerInfos;
        this.positionHelper = new PositionHelper(currentToRealMap);
        this.clazzTohandlerInstance = instancePool;
        this.processingType = processingType;
        this.positions = positions;
    }

    private void loadHandlerInstances() throws HandlerRepositoryException {
        int i = 0;
        while (i < this.handlerInfos.size()) {
            Handler handler = null;
            WaspHandlerInfoImpl handlerInfo = (WaspHandlerInfoImpl)this.handlerInfos.get(i);
            handler = this.getHandler(handlerInfo);
            this.add(handler);
            this.addUnderstoodHeaders(handler.getHeaders());
            ++i;
        }
    }

    private int getResponseStartPosition(MessageContext ctx) {
        return this.positionHelper.getResponseStartPosition(ctx);
    }

    private void setResponseStartPosition(MessageContext ctx, int i) {
        this.positionHelper.setResponseStartPosition(ctx, i);
    }

    private void releaseStartPosition(MessageContext ctx) {
        this.positionHelper.releaseStartPosition(ctx);
    }

    public boolean handleFault(MessageContext msgctx) {
        int startPosition;
        this.init();
        int i = startPosition = this.getResponseStartPosition(msgctx);
        while (i >= 0) {
            boolean goFurther = ((Handler)this.get(i)).handleFault(msgctx);
            if (!goFurther) {
                return false;
            }
            --i;
        }
        return true;
    }

    public boolean handleRequest(MessageContext msgctx) {
        return this.handleRequest(msgctx, 0);
    }

    public boolean handleRequest(MessageContext msgctx, int position) {
        this.init();
        if (this.processingType == 2) {
            this.checkMustUnderstand(msgctx);
        }
        boolean goFurther = true;
        int i = position;
        while (i < this.size()) {
            try {
                ((WaspSOAPMessageContext)msgctx).setPosition(this.positions[i]);
                goFurther = ((Handler)this.get(i)).handleRequest(msgctx);
            }
            catch (RuntimeException e) {
                this.setResponseStartPosition(msgctx, i);
                throw e;
            }
            if (!goFurther) {
                this.setResponseStartPosition(msgctx, i);
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean handleResponse(MessageContext msgctx) {
        return this.handleResponse(msgctx, -1, -1);
    }

    public boolean handleResponse(MessageContext msgctx, int fromPosition, int toPosition) {
        int currentPosition;
        this.init();
        if (this.processingType == 1) {
            this.checkMustUnderstand(msgctx);
        }
        if (fromPosition == -1) {
            fromPosition = this.size() - 1;
        }
        if (toPosition == -1) {
            toPosition = 0;
        }
        int i = currentPosition = (currentPosition = this.getResponseStartPosition(msgctx)) > fromPosition ? fromPosition : currentPosition;
        while (i >= toPosition) {
            boolean goFurther;
            try {
                ((WaspSOAPMessageContext)msgctx).setPosition(this.positions[i]);
                goFurther = ((Handler)this.get(i)).handleResponse(msgctx);
            }
            catch (RuntimeException e) {
                this.setResponseStartPosition(msgctx, i);
                throw e;
            }
            if (!goFurther) {
                this.setResponseStartPosition(msgctx, i);
                return false;
            }
            --i;
        }
        return true;
    }

    public boolean handleFault(MessageContext msgctx, int fromPosition, int toPosition) {
        int startPosition;
        this.init();
        if (fromPosition == -1) {
            fromPosition = this.size() - 1;
        }
        if (toPosition == -1) {
            toPosition = 0;
        }
        int i = startPosition = (startPosition = this.getResponseStartPosition(msgctx)) > fromPosition ? fromPosition : startPosition;
        while (i >= toPosition) {
            boolean goFurther = ((Handler)this.get(i)).handleFault(msgctx);
            if (!goFurther) {
                return false;
            }
            --i;
        }
        return true;
    }

    private void init() throws JAXRPCException {
        try {
            HandlerChainImpl handlerChainImpl = this;
            synchronized (handlerChainImpl) {
                if (!this.initialized) {
                    this.loadHandlerInstances();
                    this.initialized = true;
                }
            }
        }
        catch (HandlerRepositoryException e) {
            throw new JAXRPCException("Unable to initialize handler chain!", (Throwable)e);
        }
    }

    public void init(Map config) {
    }

    public void destroy() {
        this.clear();
    }

    public void setRoles(String[] soapActorNames) {
        this.roles = soapActorNames;
    }

    public String[] getRoles() {
        return this.roles;
    }

    private void addUnderstoodHeaders(QName[] understoodHeaders) {
        if (understoodHeaders != null) {
            this.understoodHeaders.addAll(Arrays.asList(understoodHeaders));
        }
    }

    private void checkMustUnderstand(MessageContext mc) {
        if (!mc.containsProperty("MessageSourceImpl.headerPresent")) {
            return;
        }
        SOAPMessage soapMessage = ((SOAPMessageContext)mc).getMessage();
        SOAPHeader header = null;
        try {
            header = soapMessage.getSOAPPart().getEnvelope().getHeader();
        }
        catch (SOAPException e) {
            throw new SoapFaultException();
        }
        if (header == null) {
            return;
        }
        Iterator headers = header.getChildElements();
        while (headers.hasNext()) {
            Name name;
            QName qname;
            SOAPHeaderElement headerEl;
            Object o = headers.next();
            if (!(o instanceof SOAPHeaderElement) || !(headerEl = (SOAPHeaderElement)o).getMustUnderstand() || this.understoodHeaders.contains(qname = new QName((name = headerEl.getElementName()).getURI(), name.getLocalName()))) continue;
            throw new MustUnderstandException(new QName[]{qname});
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.handlerInfos.iterator();
        sb.append("Handler chain\n");
        sb.append(" Handler infos\n");
        while (it.hasNext()) {
            WaspHandlerInfo hi = (WaspHandlerInfo)it.next();
            sb.append(hi);
        }
        sb.append(" Handler classes\n");
        it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        return sb.toString();
    }

    private Handler getHandler(WaspHandlerInfoImpl handlerInfo) throws HandlerRepositoryException {
        Class clazz = handlerInfo.getHandlerClass();
        Object handler = handlerInfo.getHandlerInstance();
        if (null == handler && !(class$org$idoox$xmlrpc$header$HeaderProcessor == null ? (class$org$idoox$xmlrpc$header$HeaderProcessor = HandlerChainImpl.class$("org.idoox.xmlrpc.header.HeaderProcessor")) : class$org$idoox$xmlrpc$header$HeaderProcessor).isAssignableFrom(clazz)) {
            handler = (Handler)this.clazzTohandlerInstance.get(clazz);
        }
        if (handler == null) {
            Object instance;
            try {
                instance = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new HandlerRepositoryException("Unable to instantiate jax-rpc handler:" + clazz.getName());
            }
            catch (IllegalAccessException e) {
                throw new HandlerRepositoryException("Unable to instantiate jax-rpc handler:" + clazz.getName());
            }
            handler = instance instanceof HeaderProcessor ? new HPAdaptor((HeaderProcessor)instance, (WaspHandlerInfo)handlerInfo) : (Handler)instance;
            handlerInfo.setHandlerInstance(handler);
            this.clazzTohandlerInstance.put(clazz, handler);
        }
        handlerInfo.initHandler();
        return handler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PositionHelper {
        List currentPositionToRealPosition = new ArrayList();
        final int maxPosition;

        public PositionHelper(List currentPositionToRealPosition) {
            this.currentPositionToRealPosition = currentPositionToRealPosition;
            this.maxPosition = currentPositionToRealPosition.size() - 1;
        }

        public int getResponseStartPosition(MessageContext msgCtx) {
            String instanceName = (String)msgCtx.getProperty(CURRENT_POSITION);
            if (instanceName == null) {
                return this.maxPosition;
            }
            return this.realPositionToCurrentPosition(instanceName);
        }

        public void setResponseStartPosition(MessageContext msgCtx, int position) {
            String instanceName = (String)this.currentPositionToRealPosition.get(position);
            msgCtx.setProperty(CURRENT_POSITION, (Object)instanceName);
        }

        private int realPositionToCurrentPosition(String instanceName) {
            return this.currentPositionToRealPosition.indexOf(instanceName);
        }

        public void releaseStartPosition(MessageContext msgCtx) {
            msgCtx.setProperty(CURRENT_POSITION, null);
        }

        public void setCurrentHandler(MessageContext msgCtx, WaspHandlerInfo info) {
            msgCtx.setProperty(CURRENT_HANDLER_INFO, (Object)info);
        }
    }
}

