/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.jaxm.messaging;

import com.idoox.debug.Category;
import com.systinet.jaxm.messaging.ProviderMetaDataImpl;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.messaging.Endpoint;
import javax.xml.messaging.JAXMException;
import javax.xml.messaging.ProviderMetaData;
import javax.xml.messaging.URLEndpoint;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.idoox.wasp.Context;
import org.idoox.wasp.ProtocolRepository;
import org.systinet.wasp.async.AsyncConversation;
import org.systinet.wasp.client.XMLInvocationException;
import org.systinet.wasp.client.XMLInvocationHelper;
import org.systinet.wasp.messaging.WaspProviderConnection;
import org.systinet.wasp.webservice.ServiceClient;

public class ProviderConnectionImpl
extends SOAPConnection
implements WaspProviderConnection {
    private static final Category log = Category.getCategory((String)"com.systinet.jaxm.messaging.ProviderConnectionImpl");
    private ProtocolRepository repository = (ProtocolRepository)Context.getInstance((String)"org.idoox.wasp.ProtocolRepository");
    private ProviderMetaDataImpl metadata = new ProviderMetaDataImpl(this.repository.getProtocolNames().toArray(new String[0]));

    public ProviderMetaData getMetaData() throws JAXMException {
        return this.metadata;
    }

    public MessageFactory createMessageFactory(String profile) throws JAXMException {
        try {
            return this.repository.createMessageFactory(profile);
        }
        catch (SOAPException e) {
            throw new JAXMException((Throwable)e);
        }
    }

    public void send(SOAPMessage message) throws JAXMException {
        throw new JAXMException("Systinet Server provider connection isn't able to send a message to unknown endpoint. Please use WaspProviderConnection or SOAPConnection instead.");
    }

    public void send(SOAPMessage message, String endpoint) throws JAXMException {
        ServiceClient client = ServiceClient.create();
        client.setServiceURL(endpoint);
        this.send(message, client);
    }

    public void send(SOAPMessage message, ServiceClient client) throws JAXMException {
        try {
            XMLInvocationHelper.send((SOAPMessage)message, (ServiceClient)client);
        }
        catch (RemoteException e) {
            throw new JAXMException((Throwable)e);
        }
    }

    public AsyncConversation beginSend(SOAPMessage message, String endpoint) throws JAXMException {
        ServiceClient client = ServiceClient.create();
        client.setServiceURL(endpoint);
        return this.beginSend(message, client);
    }

    public AsyncConversation beginSend(SOAPMessage message, ServiceClient serviceClient) throws JAXMException {
        try {
            return XMLInvocationHelper.beginSend((SOAPMessage)message, (ServiceClient)serviceClient);
        }
        catch (RemoteException e) {
            throw new JAXMException((Throwable)e);
        }
    }

    public void endSend(AsyncConversation asyncConversation) throws JAXMException {
        try {
            XMLInvocationHelper.endSend((AsyncConversation)asyncConversation);
        }
        catch (RemoteException e) {
            throw new JAXMException((Throwable)e);
        }
    }

    public void endSend(AsyncConversation asyncConversation, ServiceClient serviceClient) throws JAXMException {
        try {
            XMLInvocationHelper.endSend((AsyncConversation)asyncConversation, (ServiceClient)serviceClient);
        }
        catch (RemoteException e) {
            throw new JAXMException((Throwable)e);
        }
    }

    public SOAPMessage call(SOAPMessage request, Object endpoint) throws SOAPException {
        ServiceClient client = ServiceClient.create();
        if (endpoint instanceof String) {
            client.setServiceURL((String)endpoint);
        } else if (endpoint instanceof URL) {
            client.setServiceURL(((URL)endpoint).toExternalForm());
        } else if (endpoint instanceof URLEndpoint) {
            client.setServiceURL(((URLEndpoint)endpoint).getURL());
        } else if (endpoint instanceof Endpoint) {
            client.setServiceURL(endpoint.toString());
        } else {
            throw new SOAPException("Bad endpoint type '" + endpoint.getClass() + "'");
        }
        return this.call(request, client);
    }

    public SOAPMessage call(SOAPMessage request, String endpoint) throws JAXMException {
        ServiceClient client = ServiceClient.create();
        client.setServiceURL(endpoint);
        return this.call(request, client);
    }

    public SOAPMessage call(SOAPMessage request, ServiceClient client) throws JAXMException {
        try {
            return XMLInvocationHelper.call((SOAPMessage)request, (ServiceClient)client, (boolean)true);
        }
        catch (RemoteException e) {
            throw new JAXMException((Throwable)e);
        }
        catch (XMLInvocationException e2) {
            throw new JAXMException((Throwable)e2);
        }
    }

    public AsyncConversation beginCall(SOAPMessage request, String endpoint) throws JAXMException {
        ServiceClient client = ServiceClient.create();
        client.setServiceURL(endpoint);
        try {
            return XMLInvocationHelper.beginCall((SOAPMessage)request, (ServiceClient)client, (boolean)true);
        }
        catch (RemoteException e1) {
            throw new JAXMException((Throwable)e1);
        }
        catch (XMLInvocationException e) {
            throw new JAXMException((Throwable)e);
        }
    }

    public AsyncConversation beginCall(SOAPMessage request, ServiceClient client) throws JAXMException {
        try {
            return XMLInvocationHelper.beginCall((SOAPMessage)request, (ServiceClient)client, (boolean)true);
        }
        catch (RemoteException e1) {
            throw new JAXMException((Throwable)e1);
        }
        catch (XMLInvocationException e) {
            throw new JAXMException((Throwable)e);
        }
    }

    public SOAPMessage endCall(AsyncConversation asyncConversation) throws JAXMException {
        try {
            return XMLInvocationHelper.endCall((AsyncConversation)asyncConversation, (boolean)true);
        }
        catch (RemoteException e1) {
            throw new JAXMException((Throwable)e1);
        }
        catch (XMLInvocationException e) {
            throw new JAXMException((Throwable)e);
        }
    }

    public SOAPMessage endCall(AsyncConversation asyncConversation, ServiceClient serviceClient) throws JAXMException {
        try {
            return XMLInvocationHelper.endCall((AsyncConversation)asyncConversation, (ServiceClient)serviceClient, (boolean)true);
        }
        catch (RemoteException e1) {
            throw new JAXMException((Throwable)e1);
        }
        catch (XMLInvocationException e) {
            throw new JAXMException((Throwable)e);
        }
    }

    public synchronized void close() throws JAXMException {
    }
}

