/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.idoox.debug.Category;
import com.systinet.uddi.database.ConnectionMonitor;
import com.systinet.uddi.database.ConnectionPool;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.TransactionInfo;
import com.systinet.uddi.database.TransactionInitializerHelper;
import com.systinet.uddi.database.utils.FramedThreadLocalMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class TransactionManager {
    private ConnectionPool connectionPool;
    private String connectionIdentifier;
    private String infoIdentifier;
    private TransactionInitializerHelper transactionInitializerHelper;
    private static int idGenerator = 0;
    private static Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.TransactionManager");

    private static synchronized int genId() {
        return idGenerator++;
    }

    public TransactionManager(ConnectionPool connectionPool) {
        this(connectionPool, "" + TransactionManager.genId());
    }

    public TransactionManager(ConnectionPool connectionPool, String id) {
        this.connectionIdentifier = id + "_TM_CONNECTION";
        this.infoIdentifier = id + "_TM_INFO";
        this.init(connectionPool);
        this.transactionInitializerHelper = new TransactionInitializerHelper();
    }

    private void init(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void beginReadOnly() throws DatabaseCoreException {
        TransactionInfo info = this.getTransactionInfo();
        info.beginReadOnly();
    }

    public void beginReadWrite() throws DatabaseCoreException {
        TransactionInfo info = this.getTransactionInfo();
        info.beginReadWrite();
    }

    private TransactionInfo getTransactionInfo() throws DatabaseCoreException {
        TransactionInfo info = (TransactionInfo)FramedThreadLocalMap.get(this.infoIdentifier);
        if (info == null) {
            Connection conn = null;
            while (!this.isAlive(conn = this.getConnectionFromPool())) {
                log.warn("Reinitializing JDBC connection pool");
                this.connectionPool.reinit();
                conn = this.getConnectionFromPool();
            }
            FramedThreadLocalMap.set(this.connectionIdentifier, new ConnectionMonitor(conn, this.connectionPool.getPreparedStatementCache()));
            info = new TransactionInfo();
            FramedThreadLocalMap.set(this.infoIdentifier, info);
            this.transactionInitializerHelper.initTransaction(conn);
        }
        return info;
    }

    private Connection getConnectionFromPool() throws DatabaseCoreException {
        Connection conn = null;
        try {
            conn = this.connectionPool.getConnection();
        }
        catch (SQLException e) {
            throw new DatabaseCoreException(12021, DatabaseCoreBundle.getString("ERROR_12021_ObtainConnection"), e);
        }
        if (conn == null) {
            throw new DatabaseCoreException(12021, DatabaseCoreBundle.getString("ERROR_12021_ObtainConnection"));
        }
        return conn;
    }

    public void end() throws DatabaseCoreException {
        TransactionInfo info = (TransactionInfo)FramedThreadLocalMap.get(this.infoIdentifier);
        if (info == null) {
            throw new DatabaseCoreException(12031, DatabaseCoreBundle.getString("ERROR_12031_NoTransaction"));
        }
        info.end();
        if (info.getDeep() == 0) {
            ConnectionMonitor connection = (ConnectionMonitor)FramedThreadLocalMap.get(this.connectionIdentifier);
            FramedThreadLocalMap.set(this.connectionIdentifier, null);
            FramedThreadLocalMap.set(this.infoIdentifier, null);
            try {
                connection.rollback();
                this.connectionPool.releaseConnection(connection.getUnderliedConnection());
                connection.invalidateConnection();
            }
            catch (SQLException e) {
                throw new DatabaseCoreException(12032, DatabaseCoreBundle.getString("ERROR_12032_InTransaction"), e);
            }
        }
    }

    public void commit() throws SQLException, DatabaseCoreException {
        TransactionInfo info = (TransactionInfo)FramedThreadLocalMap.get(this.infoIdentifier);
        if (info == null) {
            throw new DatabaseCoreException(12031, DatabaseCoreBundle.getString("ERROR_12031_NoTransaction"));
        }
        info.commit();
        if (info.getDeep() == 0) {
            ConnectionMonitor connection = (ConnectionMonitor)FramedThreadLocalMap.get(this.connectionIdentifier);
            connection.commit();
            FramedThreadLocalMap.set(this.connectionIdentifier, null);
            FramedThreadLocalMap.set(this.infoIdentifier, null);
            this.connectionPool.releaseConnection(connection.getUnderliedConnection());
            connection.invalidateConnection();
        }
    }

    public void rollback() throws DatabaseCoreException {
        TransactionInfo info = (TransactionInfo)FramedThreadLocalMap.get(this.infoIdentifier);
        if (info == null) {
            throw new DatabaseCoreException(12031, DatabaseCoreBundle.getString("ERROR_12031_NoTransaction"));
        }
        info.rollback();
        if (info.getDeep() == 0) {
            ConnectionMonitor connection = (ConnectionMonitor)FramedThreadLocalMap.get(this.connectionIdentifier);
            FramedThreadLocalMap.set(this.connectionIdentifier, null);
            FramedThreadLocalMap.set(this.infoIdentifier, null);
            try {
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    log.debug("rollback:", (Throwable)e);
                    throw new DatabaseCoreException(12032, DatabaseCoreBundle.getString("ERROR_12032_InTransaction"), e);
                }
                Object var5_3 = null;
                this.connectionPool.releaseConnection(connection.getUnderliedConnection());
                connection.invalidateConnection();
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.connectionPool.releaseConnection(connection.getUnderliedConnection());
                connection.invalidateConnection();
                throw throwable;
            }
        }
    }

    public ConnectionMonitor getConnection() {
        return (ConnectionMonitor)FramedThreadLocalMap.get(this.connectionIdentifier);
    }

    public long getTransactionId() {
        return ((TransactionInfo)FramedThreadLocalMap.get(this.infoIdentifier)).getTransactionId();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAlive(Connection connection) {
        String checkDatabase = this.connectionPool.getDummyQuery();
        Statement stmt = null;
        stmt = connection.createStatement();
        stmt.executeQuery(checkDatabase);
        Object var7_4 = null;
        if (stmt == null) return true;
        try {
            stmt.close();
            return true;
        }
        catch (SQLException e2) {
            log.warn("SQLException in isAlive: ", (Throwable)e2);
        }
        return true;
        {
            catch (Exception e) {
                boolean bl = false;
                Object var7_5 = null;
                if (stmt == null) return bl;
                try {
                    stmt.close();
                    return bl;
                }
                catch (SQLException e2) {
                    log.warn("SQLException in isAlive: ", (Throwable)e2);
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException e2) {
                log.warn("SQLException in isAlive: ", (Throwable)e2);
            }
            throw throwable;
        }
    }

    public TransactionInitializerHelper getTransactionInitializerHelper() {
        return this.transactionInitializerHelper;
    }

    public boolean transactionStarted() {
        return FramedThreadLocalMap.get(this.infoIdentifier) != null;
    }

    public TransactionContext suspendTransaction() {
        TransactionInfo info = (TransactionInfo)FramedThreadLocalMap.get(this.infoIdentifier);
        ConnectionMonitor conn = (ConnectionMonitor)FramedThreadLocalMap.get(this.connectionIdentifier);
        if (info == null && conn == null) {
            return null;
        }
        if (info == null || conn == null) {
            throw new IllegalStateException("Internal error in db_core, tx context not complete");
        }
        FramedThreadLocalMap.set(this.connectionIdentifier, null);
        FramedThreadLocalMap.set(this.infoIdentifier, null);
        return new TransactionContext(info, conn);
    }

    public void resumeTransaction(TransactionContext contextToRestore) {
        if (this.transactionStarted()) {
            throw new IllegalStateException("Incorrect db_core use: tx already running");
        }
        if (contextToRestore.info == null || contextToRestore.connection == null) {
            throw new IllegalArgumentException("Invalid contextToRestore");
        }
        FramedThreadLocalMap.set(this.connectionIdentifier, contextToRestore.connection);
        FramedThreadLocalMap.set(this.infoIdentifier, contextToRestore.info);
        contextToRestore.connection = null;
        contextToRestore.info = null;
    }

    public static class TransactionContext {
        private TransactionInfo info;
        private ConnectionMonitor connection;

        private TransactionContext(TransactionInfo info, ConnectionMonitor connection) {
            this.info = info;
            this.connection = connection;
        }

        public boolean isRollbacked() {
            return this.info.rollback;
        }

        public String toString() {
            return "TransactionContext: info=" + this.info + ", connection=" + this.connection;
        }
    }
}

