/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.idoox.debug.Category;
import com.systinet.uddi.database.AbstractManager;
import com.systinet.uddi.database.ApiManager;
import com.systinet.uddi.database.ConnectionInitializerManager;
import com.systinet.uddi.database.ConnectionMonitor;
import com.systinet.uddi.database.DatabaseConfigHelper;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.DriverManager;
import com.systinet.uddi.database.Quoter;
import com.systinet.uddi.database.QuoterManager;
import com.systinet.uddi.database.Shutdown;
import com.systinet.uddi.database.TransactionInitializerHelper;
import com.systinet.uddi.database.TransactionManager;
import com.systinet.uddi.database.UDDIDriverManager;
import com.systinet.uddi.database.config.ConnectionPool;
import com.systinet.uddi.database.config.DatabaseConfig;
import java.sql.Connection;
import java.sql.SQLException;

public class Database
implements AbstractManager {
    private TransactionManager transactionManager;
    private com.systinet.uddi.database.ConnectionPool connectionPool;
    private DriverManager driverManager;
    private QuoterManager quoter;
    private ConnectionInitializerManager connectionInitializer;
    private ApiManager apiManager;
    private static Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.Database");
    private boolean registered = false;
    static /* synthetic */ Class class$com$systinet$uddi$database$Quoter;
    static /* synthetic */ Class class$com$systinet$uddi$database$ConnectionInitializer;
    static /* synthetic */ Class class$com$systinet$uddi$database$Driver;
    static /* synthetic */ Class class$com$systinet$uddi$database$Shutdown;

    public Database(ApiManager apiManager) {
        this.apiManager = apiManager;
        this.quoter = new QuoterManager();
        this.connectionInitializer = new ConnectionInitializerManager();
        this.driverManager = new UDDIDriverManager(this.connectionInitializer);
        this.connectionPool = new com.systinet.uddi.database.ConnectionPool();
        this.transactionManager = new TransactionManager(this.connectionPool);
    }

    public void init() throws DatabaseCoreException {
        String quoterImpl;
        DatabaseConfigHelper databaseConfigHelper = this.apiManager.getDatabaseConfigHelper();
        if (!this.registered) {
            databaseConfigHelper.register(this);
            this.registered = true;
        }
        if ((quoterImpl = databaseConfigHelper.getDatabaseDependantBackendMap((class$com$systinet$uddi$database$Quoter == null ? (class$com$systinet$uddi$database$Quoter = Database.class$("com.systinet.uddi.database.Quoter")) : class$com$systinet$uddi$database$Quoter).getName())) == null) {
            throw new DatabaseCoreException(12044, DatabaseCoreBundle.getString("ERROR_12044_MissingDbMapping_P1", (class$com$systinet$uddi$database$Quoter == null ? (class$com$systinet$uddi$database$Quoter = Database.class$("com.systinet.uddi.database.Quoter")) : class$com$systinet$uddi$database$Quoter).getName()));
        }
        this.quoter.init(quoterImpl);
        String connectionInitializerImpl = databaseConfigHelper.getDatabaseDependantBackendMap((class$com$systinet$uddi$database$ConnectionInitializer == null ? (class$com$systinet$uddi$database$ConnectionInitializer = Database.class$("com.systinet.uddi.database.ConnectionInitializer")) : class$com$systinet$uddi$database$ConnectionInitializer).getName());
        this.connectionInitializer.init(connectionInitializerImpl);
        String driverImpl = databaseConfigHelper.getDatabaseDependantBackendMap((class$com$systinet$uddi$database$Driver == null ? (class$com$systinet$uddi$database$Driver = Database.class$("com.systinet.uddi.database.Driver")) : class$com$systinet$uddi$database$Driver).getName());
        if (driverImpl == null) {
            throw new DatabaseCoreException(12044, DatabaseCoreBundle.getString("ERROR_12044_MissingDbMapping_P1", (class$com$systinet$uddi$database$Driver == null ? (class$com$systinet$uddi$database$Driver = Database.class$("com.systinet.uddi.database.Driver")) : class$com$systinet$uddi$database$Driver).getName()));
        }
        DatabaseConfig.Database db = databaseConfigHelper.getDatabase();
        this.driverManager.init(driverImpl, db.getDriverProperty());
        ConnectionPool poolConfig = db.getConnectionPool();
        if (poolConfig == null) {
            log.debug("connection pool missing");
            throw new DatabaseCoreException(12042, DatabaseCoreBundle.getString("ERROR_12042_MissingElement_P1", "database/poolConfig"));
        }
        this.connectionPool.init(this.driverManager, poolConfig.getDefaultPoolSize(), poolConfig.getMaxPoolSize(), poolConfig.getPoolCleaningInterval(), poolConfig.getPreparedStatementCacheSize());
    }

    public void shutdown() {
        try {
            Shutdown shutdown = (Shutdown)this.apiManager.getDatabaseDependantInstance((class$com$systinet$uddi$database$Shutdown == null ? (class$com$systinet$uddi$database$Shutdown = Database.class$("com.systinet.uddi.database.Shutdown")) : class$com$systinet$uddi$database$Shutdown).getName());
            shutdown.shutdown(this.connectionPool);
        }
        catch (DatabaseCoreException e) {
            log.info("DatabaseCoreException", (Throwable)((Object)e));
        }
        catch (SQLException e) {
            log.info("SQLException", (Throwable)e);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Quoter getQuoter() {
        return this.quoter;
    }

    public TransactionInitializerHelper getTransactionInitializerHelper() {
        return this.transactionManager.getTransactionInitializerHelper();
    }

    public ConnectionMonitor getNoTxConnection() throws DatabaseCoreException {
        try {
            Connection conn = this.connectionPool.getConnection();
            conn.setAutoCommit(true);
            return new ConnectionMonitor(conn, this.connectionPool.getPreparedStatementCache());
        }
        catch (SQLException e) {
            throw new DatabaseCoreException(12021, DatabaseCoreBundle.getString("ERROR_12021_ObtainConnection"), e);
        }
    }

    public void releaseNoTxConnection(ConnectionMonitor connMon) throws DatabaseCoreException {
        try {
            connMon.getUnderliedConnection().setAutoCommit(false);
            this.connectionPool.releaseConnection(connMon.getUnderliedConnection());
            connMon.invalidateConnection();
        }
        catch (SQLException e) {
            throw new DatabaseCoreException(12032, DatabaseCoreBundle.getString("ERROR_12032_InTransaction"), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

