/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.idoox.debug.Category;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.Driver;
import com.systinet.uddi.database.PreparedStatementCache;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class ConnectionPool {
    protected Vector pool = null;
    protected Vector allConnections = null;
    private PreparedStatementCache pstmtCache = null;
    private Driver driver;
    private Timer timer = null;
    private static Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.ConnectionPool");
    private int currentlyUsedConnections;
    private int maxUsedTogether;
    private int defaultPoolSize;
    private int maxPoolSize;
    private int cleaningInterval;
    private int preparedStatementCacheSize;

    public synchronized void init(Driver driver, int defaultPoolSize, int maxPoolSize, int cleaningInterval, int preparedStatementCacheSize) throws DatabaseCoreException {
        this.driver = driver;
        this.defaultPoolSize = defaultPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.cleaningInterval = cleaningInterval;
        this.preparedStatementCacheSize = preparedStatementCacheSize;
        this.reinit();
    }

    public synchronized void reinit() throws DatabaseCoreException {
        if (this.pstmtCache != null) {
            this.pstmtCache.destroy();
        }
        if (this.allConnections != null) {
            this.closeConnections();
        }
        this.pool = new Vector(this.defaultPoolSize);
        this.allConnections = new Vector(this.defaultPoolSize);
        this.pstmtCache = new PreparedStatementCache(this.preparedStatementCacheSize);
        try {
            int i = 0;
            while (i < this.defaultPoolSize) {
                Connection connection = this.driver.getConnection();
                if (connection == null) {
                    throw new DatabaseCoreException(12021, DatabaseCoreBundle.getString("ERROR_12021_ObtainConnection"));
                }
                this.pool.add(connection);
                this.allConnections.add(connection);
                ++i;
            }
        }
        catch (SQLException e) {
            throw new DatabaseCoreException(12021, DatabaseCoreBundle.getString("ERROR_12021_ObtainConnection"), e);
        }
        this.timer = new Timer(true);
        long interval = this.cleaningInterval * 1000 * 60 * 60;
        this.timer.schedule((TimerTask)new ConnectionPoolSweeper(), interval, interval);
        this.currentlyUsedConnections = 0;
        this.maxUsedTogether = 0;
        log.debug("Initialization, maxPoolSize: " + this.maxPoolSize + ", currentlyUsedConnections: " + this.currentlyUsedConnections);
    }

    public void destroy() {
        if (this.pstmtCache != null) {
            this.pstmtCache.destroy();
        }
        this.closeConnections();
    }

    public synchronized void sweepConnections() {
        log.debug("sweepConnections()");
        int toClose = this.allConnections.size() - Math.max(this.defaultPoolSize, this.maxUsedTogether);
        while (toClose > 0) {
            int index = this.pool.size() - 1;
            if (index < 0) break;
            Connection conn = (Connection)this.pool.get(index);
            this.pool.remove(index);
            this.allConnections.remove(conn);
            --toClose;
            try {
                this.pstmtCache.closeConnection(conn);
                conn.close();
            }
            catch (SQLException e) {
                log.error(DatabaseCoreBundle.getString("ERROR_12062_CloseConnection"), (Throwable)e);
            }
        }
        this.maxUsedTogether = this.currentlyUsedConnections;
    }

    public synchronized void closeConnections() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.allConnections != null) {
            while (this.allConnections.size() > 0) {
                Connection conn = (Connection)this.allConnections.remove(0);
                try {
                    this.pstmtCache.closeConnection(conn);
                    conn.close();
                }
                catch (SQLException e) {
                    log.error(DatabaseCoreBundle.getString("ERROR_12062_CloseConnection"), (Throwable)e);
                }
            }
        }
        this.allConnections = new Vector();
        this.pool = new Vector();
    }

    public synchronized Connection getConnection() throws SQLException, DatabaseCoreException {
        Connection connection = this.getConnectionFromPool();
        if (connection == null) {
            if (this.currentlyUsedConnections < this.maxPoolSize) {
                connection = this.driver.getConnection();
                if (connection == null) {
                    throw new DatabaseCoreException(12021, DatabaseCoreBundle.getString("ERROR_12021_ObtainConnection"));
                }
                this.allConnections.add(connection);
            } else {
                do {
                    try {
                        log.debug("wait ...");
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        log.debug("... wake up");
                    }
                } while ((connection = this.getConnectionFromPool()) == null);
            }
        }
        ++this.currentlyUsedConnections;
        log.debug("Number of the currently used connections has been increased to " + this.currentlyUsedConnections);
        if (this.maxUsedTogether < this.currentlyUsedConnections) {
            this.maxUsedTogether = this.currentlyUsedConnections;
        }
        return connection;
    }

    private synchronized Connection getConnectionFromPool() {
        if (this.pool.size() > 0) {
            return (Connection)this.pool.remove(0);
        }
        return null;
    }

    public synchronized void releaseConnection(Connection conn) {
        --this.currentlyUsedConnections;
        log.debug("Number of the currently used connections has been decreased to " + this.currentlyUsedConnections);
        this.pool.add(conn);
        this.notifyAll();
    }

    String getDummyQuery() {
        return this.driver.getDummyQuery();
    }

    PreparedStatementCache getPreparedStatementCache() {
        return this.pstmtCache;
    }

    class ConnectionPoolSweeper
    extends TimerTask {
        ConnectionPoolSweeper() {
        }

        public void run() {
            ConnectionPool.this.sweepConnections();
        }
    }
}

