/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.config;

import com.systinet.monitoring.LogEvent;
import com.systinet.uddi.util.ApplicationCoreBundle;
import java.util.HashMap;

public class ConfigReloadEvent
extends LogEvent {
    public static final String EVENT_TYPE = "CFGCHANGE";
    public static final String CONFIG_NAMES_PARAMETER = "configNames";

    public ConfigReloadEvent(String configName) {
        super(EVENT_TYPE);
        this.message = ApplicationCoreBundle.getString("EVENT_ConfigurationChanged_P1", configName);
        this.eventParameters = new HashMap();
        this.eventParameters.put(CONFIG_NAMES_PARAMETER, new String[]{configName});
    }

    public ConfigReloadEvent(String[] configNames) {
        super(EVENT_TYPE);
        StringBuffer names = new StringBuffer();
        if (configNames != null) {
            int i = 0;
            while (i < configNames.length) {
                names.append(configNames[i]);
                if (i < configNames.length - 1) {
                    names.append(",");
                }
                ++i;
            }
        }
        this.message = ApplicationCoreBundle.getString("EVENT_ConfigurationChanged_P1", names);
        this.eventParameters = new HashMap();
        this.eventParameters.put(CONFIG_NAMES_PARAMETER, configNames);
    }

    public boolean isConfigReloaded(String configName) {
        if (configName == null || this.eventParameters == null) {
            return false;
        }
        String[] configNames = (String[])this.eventParameters.get(CONFIG_NAMES_PARAMETER);
        if (configNames == null) {
            return false;
        }
        int i = 0;
        while (i < configNames.length) {
            if (configName.equals(configNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getConfigNames() {
        return (String[])this.eventParameters.get(CONFIG_NAMES_PARAMETER);
    }
}

