/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.tablemodel;

import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.tablemodel.Column;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Table {
    private String name = null;
    private List columns = new ArrayList();
    private List unmodifiableColumns = Collections.unmodifiableList(this.columns);
    private Map nameToColumn = new HashMap();
    private List primaryKey = new ArrayList();

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new NullPointerException("'name' must not be null or empty");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Column getSimplePrimaryKey() {
        if (this.primaryKey.size() == 1) {
            return (Column)this.primaryKey.get(0);
        }
        return null;
    }

    public boolean hasPrimaryKey() {
        return !this.primaryKey.isEmpty();
    }

    public boolean hasComposedPrimaryKey() {
        return this.primaryKey.size() > 1;
    }

    public List getPrimaryKey() {
        return Collections.unmodifiableList(this.primaryKey);
    }

    public void addColumn(Column col) throws PersistenceException {
        if (this.hasColumn(col.getName())) {
            throw new PersistenceException(col.getName() + " already in this table " + this.name);
        }
        if (col.isPrimaryKey()) {
            this.primaryKey.add(col);
        }
        this.columns.add(col);
        this.nameToColumn.put(col.getName(), col);
    }

    public boolean hasColumn(String name) {
        return this.nameToColumn.containsKey(name);
    }

    public Column getColumn(String name) {
        return (Column)this.nameToColumn.get(name);
    }

    public List columns() {
        return this.unmodifiableColumns;
    }

    public String toString() {
        return "Table " + this.name + " " + this.columns;
    }
}

