/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.tablemodel;

public class Column {
    protected Class javaType;
    protected String columnName;
    protected boolean isPK;
    protected boolean isFK;
    protected String fkReferences;

    public Column(String name, Class javaType) {
        this.privSetJavaType(javaType);
        this.setColumnName(name);
    }

    private void privSetJavaType(Class type) {
        if (type == null) {
            throw new NullPointerException("'type' must not be null");
        }
        this.javaType = type;
    }

    private void setColumnName(String name) {
        if (name == null || name.length() == 0) {
            throw new NullPointerException("'name' must nost be null or empty");
        }
        this.columnName = name;
        this.detectPkAndFk();
    }

    protected void detectPkAndFk() {
        this.isPK = this.columnName.endsWith("PK");
        if (this.columnName.endsWith("FK")) {
            this.isFK = true;
            this.fkReferences = this.columnName.substring(0, 1).toUpperCase() + this.columnName.substring(1, this.columnName.length() - 2);
        } else {
            this.isFK = false;
            this.fkReferences = null;
        }
    }

    public String getName() {
        return this.columnName;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public boolean isPrimaryKey() {
        return this.isPK;
    }

    public boolean isForeignKey() {
        return this.isFK;
    }

    public String foreingKeyReferences() {
        return this.fkReferences;
    }

    public String toString() {
        return "Column " + this.columnName + " " + this.javaType;
    }
}

